/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.user;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authentication.PasswordAlreadyUsedException;
import com.logicaldoc.core.security.authentication.PasswordWeakException;
import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.core.security.user.GroupDAO;
import com.logicaldoc.core.security.user.GroupType;
import com.logicaldoc.core.security.user.PasswordHistory;
import com.logicaldoc.core.security.user.PasswordHistoryDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserEvent;
import com.logicaldoc.core.security.user.UserGroup;
import com.logicaldoc.core.security.user.UserHistory;
import com.logicaldoc.core.security.user.UserHistoryDAO;
import com.logicaldoc.core.security.user.UserListener;
import com.logicaldoc.core.security.user.UserListenerManager;
import com.logicaldoc.core.security.user.UserSource;
import com.logicaldoc.core.security.user.UserType;
import com.logicaldoc.core.security.user.WorkingTime;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.html.HTMLSanitizer;
import com.logicaldoc.util.security.PasswordCriteria;
import com.logicaldoc.util.security.PasswordValidator;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="userDAO")
@Transactional
public class HibernateUserDAO
extends HibernatePersistentObjectDAO<User>
implements UserDAO {
    private static final String ADMIN = "admin";
    private static final String LOWER = "lower(";
    private static final String USERNAME = "username";
    @Resource(name="genericDAO")
    private GenericDAO genericDAO;
    @Resource(name="userHistoryDAO")
    private UserHistoryDAO userHistoryDAO;
    @Resource(name="passwordHistoryDAO")
    private PasswordHistoryDAO passwordHistoryDAO;
    @Resource(name="userListenerManager")
    private UserListenerManager userListenerManager;
    @Resource(name="ContextProperties")
    private ContextProperties config;

    private HibernateUserDAO() {
        super(User.class);
        this.log = LoggerFactory.getLogger(HibernateUserDAO.class);
    }

    public static boolean ignoreCaseLogin() {
        return "true".equals(Context.get().getProperties().getProperty("login.ignorecase"));
    }

    @Override
    public List<User> findByName(String name) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name.toLowerCase());
        return this.findByWhere("lower(_entity.name) like :name", params, null, null);
    }

    @Override
    public User findByUsername(String username) throws PersistenceException {
        if (StringUtils.isEmpty(username)) {
            return null;
        }
        User user = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USERNAME, username);
        List coll = this.findByWhere("_entity.username = :username", params, null, null);
        if (CollectionUtils.isNotEmpty(coll)) {
            user = (User)coll.iterator().next();
        }
        this.initialize(user);
        return user;
    }

    @Override
    public User findByUsernameIgnoreCase(String username) throws PersistenceException {
        if (StringUtils.isEmpty(username)) {
            return null;
        }
        User user = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USERNAME, username.toLowerCase());
        List coll = this.findByWhere("lower(_entity.username) = :username", params, null, null);
        if (CollectionUtils.isNotEmpty(coll)) {
            user = (User)coll.iterator().next();
        }
        this.initialize(user);
        return user;
    }

    @Override
    public List<User> findByLikeUsername(String username) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USERNAME, username);
        return this.findByWhere("_entity.username like :username", params, null, null);
    }

    @Override
    public List<User> findByUsernameAndName(String username, String name) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USERNAME, username);
        params.put("name", name.toLowerCase());
        return this.findByWhere("lower(_entity.name) like :name and _entity.username like :username", params, null, null);
    }

    @Override
    public void checkPasswordCompliance(User user) throws PasswordWeakException, PersistenceException {
        if (user.getId() == 0L && user.getTenantId() != 1L && "Administrator".equals(user.getFirstName()) && user.getUsername().startsWith(ADMIN) && ADMIN.equals(user.getDecodedPassword())) {
            return;
        }
        String password = user.getDecodedPassword();
        if (StringUtils.isEmpty(password)) {
            return;
        }
        TenantDAO tenantDAO = Context.get(TenantDAO.class);
        String tenant = tenantDAO.getTenantName(user.getTenantId());
        Map<String, String> messages = I18N.getMessages(user.getLocale() != null ? user.getLocale() : Locale.ENGLISH);
        List<String> errorKeys = messages.keySet().stream().filter(key -> key.startsWith("passwderror.")).toList();
        Properties props = new Properties();
        for (String key2 : errorKeys) {
            props.put(key2.substring(key2.indexOf(46) + 1), messages.get(key2));
        }
        PasswordCriteria criteria = new PasswordCriteria(this.config.getInt(tenant + ".password.size", 8), this.config.getInt(tenant + ".password.uppercase", 2), this.config.getInt(tenant + ".password.lowercase", 2), this.config.getInt(tenant + ".password.digit", 1), this.config.getInt(tenant + ".password.special", 1));
        criteria.setMaxOccurrences(this.config.getInt(tenant + ".password.occurrence", 3));
        criteria.setMaxSequenceSize(this.config.getInt(tenant + ".password.sequence", 3));
        PasswordValidator validator = new PasswordValidator(criteria, props);
        List<String> errors = validator.validate(password);
        if (!errors.isEmpty()) {
            throw new PasswordWeakException(errors);
        }
    }

    private void checkAlreadyUsedPassword(User user) throws PersistenceException, PasswordAlreadyUsedException {
        int enforce = this.getPasswordEnforce(user);
        if (enforce < 1) {
            return;
        }
        PasswordHistory hist = this.passwordHistoryDAO.findByUserIdAndPassword(user.getId(), user.getPassword(), enforce);
        if (hist != null) {
            throw new PasswordAlreadyUsedException(hist.getDate());
        }
    }

    @Override
    public void store(User user) throws PasswordAlreadyUsedException, PersistenceException {
        this.store(user, null);
    }

    @Override
    public void store(User user, UserHistory transaction) throws PasswordAlreadyUsedException, PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        boolean newUser = user.getId() == 0L;
        boolean passwordChanged = false;
        boolean enabledStatusChanged = false;
        passwordChanged = this.processPasswordChanged(user);
        this.validateUsernameUniquenes(user, newUser);
        this.sanitize(user);
        if (user.getType() == UserType.SYSTEM) {
            user.setType(UserType.DEFAULT);
        }
        this.enforceReadOnlyUserGroups(user);
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        this.invokeListenersBefore(user, transaction, dictionary);
        if (newUser) {
            user.setCreation(new Date());
            user.setLastEnabled(user.getCreation());
        } else {
            int currentEnabled = this.queryForInt("select ld_enabled from ld_user where ld_id=" + user.getId());
            boolean bl = enabledStatusChanged = currentEnabled != user.getEnabled();
            if (enabledStatusChanged && user.getEnabled() == 1) {
                user.setLastEnabled(new Date());
            }
            if (user.getLastEnabled() == null) {
                user.setLastEnabled(user.getCreation());
            }
            user.setPasswordExpired(this.isPasswordExpired(user) ? 1 : 0);
        }
        if (StringUtils.isEmpty(user.getPassword()) && user.getSource() == UserSource.DEFAULT) {
            throw new PersistenceException(String.format("Cannot set empty password to user %s", user.getUsername()));
        }
        this.saveOrUpdate(user);
        if (newUser) {
            this.flush();
        }
        this.saveWorkingTimes(user);
        this.enforceUserGroupAssignment(user);
        this.updateUserGroupAssignments(user);
        this.recordPasswordChange(user, transaction, passwordChanged);
        this.invokeListenersAfter(user, transaction, dictionary);
        this.saveHistory(user, transaction, newUser);
        this.updateAdminPasswordSetting(user);
        this.enforceReadOnlyUserPermissions(user);
        this.saveEnabledOrDisabledHistory(user, transaction, enabledStatusChanged);
    }

    private void sanitize(User user) {
        user.setName(HTMLSanitizer.sanitizeSimpleText(user.getName()));
        user.setFirstName(HTMLSanitizer.sanitizeSimpleText(user.getFirstName()));
        user.setCity(HTMLSanitizer.sanitizeSimpleText(user.getCity()));
        user.setBuilding(HTMLSanitizer.sanitizeSimpleText(user.getBuilding()));
        user.setCompany(HTMLSanitizer.sanitizeSimpleText(user.getCompany()));
        user.setCountry(HTMLSanitizer.sanitizeSimpleText(user.getCountry()));
        user.setDepartment(HTMLSanitizer.sanitizeSimpleText(user.getDepartment()));
        user.setPostalcode(HTMLSanitizer.sanitizeSimpleText(user.getPostalcode()));
        user.setState(HTMLSanitizer.sanitizeSimpleText(user.getState()));
        user.setStreet(HTMLSanitizer.sanitizeSimpleText(user.getStreet()));
        user.setTelephone(HTMLSanitizer.sanitizeSimpleText(user.getTelephone()));
        user.setTelephone2(HTMLSanitizer.sanitizeSimpleText(user.getTelephone2()));
    }

    private void validateUsernameUniquenes(User user, boolean newUser) throws PersistenceException {
        if (newUser && this.findByUsernameIgnoreCase(user.getUsername()) != null) {
            throw new PersistenceException(String.format("Another user exists with the same username %s (perhaps with different case)", user.getUsername()));
        }
    }

    private void saveWorkingTimes(User user) throws PersistenceException {
        this.jdbcUpdate("delete from ld_workingtime where ld_userid=" + user.getId());
        if (user.getWorkingTimes() != null) {
            for (WorkingTime wt : user.getWorkingTimes()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("userId", user.getId());
                params.put("dayOfWeek", wt.getDayOfWeek());
                params.put("hourStart", wt.getHourStart());
                params.put("minuteStart", wt.getMinuteStart());
                params.put("hourEnd", wt.getHourEnd());
                params.put("minuteEnd", wt.getMinuteEnd());
                params.put("label", wt.getLabel());
                params.put("description", wt.getDescription());
                this.jdbcUpdate("insert into ld_workingtime(ld_userid,ld_dayofweek,ld_hourstart,ld_minutestart,ld_hourend,ld_minuteend,ld_label,ld_description) values (:userId, :dayOfWeek, :hourStart, :minuteStart, :hourEnd, :minuteEnd, :label, :description)", params);
            }
        }
    }

    private void enforceUserGroupAssignment(User user) throws PersistenceException {
        String userGroupName;
        GroupDAO groupDAO = Context.get(GroupDAO.class);
        Group grp = groupDAO.findByName(userGroupName = user.getUserGroupName(), user.getTenantId());
        if (grp == null) {
            grp = new Group();
            grp.setName(userGroupName);
            grp.setType(GroupType.USER);
            grp.setTenantId(user.getTenantId());
            groupDAO.store(grp);
        }
        if (!user.isMemberOf(grp.getName())) {
            user.addGroup(grp);
        }
    }

    private void recordPasswordChange(User user, UserHistory transaction, boolean passwordChanged) throws PersistenceException {
        if (passwordChanged) {
            PasswordHistory pHist = new PasswordHistory();
            pHist.setDate(transaction != null ? transaction.getDate() : new Date());
            pHist.setUserId(user.getId());
            pHist.setPassword(user.getPassword());
            pHist.setTenantId(user.getTenantId());
            this.passwordHistoryDAO.store(pHist);
            this.passwordHistoryDAO.cleanOldHistories(user.getId(), this.getPasswordEnforce(user) * 2);
        }
    }

    private void enforceReadOnlyUserGroups(User user) throws PersistenceException {
        if (user.isReadonly()) {
            GroupDAO gDao = Context.get(GroupDAO.class);
            Group guestGroup = gDao.findByName("guest", user.getTenantId());
            Group userGroup = user.getUserGroup();
            user.removeGroupMemberships(null);
            user.addGroup(userGroup);
            user.addGroup(guestGroup);
        }
    }

    private void enforceReadOnlyUserPermissions(User user) throws PersistenceException {
        if (user.isReadonly()) {
            user = this.findById(user.getId());
            this.initialize(user);
            GroupDAO groupDAO = Context.get(GroupDAO.class);
            for (Group group : new ArrayList<Group>(user.getGroups())) {
                groupDAO.fixGuestPermissions(group);
            }
        }
    }

    private void updateAdminPasswordSetting(User user) {
        if (ADMIN.equals(user.getUsername()) && user.getTenantId() == 1L) {
            this.log.info("Updated adminpasswd");
            this.config.setProperty("adminpasswd", user.getPassword());
            try {
                this.config.write();
            }
            catch (IOException e) {
                this.log.warn("Cannot write the new admin password in the configuration file", e);
            }
        }
    }

    private void saveHistory(User user, UserHistory transaction, boolean newUser) throws PersistenceException {
        if (newUser) {
            this.saveDefaultDashlets(user);
            UserHistory createdHistory = new UserHistory();
            if (transaction != null) {
                createdHistory = new UserHistory(transaction);
            }
            createdHistory.setEvent(UserEvent.CREATED);
            createdHistory.setComment(user.getUsername());
            this.saveUserHistory(user, createdHistory);
        } else {
            if (transaction == null) {
                transaction = new UserHistory();
                transaction.setEvent(UserEvent.UPDATED);
                transaction.setComment(user.getUsername());
            }
            this.saveUserHistory(user, transaction);
        }
    }

    private void updateUserGroupAssignments(User user) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", user.getId());
        this.jdbcUpdate("delete from ld_usergroup where ld_userid = :userId", params);
        for (UserGroup ug : user.getUserGroups()) {
            int exists = this.queryForInt("select count(*) from ld_group where ld_id=" + ug.getGroupId());
            if (exists > 0) {
                this.jdbcUpdate("insert into ld_usergroup(ld_userid, ld_groupid) values (" + user.getId() + ", " + ug.getGroupId() + ")");
                continue;
            }
            this.log.warn("It seems that the usergroup {} does not exist anymore", (Object)ug.getGroupId());
        }
    }

    private void saveEnabledOrDisabledHistory(User user, UserHistory transaction, boolean enabledStatusChanged) throws PersistenceException {
        if (enabledStatusChanged && (transaction == null || !transaction.getEvent().equals(UserEvent.DISABLED.toString()) && !transaction.getEvent().equals(UserEvent.ENABLED.toString()))) {
            UserHistory enabledOrDisabledHistory = new UserHistory();
            if (transaction != null) {
                enabledOrDisabledHistory = new UserHistory(transaction);
            } else {
                enabledOrDisabledHistory.setUser(user);
            }
            enabledOrDisabledHistory.setEvent(user.getEnabled() == 1 ? UserEvent.ENABLED : UserEvent.DISABLED);
            enabledOrDisabledHistory.setComment(null);
            this.saveUserHistory(user, enabledOrDisabledHistory);
        }
    }

    private void invokeListenersAfter(User user, UserHistory transaction, Map<String, Object> dictionary) throws AuthenticationException {
        this.log.debug("Invoke listeners after store");
        for (UserListener listener : this.userListenerManager.getListeners()) {
            try {
                listener.afterStore(user, transaction, dictionary);
            }
            catch (AuthenticationException ae) {
                throw ae;
            }
            catch (PersistenceException e) {
                this.log.warn("Error in listener {}", (Object)listener.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    private void invokeListenersBefore(User user, UserHistory transaction, Map<String, Object> dictionary) throws AuthenticationException {
        this.log.debug("Invoke listeners before store");
        for (UserListener listener : this.userListenerManager.getListeners()) {
            try {
                listener.beforeStore(user, transaction, dictionary);
            }
            catch (AuthenticationException ae) {
                throw ae;
            }
            catch (PersistenceException e) {
                this.log.warn("Error in listener {}", (Object)listener.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    private boolean processPasswordChanged(User user) throws PersistenceException {
        boolean passwordChanged;
        if (user.getSource() != UserSource.DEFAULT) {
            return false;
        }
        String currentPassword = this.queryForString("select ld_password from ld_user where ld_id=" + user.getId());
        boolean bl = passwordChanged = currentPassword == null || !currentPassword.equals(user.getPassword());
        if (passwordChanged) {
            this.checkAlreadyUsedPassword(user);
            this.checkPasswordCompliance(user);
        }
        return passwordChanged;
    }

    private void saveDefaultDashlets(User user) throws PersistenceException {
        String type = "usersetting";
        String dashletSubtype = "dashlet-";
        String[] dashletSubtypes = new String[]{dashletSubtype + "checkout", dashletSubtype + "locked", dashletSubtype + "notes"};
        int i = 0;
        while (i < dashletSubtypes.length) {
            Generic dash = new Generic(type, dashletSubtypes[i], user.getId());
            dash.setString1("0");
            dash.setTenantId(user.getTenantId());
            switch (i) {
                case 0: {
                    dash.setInteger1(1L);
                    dash.setInteger2(0L);
                    dash.setInteger3(0L);
                    break;
                }
                case 1: {
                    dash.setInteger1(3L);
                    dash.setInteger2(0L);
                    dash.setInteger3(1L);
                    break;
                }
                case 3: {
                    dash.setInteger1(6L);
                    dash.setInteger2(1L);
                    dash.setInteger3(0L);
                }
            }
            this.genericDAO.store(dash);
            ++i;
        }
    }

    private boolean isPasswordExpired(User user) throws PersistenceException {
        if (user == null || user.getSource() != UserSource.DEFAULT) {
            return false;
        }
        if (user.getPasswordExpired() == 1) {
            this.log.warn("User {}'s password already marked as expired", (Object)user);
            return true;
        }
        String tenantName = Context.get(TenantDAO.class).getTenantName(user.getTenantId());
        int passwordTtl = this.config.getInt(tenantName + ".password.ttl", 90);
        if (passwordTtl <= 0) {
            return false;
        }
        if (user.getPasswordExpires() == 1) {
            Date lastChange = user.getPasswordChanged();
            if (lastChange == null) {
                return false;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(lastChange);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(10, 0);
            lastChange = calendar.getTime();
            calendar.setTime(new Date());
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(10, 0);
            ((Calendar)calendar).add(5, -passwordTtl);
            Date date = calendar.getTime();
            boolean expired = lastChange.before(date);
            if (expired) {
                this.log.warn("User {}'s password expired because last changed on {}", (Object)lastChange);
            }
            return expired;
        }
        return false;
    }

    @Override
    public boolean isPasswordExpired(String username) {
        try {
            User user = this.findByUsernameIgnoreCase(username);
            return this.isPasswordExpired(user);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
            return true;
        }
    }

    private boolean isInactive(User user) throws PersistenceException {
        if (user == null) {
            return false;
        }
        if (user.getEnabled() == 0) {
            return true;
        }
        String tenantName = Context.get(TenantDAO.class).getTenantName(user.getTenantId());
        int maxInactiveDays = this.config.getInt(tenantName + ".security.user.maxinactivity", -1);
        if (user.getMaxInactivity() != null) {
            maxInactiveDays = user.getMaxInactivity();
        }
        if (maxInactiveDays <= 0) {
            return false;
        }
        this.log.info("Checking if the user {} has interactions in the last {} days", (Object)user.getUsername(), (Object)maxInactiveDays);
        StringBuilder sb = new StringBuilder("select max(ld_date) from ld_history where ld_deleted=0 and ld_userid=" + user.getId());
        sb.append(" UNION select max(ld_date) from ld_user_history where ld_deleted=0 and not ld_event in ('event.user.updated', 'event.user.disabled', 'event.user.timeout', 'event.user.login.failed', 'event.user.deleted', 'event.user.messagereceived') and ld_userid=" + user.getId());
        sb.append(" UNION select max(ld_date) from ld_folder_history where ld_deleted=0 and ld_userid=" + user.getId() + " order by 1 desc");
        List<Date> interactions = this.queryForList(sb.toString(), Date.class);
        Date lastInteraction = null;
        if (!interactions.isEmpty()) {
            lastInteraction = interactions.get(0);
        }
        if (lastInteraction == null) {
            lastInteraction = user.getCreation();
        }
        if (user.getLastEnabled() != null && user.getLastEnabled().after(lastInteraction)) {
            lastInteraction = user.getLastEnabled();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(lastInteraction);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        lastInteraction = calendar.getTime();
        calendar.setTime(new Date());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        ((Calendar)calendar).add(5, -maxInactiveDays);
        Date date = calendar.getTime();
        return lastInteraction.before(date);
    }

    @Override
    public boolean isInactive(String username) throws PersistenceException {
        return this.isInactive(this.findByUsernameIgnoreCase(username));
    }

    @Override
    public int count(Long tenantId) throws PersistenceException {
        String query = "select count(*) from ld_user where ld_type=" + UserType.DEFAULT.ordinal() + " and ld_deleted=0 " + (String)(tenantId != null ? " and ld_tenantid=" + String.valueOf(tenantId) : "");
        return this.queryForInt(query);
    }

    @Override
    public int countGuests(Long tenantId) throws PersistenceException {
        String query = "select count(*) from ld_user where ld_type=" + UserType.READONLY.ordinal() + " and ld_deleted=0 " + (String)(tenantId != null ? " and ld_tenantid=" + String.valueOf(tenantId) : "");
        return this.queryForInt(query);
    }

    @Override
    public void delete(long userId, int code) throws PersistenceException {
        this.delete(userId, null);
    }

    @Override
    public void delete(long userId, UserHistory transaction) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        User user = this.findById(userId);
        Group userGroup = user.getUserGroup();
        user.setDeleted(1);
        user.setUsername(user.getUsername() + "." + user.getId());
        this.saveOrUpdate(user);
        if (userGroup != null) {
            GroupDAO groupDAO = Context.get(GroupDAO.class);
            groupDAO.delete(userGroup.getId());
        }
        this.jdbcUpdate("delete from ld_usergroup where ld_userid=" + userId);
        this.jdbcUpdate("delete from ld_apikey where ld_userid=" + userId);
        this.saveUserHistory(user, transaction);
    }

    private void saveUserHistory(User user, UserHistory transaction) throws PersistenceException {
        if (transaction == null) {
            return;
        }
        transaction.setUser(user);
        transaction.setNotified(0);
        this.userHistoryDAO.store(transaction);
    }

    private int getPasswordEnforce(User user) throws PersistenceException {
        TenantDAO tenantDAO = Context.get(TenantDAO.class);
        String tenant = tenantDAO.getTenantName(user.getTenantId());
        return this.config.getInt(tenant + ".password.enforcehistory", 10);
    }

    public UserHistoryDAO getUserHistoryDAO() {
        return this.userHistoryDAO;
    }

    public void setUserHistoryDAO(UserHistoryDAO userHistoryDAO) {
        this.userHistoryDAO = userHistoryDAO;
    }

    public void setUserListenerManager(UserListenerManager userListenerManager) {
        this.userListenerManager = userListenerManager;
    }

    public UserListenerManager getUserListenerManager() {
        return this.userListenerManager;
    }

    @Override
    public void initialize(User user) throws PersistenceException {
        if (user == null || user.getId() == 0L) {
            return;
        }
        this.refresh(user);
        List<Object> groupIds = new ArrayList();
        try {
            groupIds = this.queryForList("select distinct ld_groupid from ld_usergroup where ld_userid=" + user.getId(), Long.class);
            for (Long l : groupIds) {
                user.getUserGroups().add(new UserGroup(l));
            }
        }
        catch (PersistenceException persistenceException) {
            this.log.error(persistenceException.getMessage(), persistenceException);
        }
        user.getGroups().clear();
        user.getUserGroups().clear();
        if (!groupIds.isEmpty()) {
            GroupDAO groupDAO = Context.get(GroupDAO.class);
            try {
                List groups = groupDAO.findByWhere("_entity.id in (" + StringUtil.arrayToString(groupIds.toArray(new Long[0]), ",") + ")", null, null);
                for (Group group : groups) {
                    user.getGroups().add(group);
                    user.getUserGroups().add(new UserGroup(group.getId()));
                }
            }
            catch (PersistenceException e) {
                this.log.warn(e.getMessage(), e);
            }
        }
        user.getWorkingTimes().clear();
        this.queryForResultSet("select ld_dayofweek,ld_hourstart,ld_minutestart,ld_hourend,ld_minuteend,ld_label,ld_description from ld_workingtime where ld_userid=" + user.getId(), null, null, rows -> {
            while (rows.next()) {
                WorkingTime wt = new WorkingTime(rows.getInt(1), rows.getInt(2), rows.getInt(3));
                wt.setHourEnd(rows.getInt(4));
                wt.setMinuteEnd(rows.getInt(5));
                wt.setLabel(rows.getString(6));
                wt.setDescription(rows.getString(7));
                user.getWorkingTimes().add(wt);
            }
        });
    }

    @Override
    public Map<String, Generic> findUserSettings(long userId, String namePrefix) throws PersistenceException {
        List<Generic> generics = this.genericDAO.findByTypeAndSubtype("usersetting", namePrefix + "%", userId, null);
        HashMap<String, Generic> map = new HashMap<String, Generic>();
        for (Generic generic : generics) {
            map.put(generic.getSubtype(), generic);
        }
        return map;
    }

    public void setGenericDAO(GenericDAO genericDAO) {
        this.genericDAO = genericDAO;
    }

    @Override
    public User findAdminUser(String tenantName) throws PersistenceException {
        if ("default".equals(tenantName)) {
            return this.findByUsername(ADMIN);
        }
        return this.findByUsername(ADMIN + StringUtils.capitalize(tenantName));
    }

    @Override
    public Set<User> findByGroup(long groupId) throws PersistenceException {
        List<Object> docIds = new ArrayList();
        try {
            docIds = this.queryForList("select ld_userid from ld_usergroup where ld_groupid=" + groupId, Long.class);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        HashSet<User> set = new HashSet<User>();
        if (!docIds.isEmpty()) {
            String query = "_entity.id in (" + StringUtil.arrayToString(docIds.toArray(new Long[0]), ",") + ")";
            List users = this.findByWhere(query, null, null, null);
            for (User user : users) {
                if (user.getDeleted() != 0 || set.contains(user)) continue;
                set.add(user);
            }
        }
        return set;
    }

    @Override
    public User findById(long id) throws PersistenceException {
        User user = (User)super.findById(id);
        if (user != null) {
            this.initialize(user);
        }
        return user;
    }

    @Override
    public User getUser(String username) throws PersistenceException {
        User user = null;
        user = HibernateUserDAO.ignoreCaseLogin() ? this.findByUsernameIgnoreCase(username) : this.findByUsername(username);
        this.initialize(user);
        return user;
    }

    public void setPasswordHistoryDAO(PasswordHistoryDAO passwordHistoryDAO) {
        this.passwordHistoryDAO = passwordHistoryDAO;
    }

    public void setConfig(ContextProperties config) {
        this.config = config;
    }
}

