/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.user;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.user.PasswordHistory;
import com.logicaldoc.core.security.user.PasswordHistoryDAO;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="passwordHistoryDAO")
@Transactional
public class HibernatePasswordHistoryDAO
extends HibernatePersistentObjectDAO<PasswordHistory>
implements PasswordHistoryDAO {
    private HibernatePasswordHistoryDAO() {
        super(PasswordHistory.class);
        this.log = LoggerFactory.getLogger(PasswordHistoryDAO.class);
    }

    @Override
    public List<PasswordHistory> findByUserId(long userId, Integer max) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        return this.findByWhere("_entity.userId = :userId", params, "_entity.date desc", max);
    }

    @Override
    public void cleanOldHistories(long userId, int retain) {
        if (retain <= 0) {
            return;
        }
        try {
            List<PasswordHistory> histories = this.findByUserId(userId, null);
            if (histories.size() <= retain) {
                return;
            }
            int i = 0;
            while (i < histories.size()) {
                if (i >= retain) {
                    this.delete(histories.get(i).getId());
                }
                ++i;
            }
        }
        catch (Exception t) {
            this.log.error(t.getMessage(), t);
        }
    }

    @Override
    public PasswordHistory findByUserIdAndPassword(long userId, String password, int max) throws PersistenceException {
        if (password != null) {
            List<PasswordHistory> histories = this.findByUserId(userId, max);
            int i = 0;
            while (i < histories.size()) {
                if (i >= max) {
                    return null;
                }
                PasswordHistory history = histories.get(i);
                if (history.getPassword() != null && history.getPassword().equals(password)) {
                    return history;
                }
                ++i;
            }
        }
        return null;
    }
}

