/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.user;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.security.user.GroupType;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="ld_group")
@Cacheable
public class Group
extends PersistentObject
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger(Group.class);
    public static final String GROUP_ADMIN = "admin";
    public static final long GROUPID_ADMIN = 1L;
    public static final long GROUPID_PUBLISHER = -10000L;
    @Column(name="ld_name", length=255, nullable=false)
    private String name = "";
    @Column(name="ld_description", length=255)
    private String description = "";
    @Column(name="ld_source", length=255)
    private String source = "local";
    @Column(name="ld_type", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private GroupType type = GroupType.DEFAULT;
    @Transient
    private Set<User> users = new HashSet<User>();

    public GroupType getType() {
        return this.type;
    }

    public void setType(GroupType type) {
        this.type = type;
    }

    public void setType(int type) {
        this.type = GroupType.values()[type];
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void reset() {
        this.name = "";
        this.description = "";
        this.users = new HashSet<User>();
    }

    public void clearUsers() {
        this.users.clear();
        this.users = new HashSet<User>();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isUserGroup() {
        return this.type == GroupType.USER;
    }

    public User getUser() {
        if (!this.isUserGroup()) {
            return null;
        }
        UserDAO userDao = Context.get(UserDAO.class);
        long userId = Long.parseLong(this.name.substring(this.name.lastIndexOf(95) + 1));
        try {
            return (User)userDao.findById(userId);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public boolean isGuest() {
        User user;
        if ("guest".equals(this.name)) {
            return true;
        }
        return this.isUserGroup() && (user = this.getUser()) != null && user.isReadonly();
    }

    public boolean isAdmin() {
        return GROUP_ADMIN.equals(this.name);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

