/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.spring;

import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.spring.LDAuthenticationToken;
import com.logicaldoc.core.security.user.Group;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class SessionFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(SessionFilter.class);
    static final String FILTER_APPLIED = "__com_logicaldoc_core_security_spring_SessionFilter_applied";

    public void doFilter(ServletRequest rec, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)rec;
        HttpServletResponse response = (HttpServletResponse)res;
        if (request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        if (SecurityContextHolder.getContext().getAuthentication() != null && request.getSession(false) != null && request.getSession(false).getAttribute("sid") != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String sid = this.getSidFromRequest(request);
        if (StringUtils.isNotEmpty(sid)) {
            try {
                Session session = SessionManager.get().get(sid);
                if (session == null || !session.isOpen()) {
                    log.debug("The sid {} is unexisting or expired", (Object)sid);
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                log.debug("Connecting current request to session {}", (Object)sid);
                SessionManager.get().saveSid(request, response, sid);
                session.getUser().clearPassword();
                ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
                for (String role : session.getUser().getGroups().stream().map(Group::getName).toList()) {
                    authorities.add(new SimpleGrantedAuthority(role));
                }
                LDAuthenticationToken auth = new LDAuthenticationToken(session.getUser(), null, authorities);
                auth.setSid(session.getSid());
                SecurityContext sc = SecurityContextHolder.getContext();
                sc.setAuthentication((Authentication)auth);
            }
            catch (AuthenticationException ae) {
                log.error(ae.getMessage(), ae);
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getSidFromRequest(HttpServletRequest request) {
        String sid = SessionManager.get().getSessionId(request);
        if (StringUtils.isEmpty(sid) && StringUtils.isNotEmpty(request.getHeader("X-API-KEY"))) {
            try {
                Session session = SessionManager.get().newSession(null, null, request.getHeader("X-API-KEY"), request);
                sid = session.getSid();
            }
            catch (AuthenticationException ae) {
                log.error(ae.getMessage(), ae);
            }
        }
        return sid;
    }
}

