/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.spring;

import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.spring.LDAuthenticationToken;
import com.logicaldoc.core.security.spring.LDDeferredSecurityContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.springframework.security.core.context.DeferredSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;

public class LDSecurityContextRepository
extends HttpSessionSecurityContextRepository {
    public boolean containsContext(HttpServletRequest request) {
        return super.containsContext(request) || SessionManager.get().getSessionId(request) != null;
    }

    public DeferredSecurityContext loadDeferredContext(HttpServletRequest request) {
        DeferredSecurityContext context = super.loadDeferredContext(request);
        return context != null ? context : new LDDeferredSecurityContext(request);
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        super.saveContext(context, request, response);
        if (context.getAuthentication() == null) {
            return;
        }
        Object principal = context.getAuthentication().getPrincipal();
        if (principal instanceof LDAuthenticationToken) {
            LDAuthenticationToken token = (LDAuthenticationToken)((Object)principal);
            SessionManager.get().saveSid(request, response, token.getSid());
            HttpSession servletSession = request.getSession(false);
            if (servletSession != null && servletSession.getAttribute("sid") != null) {
                LDDeferredSecurityContext.bindServletSession(servletSession.getAttribute("sid").toString(), servletSession);
            }
        }
    }
}

