/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.spring;

import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.spring.LDAuthenticationToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.DeferredSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

public class LDDeferredSecurityContext
implements DeferredSecurityContext {
    static Map<String, HttpSession> servletSessionMapping = new HashMap<String, HttpSession>();
    private HttpServletRequest request;
    private SecurityContext context;

    public LDDeferredSecurityContext(HttpServletRequest request) {
        this.request = request;
    }

    public SecurityContext get() {
        if (this.isGenerated()) {
            return this.context;
        }
        String sid = SessionManager.get().getSessionId(this.request);
        if (sid == null || !SessionManager.get().isOpen(sid)) {
            this.context = SecurityContextHolder.createEmptyContext();
        } else {
            Session session = SessionManager.get().get(sid);
            String username = session.getClient() != null && StringUtils.isNotEmpty((CharSequence)session.getClient().getUsername()) ? session.getClient().getUsername() : session.getUsername();
            LDAuthenticationToken token = new LDAuthenticationToken(username, "", null);
            token.setSid(sid);
            this.context = new SecurityContextImpl();
            this.context.setAuthentication((Authentication)token);
            HttpSession servletSession = this.request.getSession(false);
            if (servletSession != null) {
                servletSessionMapping.put(sid, servletSession);
            }
        }
        return this.context;
    }

    public boolean isGenerated() {
        return this.context != null;
    }

    public static void bindServletSession(String sid, HttpServletRequest request) {
        LDDeferredSecurityContext.bindServletSession(sid, request.getSession());
    }

    public static void bindServletSession(String sid, HttpSession servletSession) {
        servletSession.setAttribute("sid", (Object)sid);
        servletSessionMapping.put(sid, servletSession);
    }

    public static HttpSession getServletSession(String sid) {
        return servletSessionMapping.get(sid);
    }
}

