/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.spring;

import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.LoginThrottle;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.authentication.AccountDisabledException;
import com.logicaldoc.core.security.authentication.AccountExpiredException;
import com.logicaldoc.core.security.authentication.AccountInactiveException;
import com.logicaldoc.core.security.authentication.AccountNotFoundException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authentication.OutsideWorkingTimeException;
import com.logicaldoc.core.security.authentication.PasswordExpiredException;
import com.logicaldoc.core.security.spring.LDAuthenticationDetails;
import com.logicaldoc.core.security.spring.LDAuthenticationToken;
import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.util.spring.Context;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LDAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(LDAuthenticationProvider.class);

    public Authentication authenticate(Authentication authentication) throws org.springframework.security.core.AuthenticationException {
        Authentication authentication2 = authentication;
        Objects.requireNonNull(authentication2);
        Authentication authentication3 = authentication2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnonymousAuthenticationToken.class, UsernamePasswordAuthenticationToken.class}, (Object)authentication3, n)) {
            case 0 -> {
                AnonymousAuthenticationToken anonymousAuthentication = (AnonymousAuthenticationToken)authentication3;
                yield this.authenticateAnonymous(anonymousAuthentication);
            }
            case 1 -> {
                UsernamePasswordAuthenticationToken credentialsAuthentication = (UsernamePasswordAuthenticationToken)authentication3;
                yield this.authenticateCredentials(credentialsAuthentication);
            }
            default -> authentication;
        };
    }

    protected Authentication authenticateCredentials(UsernamePasswordAuthenticationToken authentication) {
        String username = String.valueOf(authentication.getPrincipal());
        HttpServletRequest httpReq = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String password = this.getPassword(authentication, httpReq);
        String key = this.getKey(authentication, httpReq);
        if (log.isDebugEnabled()) {
            log.debug("Authenticate user {} with key {}", (Object)username, (Object)StringUtils.defaultString(key, "-"));
        }
        Client client = SessionManager.get().buildClient(httpReq);
        Session session = SessionManager.get().getSession(httpReq);
        try {
            if (session == null) {
                session = SessionManager.get().newSession(username, password, key, client);
            }
            session.getUser().clearPassword();
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            for (String role : session.getUser().getGroups().stream().map(Group::getName).toList()) {
                authorities.add(new SimpleGrantedAuthority(role));
            }
            LoginThrottle.clearFailures(username, client.getAddress());
            LDAuthenticationToken a = new LDAuthenticationToken(session.getUser(), null, authorities);
            a.setSid(session.getSid());
            return a;
        }
        catch (AccountNotFoundException nf) {
            String message = String.format("Username %s not found", username);
            log.warn(message);
            throw new CredentialsExpiredException("Bad credentials");
        }
        catch (AccountDisabledException ad) {
            String message = String.format("User %s is disabled", username);
            log.warn(message);
            throw new DisabledException(ad.getMessage());
        }
        catch (PasswordExpiredException pe) {
            String message = String.format("Credentials expired for user %s", username);
            log.warn(message);
            throw new CredentialsExpiredException(pe.getMessage());
        }
        catch (AccountExpiredException aee) {
            String message = String.format("User %s expired on %s", username, aee.getDate());
            log.warn(message);
            throw new CredentialsExpiredException(aee.getMessage());
        }
        catch (AccountInactiveException aie) {
            String message = String.format("User %s was considered inactive because there were no interactions for too many days", username);
            log.warn(message);
            throw new CredentialsExpiredException(aie.getMessage());
        }
        catch (OutsideWorkingTimeException owte) {
            String message = String.format("User %s tried to enter outside his working hours", username);
            log.warn(message);
            throw new CredentialsExpiredException(owte.getMessage());
        }
        catch (AuthenticationException ae) {
            throw new CredentialsExpiredException(ae.getMessage() != null ? String.format("Security checks failed for user %s - %s", username, ae.getMessage()) : "badcredentials");
        }
        catch (Exception e) {
            throw new CredentialsExpiredException(e.getMessage() != null ? String.format("Security checks failed for user %s - %s", username, e.getMessage()) : "badcredentials");
        }
    }

    private String getKey(UsernamePasswordAuthenticationToken authentication, HttpServletRequest httpReq) {
        String key = httpReq.getParameter("key");
        Object object = authentication.getDetails();
        if (object instanceof LDAuthenticationDetails) {
            LDAuthenticationDetails ldAuthenticationDetails = (LDAuthenticationDetails)((Object)object);
            key = ldAuthenticationDetails.getSecretKey();
        }
        return key;
    }

    private AnonymousAuthenticationToken authenticateAnonymous(AnonymousAuthenticationToken authentication) throws org.springframework.security.core.AuthenticationException {
        log.debug("Authenticate anonymous user");
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        if ("login".equals(request.getParameter("anonymous"))) {
            String tenant = "default";
            if (StringUtils.isNotEmpty(request.getParameter("tenant"))) {
                tenant = request.getParameter("tenant");
            }
            authentication.setAuthenticated(Context.get().getProperties().getBoolean(tenant + ".anonymous.enabled", false));
        }
        return authentication;
    }

    private String getPassword(UsernamePasswordAuthenticationToken auth, HttpServletRequest httpReq) {
        String password = String.valueOf(auth.getCredentials());
        String jPassword = httpReq.getParameter("j_password");
        if (jPassword != null && !jPassword.equals(password)) {
            password = jPassword;
        }
        return password;
    }

    public boolean supports(Class<?> arg0) {
        return true;
    }
}

