/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.spring;

import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.util.spring.Context;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class ConditionalBasicAuthenticationFilter
extends BasicAuthenticationFilter {
    private String enableParam = "webservice.basicauth.enabled";

    public ConditionalBasicAuthenticationFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    public ConditionalBasicAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint) {
        super(authenticationManager, authenticationEntryPoint);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!Context.get().getProperties().getBoolean(this.enableParam, false) && SessionManager.get().getSessionId(request) == null) {
            throw new ServletException("Basic Authentication is disabled");
        }
        super.doFilterInternal(request, response, chain);
    }

    public void setEnableParam(String enableParam) {
        this.enableParam = enableParam;
    }
}

