/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.spring;

import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.spring.LDAuthenticationToken;
import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class AnonymousLoginFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(AnonymousLoginFilter.class);
    static final String FILTER_APPLIED = "__com_logicaldoc_core_security_spring_AnonymousLoginFilter_applied";

    public void doFilter(ServletRequest rec, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)rec;
        HttpServletResponse response = (HttpServletResponse)res;
        if (request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if ((authentication == null || !authentication.isAuthenticated()) && "login".equals(request.getParameter("anonymous"))) {
            String tenant = this.getTenant(request);
            ContextProperties config = Context.get().getProperties();
            if (config.getBoolean(tenant + ".anonymous.enabled")) {
                LDAuthenticationToken authToken = new LDAuthenticationToken(config.getProperty(tenant + ".anonymous.user"));
                AuthenticationManager authenticationManager = Context.get(AuthenticationManager.class);
                try {
                    Authentication anonAuthentication = authenticationManager.authenticate((Authentication)authToken);
                    if (anonAuthentication.isAuthenticated()) {
                        String sid = ((LDAuthenticationToken)anonAuthentication).getSid();
                        SessionManager.get().saveSid(request, response, sid);
                        Session session = SessionManager.get().get(sid);
                        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
                        for (String role : session.getUser().getGroups().stream().map(Group::getName).toList()) {
                            authorities.add(new SimpleGrantedAuthority(role));
                        }
                        LDAuthenticationToken auth = new LDAuthenticationToken(session.getUser(), null, authorities);
                        auth.setSid(sid);
                        SecurityContext sc = SecurityContextHolder.getContext();
                        sc.setAuthentication((Authentication)auth);
                    }
                }
                catch (AuthenticationException anonAuthentication) {
                }
                catch (Exception t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getTenant(HttpServletRequest request) {
        String tenant = "default";
        if (StringUtils.isNotEmpty(request.getParameter("tenant"))) {
            tenant = request.getParameter("tenant");
        }
        return tenant;
    }
}

