/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.menu;

import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.security.AccessControlEntry;
import com.logicaldoc.core.security.Secure;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="ld_menu")
@Cacheable
public class Menu
extends PersistentObject
implements Secure<AccessControlEntry>,
Comparable<Menu> {
    private static final long serialVersionUID = 1L;
    public static final long ROOT = 1L;
    public static final long ADMINISTRATION = 2L;
    public static final long FRONTEND = 5L;
    public static final long SETTINGS = 7L;
    public static final long SECURITY = 9L;
    public static final long TOOLS = 16L;
    public static final long MAINMENU = 110L;
    public static final long DOCUMENTS = 1500L;
    public static final long SEARCH = 1510L;
    public static final long DASHBOARD = 1520L;
    public static final long MESSAGES = 1525L;
    public static final long SESSIONS = 1601L;
    public static final long VERSIONS = 1603L;
    public static final long ALIASES = 1605L;
    public static final long PREVIEW = 1609L;
    public static final long RATING = 1610L;
    public static final long PARAMETERS = 100L;
    public static final long AUDITING = 106L;
    public static final long ADMIN_SESSIONS = 71L;
    public static final long LOGS = 72L;
    public static final long SUBSCRIPTIONS = -1120L;
    public static final long ACCOUNT = 40L;
    public static final long CONTACTS = 1530L;
    public static final long CHAT = 1527L;
    public static final long INTERFACE_DENSITY = 1535L;
    public static final long CUSTOM_ACTIONS = 1300L;
    public static final int TYPE_DEFAULT = 1;
    public static final int TYPE_CUSTOM_ACTION = 2;
    public static final long DESTROY_DOCUMENTS = -9L;
    @Column(name="ld_name", length=255)
    private String name = "";
    @Column(name="ld_position", nullable=false)
    private int position = 1;
    @Column(name="ld_parentid", nullable=false)
    private long parentId = 0L;
    @Column(name="ld_icon", length=255)
    private String icon = "";
    @Column(name="ld_type", nullable=false)
    private int type = 1;
    @Column(name="ld_enabled", nullable=false)
    private int enabled = 1;
    @Column(name="ld_description", length=4000)
    private String description = "";
    @Column(name="ld_routineid")
    private Long routineId;
    @Column(name="ld_automation")
    private String automation;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="ld_menu_acl", joinColumns={@JoinColumn(name="ld_menuid")})
    private Set<AccessControlEntry> accessControlList = new HashSet<AccessControlEntry>();

    public long getParentId() {
        return this.parentId;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getType() {
        return this.type;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int enabled) {
        this.enabled = enabled;
    }

    public Long getRoutineId() {
        return this.routineId;
    }

    public void setRoutineId(Long routineId) {
        this.routineId = routineId;
    }

    public String getAutomation() {
        return this.automation;
    }

    public void setAutomation(String automation) {
        this.automation = automation;
    }

    @Override
    public void setAccessControlList(Set<AccessControlEntry> acl) {
        this.accessControlList = acl;
    }

    @Override
    public Set<AccessControlEntry> getAccessControlList() {
        return this.accessControlList;
    }

    @Override
    public AccessControlEntry getAccessControlEntry(long groupId) {
        return this.getAccessControlList().stream().filter(ace -> ace.getGroupId() == groupId).findFirst().orElse(null);
    }

    @Override
    public void addAccessControlEntry(AccessControlEntry ace) {
        if (!this.getAccessControlList().add(ace)) {
            this.getAccessControlList().remove(ace);
            this.getAccessControlList().add(ace);
        }
    }

    @Override
    public int compareTo(Menu other) {
        if (this.equals(other)) {
            return 0;
        }
        int comparison = Integer.compare(this.position, other.position);
        if (comparison != 0) {
            return comparison;
        }
        return this.name.compareTo(other.name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.parentId ^ this.parentId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Menu other = (Menu)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.parentId == other.parentId;
    }
}

