/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.menu;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.AccessControlEntry;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.menu.Menu;
import com.logicaldoc.core.security.menu.MenuDAO;
import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.core.security.user.GroupDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="menuDAO")
@Transactional
public class HibernateMenuDAO
extends HibernatePersistentObjectDAO<Menu>
implements MenuDAO {
    private static final String SELECT_DISTINCT_A_LD_MENUID_FROM_LD_MENUGROUP_A_LD_MENU_B = "select distinct(A.ld_menuid) from ld_menu_acl A, ld_menu B ";
    private static final String ACL_AS_GROUP = ".accessControlList as _group ";
    private static final String WHERE = " where ";
    private static final String ENABLED_1_AND = ".enabled=1 and ";
    private static final String CLOSE_BRACKET_AND = ") and ";
    private static final String WHERE_GROUP_GROUP_ID_IN = " where _group.groupId in (";
    private static final String SELECT_DISTINCT = "select distinct(";
    private static final String CLOSE_BRACKET_FROM_MENU = ") from Menu ";
    private static final String DOT_PARENT_ID = ".parentId=";
    private static final String PARENT_ID = "parentId";
    private static final String LEFT_JOIN = " left join ";
    private static final String AND = " and ";
    @Resource(name="userDAO")
    protected UserDAO userDAO;

    public HibernateMenuDAO() {
        super(Menu.class);
        this.log = LoggerFactory.getLogger(HibernateMenuDAO.class);
    }

    @Override
    public void store(Menu menu) throws PersistenceException {
        this.removeForbiddenPermissionsForGuests(menu);
        super.store(menu);
    }

    private void removeForbiddenPermissionsForGuests(Menu menu) throws PersistenceException {
        GroupDAO gDao = Context.get(GroupDAO.class);
        for (AccessControlEntry ace : menu.getAccessControlList()) {
            Group group = (Group)gDao.findById(ace.getGroupId());
            if (group == null || !group.isGuest()) continue;
            ace.setWrite(0);
        }
    }

    @Override
    public List<Menu> findByUserId(long userId) {
        List<Menu> coll = new ArrayList<Menu>();
        try {
            User user = (User)this.userDAO.findById(userId);
            if (user == null) {
                return coll;
            }
            if (user.isAdmin()) {
                return this.findAll();
            }
            Set<Group> groups = user.getGroups();
            if (!groups.isEmpty()) {
                StringBuilder query = new StringBuilder("select distinct(_menu) from Menu _menu  ");
                query.append(" left join _menu.accessControlList as _group ");
                query.append(" where _menu.enabled=1 and _group.groupId in (");
                query.append(groups.stream().map(g -> Long.toString(g.getId())).collect(Collectors.joining(",")));
                query.append(")");
                coll = this.findByObjectQuery(query.toString(), null, null);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        Collections.sort(coll);
        return coll;
    }

    @Override
    public List<Menu> findByUserId(long userId, long parentId, boolean enabledOnly) {
        return this.findByUserId(userId, parentId, null, enabledOnly);
    }

    public List<Menu> findByUserId(long userId, long parentId, Integer type, boolean enabledOnly) {
        List<Menu> coll = new ArrayList<Menu>();
        try {
            User user = (User)this.userDAO.findById(userId);
            if (user == null) {
                return coll;
            }
            if (user.isMemberOf("admin")) {
                return this.findByWhere("_entity.id!=_entity.parentId and _entity.parentId=" + parentId + (String)(type == null ? "" : " and _entity.type=" + String.valueOf(type)) + (enabledOnly ? " and _entity.enabled=1" : ""), "_entity.position asc, _entity.name asc", null);
            }
            if (user.getGroups().isEmpty()) {
                return coll;
            }
            StringBuilder query1 = new StringBuilder();
            query1.append("select distinct(_entity) from Menu _entity ");
            query1.append(" left join _entity.accessControlList as _group");
            query1.append(WHERE_GROUP_GROUP_ID_IN);
            query1.append(user.getGroups().stream().map(g -> Long.toString(g.getId())).collect(Collectors.joining(",")));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(PARENT_ID, parentId);
            query1.append(") and _entity.parentId = :parentId and _entity.id!=_entity.parentId and _entity.enabled=1 ");
            if (type != null) {
                query1.append(" and _entity.type = " + type.toString());
            }
            coll = this.findByObjectQuery(query1.toString(), params, null);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        Collections.sort(coll);
        return coll;
    }

    @Override
    public List<Menu> findChildren(long parentId, Integer max) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(PARENT_ID, parentId);
            return this.findByWhere("_entity.parentId = :parentId and _entity.id !=_entity.parentId", params, null, max);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Menu>();
        }
    }

    @Override
    public List<Menu> findChildren(long parentId, long userId) {
        List<Menu> coll = new ArrayList<Menu>();
        try {
            User user = (User)this.userDAO.findById(userId);
            if (user.isMemberOf("admin")) {
                return this.findChildren(parentId, null);
            }
            Set<Group> groups = user.getGroups();
            if (groups.isEmpty()) {
                return coll;
            }
            Iterator<Group> iter = groups.iterator();
            StringBuilder query1 = new StringBuilder("select distinct(_entity) from Menu _entity  ");
            query1.append(" left join _entity.accessControlList as _group ");
            query1.append(" where _entity.enabled=1 and _group.groupId in (");
            boolean first = true;
            while (iter.hasNext()) {
                if (!first) {
                    query1.append(",");
                }
                Group ug = iter.next();
                query1.append(Long.toString(ug.getId()));
                first = false;
            }
            query1.append(") and _entity.parentId=" + parentId);
            query1.append(" and not(_entity.id=" + parentId + ")");
            coll = this.findByObjectQuery(query1.toString(), null, null);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), e);
            }
            return coll;
        }
        return coll;
    }

    @Override
    public List<Menu> findByParentId(long parentId, boolean enaledOnly) {
        ArrayList<Menu> coll = new ArrayList<Menu>();
        List<Menu> temp = this.findChildren(parentId, null);
        for (Menu menu : temp) {
            coll.add(menu);
            List<Menu> coll2 = this.findByParentId(menu.getId(), enaledOnly);
            if (coll2 == null) continue;
            coll.addAll(coll2);
        }
        return coll;
    }

    private boolean isWriteOrReadEnable(long menuId, long userId, boolean write) {
        Set<Group> groups;
        block9: {
            User user;
            block8: {
                block7: {
                    try {
                        user = (User)this.userDAO.findById(userId);
                        if (user != null) break block7;
                        return false;
                    }
                    catch (Exception e) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error(e.getMessage(), e);
                        }
                        return false;
                    }
                }
                if (!user.isMemberOf("admin")) break block8;
                return true;
            }
            groups = user.getGroups();
            if (!groups.isEmpty()) break block9;
            return false;
        }
        StringBuilder query = new StringBuilder("select distinct(_entity) from Menu _entity  ");
        query.append(" left join _entity.accessControlList as _group ");
        query.append(WHERE);
        query.append(" _group.read=1 and ");
        if (write) {
            query.append(" _group.write=1 and ");
        }
        query.append(" _group.groupId in (");
        query.append(groups.stream().map(g -> Long.toString(g.getId())).collect(Collectors.joining(",")));
        query.append(") and _entity.id = :id");
        return CollectionUtils.isNotEmpty(this.findByObjectQuery(query.toString(), Map.of("id", menuId), null));
    }

    @Override
    public boolean isWriteEnable(long menuId, long userId) {
        return this.isWriteOrReadEnable(menuId, userId, true);
    }

    @Override
    public boolean isReadEnable(long menuId, long userId) {
        return this.isWriteOrReadEnable(menuId, userId, false);
    }

    @Override
    public String findNameById(long menuId) {
        try {
            Menu menu = (Menu)this.findById(menuId);
            return menu.getName();
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<Long> findMenuIdByUserId(long userId, boolean enabledOnly) {
        return this.findMenuIdByUserIdAndPermission(userId, Permission.READ, enabledOnly);
    }

    @Override
    public int isMenuWriteable(long menuId, long userId) {
        boolean writePrivilegeBool = this.isWriteEnable(menuId, userId);
        int writePrivilegeInt = 0;
        if (writePrivilegeBool) {
            writePrivilegeInt = 1;
        }
        return writePrivilegeInt;
    }

    @Override
    public boolean hasWriteAccess(Menu menu, long userId) {
        if (!this.isWriteEnable(menu.getId(), userId)) {
            return false;
        }
        List<Menu> children = this.findByParentId(menu.getId(), false);
        for (Menu subMenu : children) {
            if (this.hasWriteAccess(subMenu, userId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Menu> findByGroupId(long groupId) throws PersistenceException {
        if (groupId == 1L) {
            return this.findAll();
        }
        StringBuilder query = new StringBuilder("select distinct(_entity) from Menu _entity  ");
        query.append(" left join _entity.accessControlList as _group ");
        query.append(" where _entity.deleted=0 and _group.read=1 and _group.groupId =" + groupId);
        return this.findByObjectQuery(query.toString(), null, null);
    }

    public List<Long> findIdByUserId(long userId, long parentId, Integer type) {
        List<Long> ids = new ArrayList<Long>();
        try {
            User user = (User)this.userDAO.findById(userId);
            if (user == null) {
                return ids;
            }
            if (user.isMemberOf("admin")) {
                return this.findIdsByWhere("_entity.enabled=1 and _entity.parentId=" + parentId + (String)(type == null ? "" : " and _entity.type=" + String.valueOf(type)), null, null);
            }
            if (!user.getGroups().isEmpty()) {
                StringBuilder query1 = new StringBuilder("select distinct(A.ld_menuid) from ld_menu_acl A, ld_menu B  where B.ld_enabled=1 and B.ld_deleted=0 and A.ld_menuid=B.ld_id and A.ld_read=1 AND B.ld_parentid=" + parentId + " AND A.ld_groupid in (");
                query1.append(user.getGroups().stream().map(g -> Long.toString(g.getId())).collect(Collectors.joining(",")));
                query1.append(")");
                if (type != null) {
                    query1.append(" AND B.ld_type=" + type.toString());
                }
                ids = this.queryForList(query1.toString(), Long.class);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return ids;
    }

    @Override
    public List<Menu> findByName(String name) {
        return this.findByName(null, name, true);
    }

    @Override
    public List<Menu> findByName(Menu parent, String name, boolean caseSensitive) {
        StringBuilder query = null;
        query = caseSensitive ? new StringBuilder("_entity.name like '" + SqlUtil.doubleQuotes(name) + "' ") : new StringBuilder("lower(_entity.name) like '" + SqlUtil.doubleQuotes(name.toLowerCase()) + "' ");
        if (parent != null) {
            query.append(" AND _entity.parentId = " + parent.getId());
        }
        try {
            return this.findByWhere(query.toString(), null, null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Menu>();
        }
    }

    @Override
    public String computePathExtended(long menuId) {
        Menu menu = null;
        try {
            menu = (Menu)this.findById(menuId);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        if (menu == null) {
            return null;
        }
        Object path = menuId != 1L ? menu.getName() : "";
        while (menu != null && menu.getId() != menu.getParentId() && menu.getId() != 1L) {
            try {
                menu = (Menu)this.findById(menu.getParentId());
            }
            catch (PersistenceException e) {
                this.log.error(e.getMessage(), e);
            }
            if (menu == null) continue;
            StringBuilder sb = new StringBuilder(menu.getId() != 1L ? menu.getName() : "");
            sb.append("/");
            sb.append((String)path);
            path = sb.toString();
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    @Override
    public List<Menu> findByNameAndParentId(String name, long parentId) {
        try {
            return this.findByWhere("_entity.parentId = " + parentId + " and _entity.name like '" + SqlUtil.doubleQuotes(name) + "'", null, null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Menu>();
        }
    }

    @Override
    public List<Menu> findParents(long menuId) {
        ArrayList<Menu> coll = new ArrayList<Menu>();
        try {
            Menu menu = (Menu)this.findById(menuId);
            while (menu != null && menu.getId() != 1L && menu.getId() != menu.getParentId()) {
                if ((menu = (Menu)this.findById(menu.getParentId())) == null) continue;
                coll.add(0, menu);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return coll;
    }

    @Override
    public void restore(long menuId, boolean parents) throws PersistenceException {
        this.jdbcUpdate("update ld_menu set ld_deleted=0 where ld_id=" + menuId);
        if (parents) {
            String query = "select ld_parentid from ld_menu where ld_id =" + menuId;
            try {
                List<Long> menus = super.queryForList(query, Long.class);
                for (Long id : menus) {
                    if (id == menuId) continue;
                    this.restore(id, parents);
                }
            }
            catch (PersistenceException e) {
                this.log.error(e.getMessage(), e);
            }
        }
    }

    @Override
    public List<Long> findMenuIdByUserIdAndPermission(long userId, Permission permission, boolean enabledOnly) {
        List<Long> ids = new ArrayList<Long>();
        try {
            User user = (User)this.userDAO.findById(userId);
            if (user == null) {
                return ids;
            }
            if (user.isMemberOf("admin")) {
                return this.findAllIds();
            }
            if (!user.getGroups().isEmpty()) {
                StringBuilder query1 = new StringBuilder("select distinct(A.ld_menuid) from ld_menu_acl A, ld_menu B  where A.ld_menuid=B.ld_id and B.ld_deleted=0 ");
                if (enabledOnly) {
                    query1.append(" and B.ld_enabled=1 ");
                }
                query1.append(" and A.ld_" + permission.name().toLowerCase() + "=1 ");
                query1.append(" and A.ld_groupid in (");
                query1.append(user.getGroups().stream().map(g -> Long.toString(g.getId())).collect(Collectors.joining(",")));
                query1.append(")");
                ids = this.queryForList(query1.toString(), Long.class);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return ids;
    }

    @Override
    public void deleteAll(Collection<Menu> menus) throws PersistenceException {
        for (Menu menu : menus) {
            try {
                this.delete(menu.getId());
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), e);
            }
        }
    }

    @Override
    public void delete(long menuId, int code) throws PersistenceException {
        Menu menu = (Menu)this.findById(menuId);
        menu.setDeleted(code);
        this.store(menu);
    }

    @Override
    public List<Long> findIdByUserId(long userId, long parentId) {
        List<Long> ids = new ArrayList<Long>();
        try {
            User user = (User)this.userDAO.findById(userId);
            if (user == null) {
                return ids;
            }
            if (user.isMemberOf("admin")) {
                return this.findIdsByWhere("_entity.parentId=" + parentId, null, null);
            }
            Set<Group> precoll = user.getGroups();
            Iterator<Group> iter = precoll.iterator();
            if (!precoll.isEmpty()) {
                StringBuilder query1 = new StringBuilder("select distinct(A.ld_menuid) from ld_menu_acl A, ld_menu B  where B.ld_deleted=0 and A.ld_menuid=B.ld_id AND B.ld_parentid=" + parentId + " and A.ld_read=1 AND A.ld_groupid in (");
                boolean first = true;
                while (iter.hasNext()) {
                    if (!first) {
                        query1.append(",");
                    }
                    Group ug = iter.next();
                    query1.append(Long.toString(ug.getId()));
                    first = false;
                }
                query1.append(")");
                ids = this.queryForList(query1.toString(), Long.class);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return ids;
    }

    @Override
    public Menu createPath(long parentId, long tenantId, int type, String path, boolean inheritSecurity) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, "/", false);
        Menu menu = (Menu)this.findById(parentId);
        while (st.hasMoreTokens()) {
            this.initialize(menu);
            String name = st.nextToken();
            List<Menu> childs = this.findByName(menu, name, false);
            if (childs.isEmpty()) {
                menu = this.createNewMenu(name, tenantId, type, menu);
                continue;
            }
            menu = childs.iterator().next();
            this.initialize(menu);
        }
        return menu;
    }

    private Menu createNewMenu(String name, long tenantId, int type, Menu parentMenu) throws PersistenceException {
        Menu newMenu = new Menu();
        newMenu.setName(name);
        newMenu.setParentId(parentMenu.getId());
        newMenu.setTenantId(tenantId);
        newMenu.setType(type);
        this.store(newMenu);
        this.flush();
        parentMenu = newMenu;
        if (this.log.isInfoEnabled()) {
            this.log.info("created menu {}", (Object)this.computePathExtended(newMenu.getId()));
        }
        return parentMenu;
    }
}

