/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.authorization;

import com.logicaldoc.core.security.authorization.AuthorizationException;

public class UnexistingResourceException
extends AuthorizationException {
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String resource;

    public UnexistingResourceException(String username, String resource) {
        this(username, resource, null);
    }

    public UnexistingResourceException(String username, String resource, Throwable cause) {
        super(UnexistingResourceException.buildMessage(username, resource), cause);
        this.username = username;
        this.resource = resource;
    }

    public UnexistingResourceException() {
        this.username = null;
        this.resource = null;
    }

    public UnexistingResourceException(String message) {
        super(message);
        this.username = null;
        this.resource = null;
    }

    public UnexistingResourceException(Throwable cause) {
        super(cause);
        this.username = null;
        this.resource = null;
    }

    public UnexistingResourceException(String message, Throwable cause) {
        super(message, cause);
        this.username = null;
        this.resource = null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSecurityObject() {
        return this.resource;
    }

    private static String buildMessage(String username, String resource) {
        return String.format("User %s tried to access unexisting resource %s", username, resource);
    }
}

