/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.authorization;

import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.authorization.AuthorizationException;

public class PermissionException
extends AuthorizationException {
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String securityObject;
    private final Permission permission;

    public PermissionException(String username, String securityObject, Permission permission) {
        this(username, securityObject, permission, null);
    }

    public PermissionException(String username, String securityObject, Permission permission, Throwable cause) {
        super(PermissionException.buildMessage(username, securityObject, permission), cause);
        this.username = username;
        this.securityObject = securityObject;
        this.permission = permission;
    }

    public PermissionException() {
        this.username = null;
        this.securityObject = null;
        this.permission = null;
    }

    public PermissionException(String message) {
        super(message);
        this.username = null;
        this.securityObject = null;
        this.permission = null;
    }

    public PermissionException(Throwable cause) {
        super(cause);
        this.username = null;
        this.securityObject = null;
        this.permission = null;
    }

    public PermissionException(String message, Throwable cause) {
        super(message, cause);
        this.username = null;
        this.securityObject = null;
        this.permission = null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSecurityObject() {
        return this.securityObject;
    }

    public Permission getPermission() {
        return this.permission;
    }

    private static String buildMessage(String username, String securityObject, Permission permission) {
        return String.format("User %s does not have permission %s on %s", username, permission.name(), securityObject);
    }
}

