/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.authentication;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.authentication.AbstractAuthenticator;
import com.logicaldoc.core.security.authentication.AccountDisabledException;
import com.logicaldoc.core.security.authentication.AccountExpiredException;
import com.logicaldoc.core.security.authentication.AccountInactiveException;
import com.logicaldoc.core.security.authentication.AccountNotFoundException;
import com.logicaldoc.core.security.authentication.AccountTypeNotAllowedException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authentication.OutsideWorkingTimeException;
import com.logicaldoc.core.security.authentication.PasswordExpiredException;
import com.logicaldoc.core.security.authentication.PasswordWeakException;
import com.logicaldoc.core.security.authentication.UnconfirmedLegalsException;
import com.logicaldoc.core.security.authentication.WrongPasswordException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserSource;
import com.logicaldoc.core.security.user.UserType;
import com.logicaldoc.util.crypt.CryptUtil;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.Resource;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="defaultAuthenticator")
public class DefaultAuthenticator
extends AbstractAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthenticator.class);
    @Resource(name="userDAO")
    protected UserDAO userDAO;

    @Override
    public User authenticate(String username, String password) throws AuthenticationException {
        return this.authenticate(username, password, null, null);
    }

    @Override
    public User authenticate(String username, String password, String key, Client client) throws AuthenticationException {
        User user;
        try {
            user = this.pickUser(username);
        }
        catch (PersistenceException e) {
            throw new AuthenticationException(this, "dataerror", e);
        }
        if (user == null) {
            throw new AccountNotFoundException();
        }
        String test = null;
        try {
            test = CryptUtil.encryptSHA256(password);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), e);
        }
        if (user.getPassword() == null || !user.getPassword().equals(test)) {
            throw new WrongPasswordException(this);
        }
        try {
            user.setDecodedPassword(password);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), e);
        }
        this.validateUser(user);
        return user;
    }

    @Override
    public User pickUser(String username) throws PersistenceException {
        return this.userDAO.getUser(username);
    }

    public void validateUser(User user) throws AuthenticationException {
        if (user == null) {
            throw new AccountNotFoundException(this);
        }
        if (user.getType() != UserType.DEFAULT && user.getType() != UserType.READONLY) {
            throw new AccountTypeNotAllowedException();
        }
        try {
            this.userDAO.initialize(user);
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
        if (user.getEnabled() == 0) {
            throw new AccountDisabledException(this);
        }
        if (this.userDAO.isPasswordExpired(user.getUsername())) {
            throw new PasswordExpiredException(this);
        }
        if (user.isExpired()) {
            throw new AccountExpiredException(user.getExpire());
        }
        try {
            if (this.userDAO.isInactive(user.getUsername())) {
                throw new AccountInactiveException(this);
            }
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
        if (user.getEnforceWorkingTime() == 1 && !user.isInWorkingTime()) {
            throw new OutsideWorkingTimeException(this);
        }
        this.validatePasswordStrongness(user);
        this.validateLegals(user);
    }

    private void validatePasswordStrongness(User user) throws PasswordWeakException {
        if (user.getSource().equals((Object)UserSource.DEFAULT)) {
            try {
                String tenantName = Context.get(TenantDAO.class).getTenantName(user.getTenantId());
                if (Context.get().getProperties().getBoolean(tenantName + ".password.checklogin", false)) {
                    Context.get(UserDAO.class).checkPasswordCompliance(user);
                }
            }
            catch (PasswordWeakException pwe) {
                this.markPasswordExpired(user);
                throw pwe;
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    private void validateLegals(User user) throws UnconfirmedLegalsException {
        if (user.getLegals() != 0) {
            try {
                int unconfirmedLegals = this.userDAO.queryForInt("select count(*) from ld_legal where not exists (select * from ld_legal_confirmation where ld_username = :username and ld_legal=ld_name)", Map.of("username", user.getUsername()));
                if (unconfirmedLegals > 0) {
                    log.error("User {} did not confirm {} legals", (Object)user, (Object)unconfirmedLegals);
                    throw new UnconfirmedLegalsException();
                }
            }
            catch (PersistenceException e) {
                log.warn("Cannot check legals to confirm", e);
            }
        }
    }

    private void markPasswordExpired(User user) {
        try {
            this.userDAO.jdbcUpdate("update ld_user set ld_passwordexpired = 1 where ld_id = " + user.getId());
        }
        catch (PersistenceException e) {
            log.error(e.getMessage(), e);
        }
    }
}

