/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.authentication;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.authentication.AbstractAuthenticator;
import com.logicaldoc.core.security.authentication.AccountInactiveException;
import com.logicaldoc.core.security.authentication.AccountNotFoundException;
import com.logicaldoc.core.security.authentication.ApiKeyAuthenticator;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authentication.Authenticator;
import com.logicaldoc.core.security.authentication.DefaultAuthenticator;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserEvent;
import com.logicaldoc.core.security.user.UserHistory;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="authenticationChain")
public class AuthenticationChain
extends AbstractAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationChain.class);
    private List<Authenticator> authenticators = new ArrayList<Authenticator>();

    @Override
    public final User authenticate(String username, String password) throws AuthenticationException {
        return this.authenticate(username, password, null, null);
    }

    @Override
    public final User authenticate(String username, String password, String key, Client client) throws AuthenticationException {
        this.init();
        User user = this.validateAnonymousUser(username, key, client);
        if (user != null) {
            return user;
        }
        ArrayList<AuthenticationException> errors = new ArrayList<AuthenticationException>();
        user = this.authenticateUsingAuthenticators(username, password, key, client, user, errors);
        try {
            this.defaultValidations(username, client);
        }
        catch (AuthenticationException ae) {
            errors.clear();
            errors.add(ae);
            user = null;
        }
        catch (PersistenceException pe) {
            log.error(pe.getMessage(), pe);
            errors.clear();
            user = null;
        }
        log.debug("Collected authentication errors: {}", (Object)errors);
        if (user != null) {
            this.initializeUser(user);
        } else if (!errors.isEmpty()) {
            if (errors.size() > 1) {
                for (AuthenticationException err : errors) {
                    if (err instanceof AccountNotFoundException) continue;
                    throw err;
                }
            }
            throw (AuthenticationException)errors.get(0);
        }
        return user;
    }

    private void initializeUser(User user) {
        try {
            UserDAO userDao = Context.get(UserDAO.class);
            userDao.initialize(user);
        }
        catch (PersistenceException e) {
            log.warn(e.getMessage(), e);
        }
    }

    private User validateAnonymousUser(String username, String key, Client client) {
        User user = null;
        try {
            user = this.checkAnonymousLogin(username, key, client);
        }
        catch (PersistenceException | AuthenticationException e) {
            log.error(e.getMessage(), e);
        }
        return user;
    }

    private User authenticateUsingAuthenticators(String username, String password, String key, Client client, User user, List<AuthenticationException> errors) {
        for (Authenticator cmp : this.authenticators) {
            if (!cmp.isEnabled()) continue;
            if (cmp.canAuthenticateUser(username)) {
                try {
                    user = cmp.authenticate(username, password, key, client);
                }
                catch (AuthenticationException ae) {
                    errors.add(ae);
                }
            }
            if (user != null) break;
        }
        return user;
    }

    protected void defaultValidations(String username, Client client) throws AuthenticationException, PersistenceException {
        UserDAO userDao = Context.get(UserDAO.class);
        User user = userDao.findByUsername(username);
        if (user == null) {
            return;
        }
        DefaultAuthenticator defaultValidator = Context.get(DefaultAuthenticator.class);
        try {
            defaultValidator.validateUser(user);
        }
        catch (AccountInactiveException ie) {
            userDao.initialize(user);
            UserHistory transaction = new UserHistory();
            transaction.setUser(user);
            transaction.setClient(client);
            transaction.setEvent(UserEvent.DISABLED);
            transaction.setComment("inactive for too many days");
            user.setEnabled(0);
            userDao.store(user, transaction);
            throw ie;
        }
    }

    @Override
    public User pickUser(String username) {
        this.init();
        User user = null;
        for (Authenticator cmp : this.authenticators) {
            if (!cmp.isEnabled()) continue;
            if (cmp.canAuthenticateUser(username)) {
                try {
                    user = cmp.pickUser(username);
                }
                catch (Exception t) {
                    log.warn("Cannot pick user {} using authenticator {}", username, cmp.getClass().getName(), t);
                }
            }
            if (user != null) break;
        }
        this.initializeUser(user);
        return user;
    }

    protected User checkAnonymousLogin(String username, String key, Client client) throws AuthenticationException, PersistenceException {
        ContextProperties config;
        Tenant t;
        String tenant = "default";
        UserDAO userDao = Context.get(UserDAO.class);
        User user = userDao.getUser(username);
        this.defaultValidations(username, client);
        TenantDAO tdao = Context.get(TenantDAO.class);
        Tenant tenant2 = t = user != null ? (Tenant)tdao.findById(user.getTenantId()) : null;
        if (t != null) {
            tenant = t.getName();
        }
        if (key != null && "true".equals((config = Context.get().getProperties()).getProperty(tenant + ".anonymous.enabled")) && username.equals(config.getProperty(tenant + ".anonymous.user")) && key.equals(config.getProperty(tenant + ".anonymous.key"))) {
            return user;
        }
        return null;
    }

    @Override
    public boolean canAuthenticateUser(String user) {
        return false;
    }

    public synchronized void init() {
        if (!this.authenticators.isEmpty()) {
            return;
        }
        Context context = Context.get();
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "Authentication");
        ArrayList<Extension> sortedExts = new ArrayList<Extension>();
        for (Extension extension : exts) {
            sortedExts.add(extension);
        }
        Collections.sort(sortedExts, (e1, e2) -> {
            int position2;
            int position1 = Integer.parseInt(e1.getParameter("position").valueAsString());
            if (position1 < (position2 = Integer.parseInt(e2.getParameter("position").valueAsString()))) {
                return -1;
            }
            if (position1 > position2) {
                return 1;
            }
            return 0;
        });
        for (Extension extension : sortedExts) {
            this.authenticators.add((Authenticator)context.getBean(extension.getParameter("authenticatorId").valueAsString()));
        }
        if (sortedExts.isEmpty()) {
            this.authenticators.add(context.getBean(DefaultAuthenticator.class));
            this.authenticators.add(context.getBean(ApiKeyAuthenticator.class));
        }
        for (Authenticator auth : this.authenticators) {
            log.warn("Added authenticator {}", (Object)auth.getClass().getSimpleName());
        }
        log.warn("Authentication chain initialized");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

