/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security.authentication;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.apikey.ApiKey;
import com.logicaldoc.core.security.apikey.ApiKeyDAO;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authentication.DefaultAuthenticator;
import com.logicaldoc.core.security.user.User;
import jakarta.annotation.Resource;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="apiKeyAuthenticator")
public class ApiKeyAuthenticator
extends DefaultAuthenticator {
    @Resource(name="apiKeyDAO")
    protected ApiKeyDAO apiKeyDAO;

    @Override
    public User authenticate(String username, String password) throws AuthenticationException {
        return null;
    }

    @Override
    public User authenticate(String username, String password, String apikey, Client client) throws AuthenticationException {
        User user;
        if (StringUtils.isEmpty((CharSequence)apikey) || !apikey.startsWith("ld-")) {
            return null;
        }
        try {
            ApiKey apiKey = this.apiKeyDAO.findByKey(apikey);
            if (apiKey == null) {
                throw new AuthenticationException("Unexisting ApiKey " + StringUtils.abbreviate((String)apikey, (int)10));
            }
            user = (User)this.userDAO.findById(apiKey.getUserId());
            if (user == null) {
                throw new AuthenticationException("Unexisting User " + apiKey.getUserId());
            }
            this.apiKeyDAO.jdbcUpdate("update ld_apikey set ld_lastused = :now where ld_id = :id", Map.of("now", new Date(), "id", apiKey.getId()));
        }
        catch (PersistenceException | NoSuchAlgorithmException e) {
            throw new AuthenticationException(this, "dataerror", e);
        }
        this.validateUser(user);
        return user;
    }
}

