/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.LoginThrottle;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionDAO;
import com.logicaldoc.core.security.SessionListener;
import com.logicaldoc.core.security.apikey.ApiKeyDAO;
import com.logicaldoc.core.security.authentication.AuthenticationChain;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.spring.LDAuthenticationToken;
import com.logicaldoc.core.security.spring.LDDeferredSecurityContext;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.crypt.CryptUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateOptimisticLockingFailureException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="sessionManager")
public class SessionManager
extends ConcurrentHashMap<String, Session> {
    public static final String COOKIE_SID = "ldoc-sid";
    public static final String PARAM_SID = "sid";
    public static final String HEADER_APIKEY = "X-API-KEY";
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private static final long serialVersionUID = 1L;
    private static final int MAX_CLOSED_SESSIONS = 50;
    @Resource(name="authenticationChain")
    protected transient AuthenticationChain authenticationChain;
    @Resource(name="sessionDAO")
    protected transient SessionDAO sessionDao;
    @Resource(name="apiKeyDAO")
    protected transient ApiKeyDAO apiKeyDao;
    @Resource(name="userDAO")
    protected transient UserDAO userDao;
    private transient SessionTimeoutWatchDog timeoutWatchDog = new SessionTimeoutWatchDog();
    private transient List<SessionListener> listeners = new ArrayList<SessionListener>();

    public SessionManager() {
        this.timeoutWatchDog.start();
        log.info("Starting the session timeout watchdog");
    }

    public static final SessionManager get() {
        return Context.get(SessionManager.class);
    }

    public synchronized Session newSession(String username, String password, String key, HttpServletRequest request) throws AuthenticationException {
        return this.newSession(username, password, key, this.buildClient(request));
    }

    public synchronized Session newSession(String username, String password, HttpServletRequest request) throws AuthenticationException {
        return this.newSession(username, password, this.buildClient(request));
    }

    public synchronized Session newSession(String username, String password, Client client) throws AuthenticationException {
        return this.newSession(username, password, null, client);
    }

    public synchronized Session newSession(String username, String password, String key, Client client) throws AuthenticationException {
        User user;
        block3: {
            try {
                user = this.authenticationChain.authenticate(username, password, key, client);
                if (user != null) break block3;
                return null;
            }
            catch (AuthenticationException e) {
                LoginThrottle.recordFailure(username, key, client, e);
                throw e;
            }
        }
        return this.createSession(user, key, client);
    }

    public synchronized Session newSession(String apikey, Client client) throws AuthenticationException {
        User user;
        block3: {
            try {
                user = this.authenticationChain.authenticate("", "", apikey, client);
                if (user != null) break block3;
                return null;
            }
            catch (AuthenticationException e) {
                LoginThrottle.recordFailure(null, apikey, client, e);
                throw e;
            }
        }
        return this.createSession(user, apikey, client);
    }

    public synchronized Session newSession(String apikey, HttpServletRequest request) throws AuthenticationException {
        return this.newSession(apikey, this.buildClient(request));
    }

    private synchronized Session createSession(User user, String key, Client client) {
        Session session = new Session(user, key, client);
        this.put(session.getSid(), session);
        log.warn("Created new session {} for user {}", (Object)session.getSid(), (Object)user.getUsername());
        this.cleanClosedSessions();
        this.storeSession(session);
        for (SessionListener listener : this.listeners) {
            try {
                listener.onSessionCreated(session);
            }
            catch (Exception t) {
                log.warn(t.getMessage(), t);
            }
        }
        return session;
    }

    private void storeSession(Session session) {
        try {
            if (session.getId() == 0L) {
                Session dbSession = new Session(session);
                this.sessionDao.store(dbSession);
                session.setId(dbSession.getId());
            } else {
                Session dbSession = (Session)this.sessionDao.findById(session.getId());
                if (dbSession != null) {
                    dbSession.setDeleted(session.getDeleted());
                    dbSession.setLastRenew(session.getLastRenew());
                    dbSession.setStatus(session.getStatus());
                    dbSession.setFinished(session.getFinished());
                    this.sessionDao.store(dbSession);
                }
            }
        }
        catch (HibernateOptimisticLockingFailureException dbSession) {
        }
        catch (Exception t) {
            log.warn(t.getMessage(), t);
        }
    }

    public void kill(String sid) {
        Session session = this.get(sid);
        if (session != null) {
            session.setClosed();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (log.isWarnEnabled()) {
                log.warn("Killed session {} of user {} started at {}", sid, session.getUsername(), df.format(session.getCreation()));
            }
            this.storeSession(session);
            for (SessionListener listener : this.listeners) {
                try {
                    listener.onSessionClosed(sid);
                }
                catch (Exception t) {
                    log.warn(t.getMessage(), t);
                }
            }
        } else {
            try {
                this.sessionDao.jdbcUpdate("update ld_session set ld_status=2 where ld_sid='" + SqlUtil.doubleQuotes(sid) + "'");
            }
            catch (PersistenceException e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public Session remove(Object sid) {
        this.kill((String)sid);
        try {
            this.sessionDao.delete(this.get(sid).getId());
        }
        catch (PersistenceException e) {
            log.warn(e.getMessage(), e);
        }
        return (Session)super.remove(sid);
    }

    public void renew(String sid) {
        if (this.isOpen(sid)) {
            Session session = this.get(sid);
            if (session.isTimedOut()) {
                session.setExpired();
            } else {
                session.setLastRenew(new Date());
            }
        }
    }

    public int getStatus(String sid) {
        Session session = this.get(sid);
        if (session == null) {
            return -1;
        }
        if (session.getStatus() == 0 && session.isTimedOut()) {
            session.setExpired();
            this.storeSession(session);
        }
        return session.getStatus();
    }

    public boolean isOpen(String sid) {
        if (sid == null) {
            return false;
        }
        return this.getStatus(sid) == 0;
    }

    @Override
    public Session get(Object sid) {
        if (sid == null) {
            return null;
        }
        return (Session)super.get(sid);
    }

    public Session getByClientId(String clientId) {
        if (clientId == null) {
            return null;
        }
        return this.getSessions().stream().filter(s -> s.getClient() != null && clientId.equals(s.getClient().getId())).findFirst().orElse(null);
    }

    public Session getByDictionaryValue(String key, Object value) {
        return this.getSessions().stream().filter(s -> value.equals(s.getDictionary().get(key))).findFirst().orElse(null);
    }

    public int countOpened() {
        return this.sessionDao.countSessions(null, 0);
    }

    public int countOpened(long tenantId) {
        return this.sessionDao.countSessions(tenantId, 0);
    }

    public List<Session> getSessions() {
        ArrayList<Session> sessions = new ArrayList<Session>(this.values());
        Collections.sort(sessions);
        return sessions;
    }

    private void cleanClosedSessions() {
        ArrayList<String> garbage = new ArrayList<String>();
        int counter = 0;
        for (Session session : this.getSessions()) {
            if (this.getStatus(session.getSid()) != 0) {
                ++counter;
            }
            if (counter <= 50) continue;
            garbage.add(session.getSid());
        }
        for (String sid : garbage) {
            this.remove(sid);
        }
    }

    public Session getSession(HttpServletRequest request) {
        String sid = this.getSessionId(request);
        if (sid == null) {
            return null;
        }
        if (this.isOpen(sid)) {
            return this.get(sid);
        }
        return null;
    }

    public String getSessionId(HttpServletRequest request) {
        String sid = this.getSessionIdFromRequest(request);
        if (sid != null) {
            return sid;
        }
        sid = this.getSessionIdFromClient(request);
        if (sid != null) {
            return sid;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof LDAuthenticationToken) {
            LDAuthenticationToken ldAuthenticationToken = (LDAuthenticationToken)auth;
            return ldAuthenticationToken.getSid();
        }
        return null;
    }

    private String getSessionIdFromClient(HttpServletRequest request) {
        String[] credentials;
        if (request == null || !Context.get().getProperties().getBoolean("security.useclientid", false)) {
            return null;
        }
        Client client = this.buildClient(request);
        Session session = this.getByClientId(client.getId());
        if (session != null && this.isOpen(session.getSid()) && session.getUsername().equals(client.getUsername()) && (credentials = SessionManager.getBasicCredentials(request)).length == 2) {
            try {
                String sessionUserPassword = session.getUser().getPassword();
                if (StringUtils.isEmpty((CharSequence)sessionUserPassword) || CryptUtil.encryptSHA256(credentials[1]).equals(sessionUserPassword)) {
                    return session.getSid();
                }
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Unable to check credentials", e);
            }
        }
        return null;
    }

    private String getSessionIdFromRequest(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String sid = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter(PARAM_SID)) && Context.get().getProperties().getBoolean("security.acceptsid", false)) {
            log.debug("Got SID in request {}", (Object)PARAM_SID);
            sid = request.getParameter(PARAM_SID);
        } else if (StringUtils.isNotEmpty((CharSequence)request.getHeader(PARAM_SID))) {
            log.debug("Got SID in request header {}", (Object)PARAM_SID);
            sid = request.getHeader(PARAM_SID);
        } else if (request.getAttribute(PARAM_SID) != null && StringUtils.isNotEmpty((CharSequence)((String)request.getAttribute(PARAM_SID)))) {
            log.debug("Got SID in request attribute {}", (Object)PARAM_SID);
            sid = (String)request.getAttribute(PARAM_SID);
        } else if (request.getSession(true).getAttribute(PARAM_SID) != null && StringUtils.isNotEmpty((CharSequence)((String)request.getSession(true).getAttribute(PARAM_SID)))) {
            log.debug("Got SID in session attribute {}", (Object)PARAM_SID);
            sid = (String)request.getSession(true).getAttribute(PARAM_SID);
        } else {
            sid = this.getSessionIdFromCookie(request);
        }
        if (StringUtils.isEmpty((CharSequence)sid)) {
            sid = this.getSessionFromApiKey(request);
        }
        return sid;
    }

    private String getSessionFromApiKey(HttpServletRequest request) {
        String sid = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)request.getHeader(HEADER_APIKEY))) {
                log.debug("Found API Key in header {}", (Object)HEADER_APIKEY);
                String apiKey = CryptUtil.encryptSHA256(request.getHeader(HEADER_APIKEY));
                sid = this.getSessions().stream().filter(s -> apiKey.equals(s.getKey()) && s.isOpen()).map(Session::getSid).findFirst().orElse(null);
                if (StringUtils.isNotEmpty((CharSequence)sid)) {
                    log.debug("Found SID bound to API Key in header {}", (Object)HEADER_APIKEY);
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.warn(e.getMessage(), e);
        }
        return sid;
    }

    private String getSessionIdFromCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (COOKIE_SID.equals(cookie.getName())) {
                    log.debug("Got SID in cookie {}", (Object)COOKIE_SID);
                    return cookie.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public void saveSid(HttpServletRequest request, HttpServletResponse response, String sid) {
        request.setAttribute(PARAM_SID, (Object)sid);
        request.getSession(true).setAttribute(PARAM_SID, (Object)sid);
        log.debug("Saved sid {} in session {}", (Object)sid, (Object)request.getSession(true).getId());
    }

    public void removeSid(HttpServletRequest request) {
        Authentication authentication;
        if (request != null) {
            request.removeAttribute(PARAM_SID);
            if (request.getSession(false) != null) {
                log.debug("remove sid {} from session {}", request.getSession(false).getAttribute(PARAM_SID), (Object)request.getSession(true).getId());
                request.getSession(false).removeAttribute(PARAM_SID);
            }
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) != null) {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
    }

    public static String getCurrentSid() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof LDAuthenticationToken) {
            LDAuthenticationToken ldAuthenticationToken = (LDAuthenticationToken)auth;
            return ldAuthenticationToken.getSid();
        }
        return null;
    }

    public HttpSession getServletSession(String sid) {
        if (sid == null) {
            return null;
        }
        return LDDeferredSecurityContext.getServletSession(sid);
    }

    public Client buildClient(HttpServletRequest request) {
        Client client = new Client(request);
        String[] credentials = SessionManager.getBasicCredentials(request);
        if (credentials.length > 0 && credentials[0] != null) {
            client.setUsername(credentials[0]);
        }
        String authorization = request.getHeader("Authorization");
        String apiKey = request.getHeader(HEADER_APIKEY);
        client.setId(String.format("%s-%s-%s-%s-%s", StringUtils.defaultString((String)client.getUsername(), (String)"0"), StringUtils.isNotEmpty((CharSequence)authorization) ? Integer.toString(authorization.hashCode()) : "0", StringUtils.isNotEmpty((CharSequence)apiKey) ? Integer.toString(apiKey.hashCode()) : "0", request.getRemoteAddr(), StringUtils.defaultString((String)request.getHeader("user-agent"))));
        return client;
    }

    private static String[] getBasicCredentials(HttpServletRequest req) {
        String authorization = req.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic")) {
            String base64Credentials = authorization.substring("Basic".length()).trim();
            String credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
            return credentials.split(":", 2);
        }
        return new String[0];
    }

    @PreDestroy
    public void destroy() {
        log.info("Stopping the session timeout watchdog");
        this.timeoutWatchDog.finish();
        for (Session session : this.getSessions()) {
            try {
                SessionManager.get().kill(session.getSid());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clear();
        if (this.timeoutWatchDog.isAlive()) {
            try {
                this.timeoutWatchDog.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info("Session timeout watch dog killed");
        }
    }

    public synchronized void addListener(SessionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.listeners == null ? 0 : this.listeners.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionManager other = (SessionManager)obj;
        return !(this.listeners == null ? other.listeners != null : !this.listeners.equals(other.listeners));
    }

    class SessionTimeoutWatchDog
    extends Thread {
        boolean active = true;

        private SessionTimeoutWatchDog() {
            this.setDaemon(true);
            this.setName("SessionTimeoutWatchDog");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.active) {
                SessionTimeoutWatchDog sessionTimeoutWatchDog = this;
                synchronized (sessionTimeoutWatchDog) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                for (Session session : SessionManager.this.getSessions()) {
                    if (!session.isOpen() || !session.isTimedOut()) continue;
                    session.setExpired();
                    SessionManager.this.storeSession(session);
                }
            }
        }

        public void finish() {
            this.active = false;
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

