/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.SystemInfo;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.Device;
import com.logicaldoc.core.security.DeviceDAO;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserEvent;
import com.logicaldoc.core.security.user.UserHistory;
import com.logicaldoc.core.security.user.UserHistoryDAO;
import com.logicaldoc.util.crypt.CryptUtil;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="ld_session")
@Cacheable
public class Session
extends PersistentObject
implements Comparable<Session> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    public static final int STATUS_OPEN = 0;
    public static final int STATUS_EXPIRED = 1;
    public static final int STATUS_CLOSED = 2;
    private static final String ERROR = "ERROR";
    private static final String WARN = "WARN";
    private static final String INFO = "INFO";
    @Transient
    private Map<Long, String> unprotectedDocs = Collections.synchronizedMap(new HashMap());
    @Column(name="ld_lastrenew", columnDefinition="DATETIME(3)")
    private Date lastRenew = new Date();
    @Column(name="ld_finished", columnDefinition="DATETIME(3)")
    private Date finished;
    @Column(name="ld_sid", length=255, nullable=false)
    private String sid;
    @Column(name="ld_key", length=255)
    private String key;
    @Transient
    private String decodedKey;
    @Column(name="ld_keylabel", length=255)
    private String keyLabel;
    @Column(name="ld_username", length=255)
    private String username;
    @Column(name="ld_tenantname", length=255)
    private String tenantName;
    @Column(name="ld_node", length=255)
    private String node;
    @Column(name="ld_tenantid", nullable=false)
    private long tenantId;
    @Column(name="ld_status", nullable=false)
    private int status = 0;
    @Embedded
    private Client client = null;
    @Transient
    private User user = null;
    @Transient
    private transient Map<String, Object> dictionary = new ConcurrentHashMap<String, Object>();
    @Transient
    private transient List<Log> logs = new ArrayList<Log>();

    public Map<String, Object> getDictionary() {
        return this.dictionary;
    }

    public String getSid() {
        return this.sid;
    }

    public Date getLastRenew() {
        return this.lastRenew;
    }

    protected int getTimeout() {
        return Context.get().getProperties().getInt(this.getTenantName() + ".session.timeout", -1);
    }

    public boolean isOpen() {
        return this.status == 0;
    }

    protected boolean isTimedOut() {
        if (this.status != 0) {
            return true;
        }
        int timeout = this.getTimeout();
        if (timeout <= 0) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(14, 0);
        Date now = calendar.getTime();
        calendar.setTime(this.lastRenew);
        calendar.set(14, 0);
        Date lastRen = calendar.getTime();
        long diff = Math.abs(now.getTime() - lastRen.getTime());
        long diffMinutes = TimeUnit.MILLISECONDS.toMinutes(diff);
        return diffMinutes >= (long)timeout;
    }

    public int getStatus() {
        return this.status;
    }

    protected void setExpired() {
        log.warn("Session {} expired", (Object)this.getSid());
        this.logWarn("Session expired");
        this.status = 1;
        this.finished = new Date();
        UserHistoryDAO userHistoryDAO = Context.get(UserHistoryDAO.class);
        userHistoryDAO.createUserHistory(this.user, UserEvent.TIMEOUT, null, this.sid, this.client);
    }

    public void setClosed() {
        log.info("Session {} was closed", (Object)this.getSid());
        this.logInfo("Session closed");
        this.status = 2;
        this.finished = new Date();
        UserHistoryDAO userHistoryDAO = Context.get(UserHistoryDAO.class);
        userHistoryDAO.createUserHistory(this.user, UserEvent.LOGOUT, null, this.sid, this.client);
    }

    public String getDecodedKey() {
        return this.decodedKey;
    }

    public void setDecodedKey(String decodedKey) throws NoSuchAlgorithmException {
        if (StringUtils.isNotEmpty(decodedKey)) {
            this.decodedKey = decodedKey;
            this.key = CryptUtil.encryptSHA256(decodedKey);
            String abbreviation = decodedKey.length() > 14 ? StringUtils.right(decodedKey, 4) : "";
            this.keyLabel = decodedKey.length() < 10 ? "..." : StringUtils.abbreviate(decodedKey, 10) + abbreviation;
        }
    }

    private Session() {
    }

    Session(User user, String key, Client client) {
        if (user == null) {
            throw new IllegalArgumentException("user cannot be null");
        }
        this.sid = UUID.randomUUID().toString();
        this.tenantId = user.getTenantId();
        this.user = user;
        this.username = user.getUsername();
        try {
            this.setDecodedKey(key);
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("Cannot save the key", e);
        }
        this.client = client;
        this.node = SystemInfo.get().getInstallationId();
        this.setLastRenew(this.getCreation());
        TenantDAO tenantDAO = Context.get(TenantDAO.class);
        try {
            this.tenantName = tenantDAO.getTenantName(this.tenantId);
        }
        catch (PersistenceException e) {
            log.warn("Cannot retrieve the name of tenant {}", (Object)this.tenantId);
        }
        UserHistory history = this.saveLoginEvent(user, client);
        if (client != null && client.getDevice() != null) {
            client.getDevice().setUserId(user.getId());
            client.getDevice().setUsername(user.getFullName());
            DeviceDAO deviceDAO = Context.get(DeviceDAO.class);
            Device device = deviceDAO.findByDevice(client.getDevice());
            if (device == null) {
                device = client.getDevice();
            }
            device.setUserId(user.getId());
            device.setUsername(user.getFullName());
            device.setLastLogin(this.getCreation());
            device.setIp(client.getAddress());
            try {
                boolean newDevice = device.getId() == 0L;
                deviceDAO.store(device);
                client.setDevice(device);
                history.setDevice(client.getDevice().toString());
                if (client.getGeolocation() != null) {
                    history.setGeolocation(client.getGeolocation().toString());
                }
                Context.get(UserHistoryDAO.class).store(history);
                if (newDevice && Context.get().getProperties().getBoolean(this.tenantName + ".alertnewdevice", true)) {
                    HashMap<String, Object> dictionaryMap = new HashMap<String, Object>();
                    dictionaryMap.put("user", user);
                    dictionaryMap.put("device", device);
                    dictionaryMap.put("client", client);
                    dictionaryMap.put("location", client.getGeolocation());
                    dictionaryMap.put("event", history);
                    EMail email = new EMail();
                    email.setTenantId(this.tenantId);
                    email.setHtml(1);
                    email.setLocale(user.getLocale());
                    Recipient recipient = new Recipient();
                    recipient.setAddress(user.getEmail());
                    recipient.setName(user.getFullName());
                    recipient.setMode("TO");
                    email.getRecipients().add(recipient);
                    Context.get(EMailSender.class).sendAsync(email, "newdevice", dictionaryMap);
                }
            }
            catch (PersistenceException e) {
                log.warn("Cannot record the device {}", (Object)device);
            }
        }
        log.info("Session {} has been started", (Object)this.getSid());
        this.logInfo("Session started");
    }

    Session(Session other) {
        this.setId(other.getId());
        this.setTenantId(other.getTenantId());
        this.setTenantName(other.tenantName);
        this.setSid(other.sid);
        this.key = other.key;
        this.keyLabel = other.keyLabel;
        this.decodedKey = other.decodedKey;
        this.setNode(other.node);
        this.username = other.username;
        this.setCreation(other.getCreation());
        this.setLastRenew(other.lastRenew);
        this.setClient(other.client);
    }

    private UserHistory saveLoginEvent(User user, Client client) {
        Object historyComment = "";
        if (client != null) {
            String addr = client.getAddress();
            String host = client.getHost();
            historyComment = StringUtils.isNotEmpty(host) && !host.equals(addr) ? host + " (" + addr + ") " : addr;
        }
        UserHistoryDAO userHistoryDAO = Context.get(UserHistoryDAO.class);
        UserHistory history = userHistoryDAO.createUserHistory(user, UserEvent.LOGIN, (String)historyComment, this.sid, client);
        try {
            user.setLastLogin(history.getDate());
            userHistoryDAO.jdbcUpdate("update ld_user set ld_lastlogin = :lastLogin where ld_id = :userId", Map.of("lastLogin", user.getLastLogin(), "userId", user.getId()));
        }
        catch (PersistenceException e) {
            log.warn("Last login of user {} not saved", (Object)user.getUsername());
        }
        return history;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public String toString() {
        return this.getSid();
    }

    public long getUserId() {
        return this.user.getId();
    }

    @Override
    public long getTenantId() {
        return this.tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void logError(String message) {
        this.logs.add(0, new Log(ERROR, message));
    }

    public void logWarn(String message) {
        this.logs.add(0, new Log(WARN, message));
    }

    public void logInfo(String message) {
        this.logs.add(0, new Log(INFO, message));
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    public Log getLastError() {
        if (this.logs == null || this.logs.isEmpty()) {
            return null;
        }
        for (Log lg : this.logs) {
            if (!ERROR.equals(lg.getLevel())) continue;
            return lg;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.logs.isEmpty();
    }

    public long getDuration() {
        return Math.abs(this.getCreation().getTime() - (this.getFinished() != null ? this.getFinished().getTime() : new Date().getTime()));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Client getClient() {
        return this.client;
    }

    void setClient(Client client) {
        this.client = client;
    }

    public User getUser() {
        return this.user;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public Map<Long, String> getUnprotectedDocs() {
        return this.unprotectedDocs;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void setLastRenew(Date lastRenew) {
        this.lastRenew = lastRenew;
    }

    public Date getFinished() {
        return this.finished;
    }

    public void setFinished(Date finished) {
        this.finished = finished;
    }

    protected void setSid(String sid) {
        this.sid = sid;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public void setKeyLabel(String keyLabel) {
        this.keyLabel = keyLabel;
    }

    @Override
    public int compareTo(Session other) {
        if (this.equals(other)) {
            return 0;
        }
        int compare = Integer.compare(this.status, other.status);
        if (compare == 0) {
            compare = other.getCreation().compareTo(this.getCreation());
        }
        return compare;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sid == null ? 0 : this.sid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Session other = (Session)obj;
        return !(this.sid == null ? other.sid != null : !this.sid.equals(other.sid));
    }

    public class Log {
        private Date date = new Date();
        private String level;
        private String message;

        public Log(String level, String message) {
            this.level = level;
            this.message = message;
        }

        public String toString() {
            return this.message;
        }

        public String getLevel() {
            return this.level;
        }

        public Date getDate() {
            return this.date;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

