/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailSender;
import com.logicaldoc.core.communication.MessageTemplate;
import com.logicaldoc.core.communication.MessageTemplateDAO;
import com.logicaldoc.core.communication.Recipient;
import com.logicaldoc.core.communication.SystemMessage;
import com.logicaldoc.core.communication.SystemMessageDAO;
import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.authentication.ApiKeyBlockedException;
import com.logicaldoc.core.security.authentication.AuthenticationException;
import com.logicaldoc.core.security.authentication.IPBlockedException;
import com.logicaldoc.core.security.authentication.UsernameBlockedException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserEvent;
import com.logicaldoc.core.security.user.UserHistory;
import com.logicaldoc.core.security.user.UserHistoryDAO;
import com.logicaldoc.core.sequence.Sequence;
import com.logicaldoc.core.sequence.SequenceDAO;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginThrottle {
    private static final String THROTTLE_ENABLED = "throttle.enabled";
    public static final String LOGINFAIL_APIKEY = "loginfail-apikey-";
    public static final String LOGINFAIL_IP = "loginfail-ip-";
    public static final String LOGINFAIL_USERNAME = "loginfail-username-";
    private static final Logger log = LoggerFactory.getLogger(LoginThrottle.class);

    private LoginThrottle() {
    }

    public static void clearFailures(String username, String ip) {
        if (Context.get().getProperties().getBoolean(THROTTLE_ENABLED)) {
            SequenceDAO sDao = Context.get(SequenceDAO.class);
            if (StringUtils.isNotEmpty(username)) {
                try {
                    sDao.delete(LOGINFAIL_USERNAME + username, 0L, -1L);
                }
                catch (PersistenceException e) {
                    log.warn(e.getMessage(), e);
                }
            }
            if (StringUtils.isNotEmpty(ip)) {
                try {
                    sDao.delete(LOGINFAIL_IP + ip, 0L, -1L);
                }
                catch (PersistenceException e) {
                    log.warn(e.getMessage(), e);
                }
            }
        }
    }

    public static void recordFailure(String username, String apiKey, Client client, AuthenticationException exception) {
        if (exception == null || !exception.mustRecordFailure()) {
            return;
        }
        if (Context.get().getProperties().getBoolean(THROTTLE_ENABLED)) {
            SequenceDAO sDao = Context.get(SequenceDAO.class);
            if (StringUtils.isNotEmpty(username)) {
                sDao.next(LOGINFAIL_USERNAME + username, 0L, -1L);
            }
            if (StringUtils.isNotEmpty(client.getAddress())) {
                sDao.next(LOGINFAIL_IP + client.getAddress(), 0L, -1L);
            }
            if (StringUtils.isNotEmpty(apiKey)) {
                sDao.next(LOGINFAIL_APIKEY + apiKey, 0L, -1L);
            }
        }
        UserDAO uDao = Context.get(UserDAO.class);
        try {
            User user = uDao.findByUsername(username);
            if (user == null) {
                user = new User();
                user.setUsername(username);
                user.setName(username);
            }
            UserHistoryDAO dao = Context.get(UserHistoryDAO.class);
            dao.createUserHistory(user, UserEvent.LOGIN_FAILED, exception.getMessage(), null, client);
        }
        catch (PersistenceException e) {
            log.warn(e.getMessage(), e);
        }
    }

    public static void checkLoginThrottle(String username, String apikey, String ip) throws AuthenticationException {
        if (!Context.get().getProperties().getBoolean(THROTTLE_ENABLED)) {
            return;
        }
        if ("admin".equals(username) && ("127.0.0.1".equals(ip) || "::1".equals(ip))) {
            return;
        }
        log.debug("Take anti brute force attack countermeasures");
        LoginThrottle.checkUsername(username);
        LoginThrottle.checkIp(ip);
        LoginThrottle.checkApikey(apikey);
    }

    private static void checkIp(String ip) throws IPBlockedException {
        long count;
        String counterName;
        Sequence seq;
        SequenceDAO sDao = Context.get(SequenceDAO.class);
        Calendar cal = Calendar.getInstance();
        ContextProperties config = Context.get().getProperties();
        int wait = config.getInt("throttle.ip.wait", 0);
        int maxTrials = config.getInt("throttle.ip.max", 0);
        if (maxTrials > 0 && wait > 0 && (seq = sDao.findByAlternateKey(counterName = LOGINFAIL_IP + ip, 0L, -1L)) != null && (count = seq.getValue()) >= (long)maxTrials) {
            cal.add(12, -wait);
            Date oldestDate = cal.getTime();
            if (oldestDate.before(seq.getLastModified())) {
                log.warn("Possible brute force attack detected for IP {}", (Object)ip);
                LoginThrottle.notifyBruteForceAttack(null, ip, null);
                throw new IPBlockedException();
            }
            log.info("Login block for IP {} expired", (Object)ip);
            LoginThrottle.deleteSequence(seq);
        }
    }

    private static void checkUsername(String username) throws UsernameBlockedException {
        long count;
        String counterName;
        Sequence seq;
        SequenceDAO sDao = Context.get(SequenceDAO.class);
        Calendar cal = Calendar.getInstance();
        ContextProperties config = Context.get().getProperties();
        int wait = config.getInt("throttle.username.wait", 0);
        int maxTrials = config.getInt("throttle.username.max", 0);
        if (maxTrials > 0 && wait > 0 && (seq = sDao.findByAlternateKey(counterName = LOGINFAIL_USERNAME + username, 0L, -1L)) != null && (count = seq.getValue()) >= (long)maxTrials) {
            cal.add(12, -wait);
            Date oldestDate = cal.getTime();
            if (oldestDate.before(seq.getLastModified())) {
                log.warn("Possible brute force attack detected for username {}", (Object)username);
                LoginThrottle.notifyBruteForceAttack(username, null, null);
                LoginThrottle.disableUser(username);
                throw new UsernameBlockedException();
            }
            log.info("Login block for username {} expired", (Object)username);
            LoginThrottle.deleteSequence(seq);
        }
    }

    private static void checkApikey(String apikey) throws ApiKeyBlockedException {
        long count;
        String counterName;
        Sequence seq;
        if (StringUtils.isEmpty(apikey)) {
            return;
        }
        SequenceDAO sDao = Context.get(SequenceDAO.class);
        Calendar cal = Calendar.getInstance();
        ContextProperties config = Context.get().getProperties();
        int wait = config.getInt("throttle.apikey.wait", 0);
        int maxTrials = config.getInt("throttle.apikey.max", 0);
        if (maxTrials > 0 && wait > 0 && (seq = sDao.findByAlternateKey(counterName = LOGINFAIL_APIKEY + apikey, 0L, -1L)) != null && (count = seq.getValue()) >= (long)maxTrials) {
            cal.add(12, -wait);
            Date oldestDate = cal.getTime();
            if (oldestDate.before(seq.getLastModified())) {
                log.warn("Possible brute force attack detected for ApiKey {}", (Object)apikey);
                LoginThrottle.notifyBruteForceAttack(null, null, apikey);
                throw new ApiKeyBlockedException();
            }
            log.info("Login block for ApiKey {} expired", (Object)apikey);
            LoginThrottle.deleteSequence(seq);
        }
    }

    protected static void disableUser(String username) {
        if (Context.get().getProperties().getBoolean("throttle.username.disableuser", false)) {
            try {
                UserDAO userDao = Context.get(UserDAO.class);
                User user = userDao.findByUsername(username);
                if (user != null && user.getEnabled() == 1) {
                    user.setEnabled(0);
                    UserHistory transaction = new UserHistory();
                    transaction.setEvent(UserEvent.DISABLED);
                    transaction.setUser(user);
                    transaction.setComment("too many login failures");
                    userDao.store(user, transaction);
                }
            }
            catch (PersistenceException e) {
                log.warn("Error trying to disable user{}", (Object)username, (Object)e);
            }
        }
    }

    private static void notifyBruteForceAttack(String suspectedUsername, String suspectedIp, String suspectedApiKey) {
        ThreadPools.get().schedule(() -> {
            try {
                Date date = new Date();
                List<User> recipients = LoginThrottle.getRecipients();
                for (User user : recipients) {
                    log.debug("Prepare Brute Force Attack Alert for user {}", (Object)user);
                    HashMap<String, Object> dictionary = new HashMap<String, Object>();
                    dictionary.put("suspectedUsername", suspectedUsername);
                    dictionary.put("suspectedIp", suspectedIp);
                    dictionary.put("suspectedApiKey", suspectedApiKey);
                    dictionary.put("date", date);
                    dictionary.put("locale", user.getLocale());
                    MessageTemplateDAO templateDAO = Context.get(MessageTemplateDAO.class);
                    MessageTemplate template = templateDAO.findByNameAndLanguage("bfa.alert", user.getLanguage(), 1L);
                    if (template == null) {
                        template = templateDAO.findByNameAndLanguage("bfa.alert", "en", 1L);
                    }
                    String subject = template.getFormattedSubject(dictionary);
                    String body = template.getFormattedBody(dictionary);
                    SystemMessage message = new SystemMessage();
                    message.setTenantId(user.getTenantId());
                    message.setType(0);
                    message.setHtml(1);
                    message.setAuthor("SYSTEM");
                    message.setLocale(user.getLocale());
                    message.setMessageText(body);
                    message.setSubject(subject);
                    Recipient recipient = new Recipient();
                    recipient.setAddress(user.getEmail());
                    recipient.setName(user.getUsername());
                    recipient.setType(0);
                    message.getRecipients().add(recipient);
                    SystemMessageDAO messageDAO = Context.get(SystemMessageDAO.class);
                    messageDAO.store(message);
                    EMail email = new EMail();
                    email.setTenantId(message.getTenantId());
                    email.setHtml(message.getHtml());
                    email.setLocale(message.getLocale());
                    email.setAuthor(message.getAuthor());
                    email.setSubject(message.getSubject());
                    email.setMessageText(message.getMessageText());
                    recipient = new Recipient();
                    recipient.setAddress(user.getEmail());
                    recipient.setName(user.getFullName());
                    recipient.setMode("TO");
                    email.getRecipients().add(recipient);
                    EMailSender sender = Context.get(EMailSender.class);
                    sender.sendAsync(email);
                }
            }
            catch (PersistenceException | AutomationException e) {
                log.warn(e.getMessage(), e);
            }
            return null;
        }, "BruteForceAttack", 500L);
    }

    private static List<User> getRecipients() throws PersistenceException {
        ArrayList<User> recipients = new ArrayList<User>();
        String setting = Context.get().getProperties().getProperty("throttle.alert.recipients", "");
        if (StringUtils.isNotEmpty(setting)) {
            String[] usernames;
            UserDAO uDao = Context.get(UserDAO.class);
            String[] stringArray = usernames = setting.split(",");
            int n = usernames.length;
            int n2 = 0;
            while (n2 < n) {
                String username = stringArray[n2];
                User user = uDao.findByUsername(username);
                if (user != null) {
                    recipients.add(user);
                }
                ++n2;
            }
        }
        return recipients;
    }

    private static void deleteSequence(Sequence seq) {
        try {
            SequenceDAO sDao = Context.get(SequenceDAO.class);
            sDao.delete(seq.getId());
        }
        catch (PersistenceException e) {
            log.warn(e.getMessage(), e);
        }
    }
}

