/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.SystemInfo;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionDAO;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="sessionDAO")
@Transactional
public class HibernateSessionDAO
extends HibernatePersistentObjectDAO<Session>
implements SessionDAO {
    private static final String AND = " and ";

    protected HibernateSessionDAO() {
        super(Session.class);
    }

    @Override
    public void deleteCurrentNodeSessions() {
        try {
            this.jdbcUpdate("update ld_session set ld_deleted=1 where ld_node = :node and ld_deleted=0", Map.of("node", SystemInfo.get().getInstallationId()));
        }
        catch (PersistenceException e) {
            this.log.warn(e.getMessage(), e);
        }
        try {
            this.jdbcUpdate("update ld_session set ld_status=1 where ld_node = :node and ld_status = :status", Map.of("node", SystemInfo.get().getInstallationId(), "status", 0));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
    }

    @Override
    public int countSessions(Long tenantId, Integer status) {
        StringBuilder query = new StringBuilder(" 1=1 ");
        if (tenantId != null) {
            query.append(" and _entity.tenantId = " + String.valueOf(tenantId));
        }
        if (status != null) {
            query.append(" and _entity.status = " + String.valueOf(status));
            if (status == 0) {
                query.append(" and _entity.finished is null ");
            }
        }
        try {
            List sessions = this.findByWhere(query.toString(), null, null);
            return sessions.size();
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return 0;
        }
    }

    @Override
    public Session findBySid(String sid) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sid", sid);
            List sessions = this.findByWhere("_entity.sid = :sid", params, null, null);
            for (Session session : sessions) {
                if (session.getDeleted() != 0) continue;
                return session;
            }
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public List<Session> findByNode(String node) {
        try {
            if (StringUtils.isEmpty(node)) {
                return this.findByWhere(" 1=1 ", null, "_entity.creation desc", null);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("node", node);
            return this.findByWhere("_entity.node = :node", params, "_entity.creation desc", null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Session>();
        }
    }

    @Override
    public void cleanOldSessions(int ttl) {
        try {
            this.log.info("cleanOldSessions rows updated: {}", (Object)this.cleanOldRecords(ttl, "ld_session", "ld_creation"));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
    }
}

