/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.security.Device;
import com.logicaldoc.core.security.DeviceDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="deviceDAO")
@Transactional
public class HibernateDeviceDAO
extends HibernatePersistentObjectDAO<Device>
implements DeviceDAO {
    private static final String USER_ID_EQUAL_USER_ID = ".userId = :userId";
    private static final String AND = " and ";
    private static final String USER_ID = "userId";
    @Resource(name="userDAO")
    private UserDAO userDAO;

    private HibernateDeviceDAO() {
        super(Device.class);
        this.log = LoggerFactory.getLogger(HibernateDeviceDAO.class);
    }

    @Override
    public Device findByDeviceId(String deviceId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("deviceId", deviceId);
            List devices = this.findByWhere("_entity.deviceId = :deviceId", params, null, null);
            return devices.isEmpty() ? null : (Device)devices.get(0);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<Device> findTrustedDevices(long userId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(USER_ID, userId);
            return this.findByWhere("_entity.trusted=1 and _entity.userId = :userId", params, "_entity.lastLogin desc", null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Device>();
        }
    }

    @Override
    public List<Device> findByUserId(long userId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(USER_ID, userId);
            return this.findByWhere("_entity.userId = :userId", params, "_entity.lastLogin desc", null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Device>();
        }
    }

    @Override
    public Device trustDevice(User user, Device requestDevice) throws PersistenceException {
        Device device = this.findByDevice(requestDevice);
        if (device == null) {
            device = requestDevice;
        }
        if (StringUtils.isNotEmpty((CharSequence)requestDevice.getLabel())) {
            device.setLabel(requestDevice.getLabel());
        }
        device.setTrusted(1);
        device.setUserId(user.getId());
        device.setUsername(user.getFullName());
        this.store(device);
        return device;
    }

    @Override
    public void cleanOldDevices(int ttl) {
        try {
            this.log.info("cleanOldDevices rows updated: {}", (Object)this.cleanOldRecords(ttl, "ld_device", "ld_creation"));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
    }

    @Override
    public void store(Device entity) throws PersistenceException {
        if (StringUtils.isEmpty((CharSequence)entity.getDeviceId())) {
            entity.setDeviceId(UUID.randomUUID().toString());
        }
        super.store(entity);
    }

    @Override
    public boolean isTrustedDevice(String username, HttpServletRequest request) throws PersistenceException {
        User user = this.userDAO.findByUsername(username);
        if (user == null) {
            return false;
        }
        Device requestDevice = new Device(request);
        if (requestDevice.getDeviceId() == null) {
            return false;
        }
        List<Device> trustedDevices = this.findTrustedDevices(user.getId());
        return trustedDevices.stream().anyMatch(d -> d.getDeviceId().equals(requestDevice.getDeviceId()));
    }

    @Override
    public Device findByDevice(Device device) {
        List devices;
        block12: {
            if (device.getDeviceId() != null) {
                return this.findByDeviceId(device.getDeviceId());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            StringBuilder query = new StringBuilder();
            query.append("_entity.userId = :userId");
            params.put(USER_ID, device.getUserId());
            query.append(AND);
            if (device.getBrowser() != null) {
                query.append("_entity.browser = :browser");
                params.put("browser", device.getBrowser());
            } else {
                query.append("_entity.browser is null");
            }
            query.append(AND);
            if (device.getBrowserVersion() != null) {
                query.append("_entity.browserVersion = :browserVersion");
                params.put("browserVersion", device.getBrowserVersion());
            } else {
                query.append("_entity.browserVersion is null");
            }
            query.append(AND);
            if (device.getOperativeSystem() != null) {
                query.append("_entity.operativeSystem = :operativeSystem");
                params.put("operativeSystem", device.getOperativeSystem());
            } else {
                query.append("_entity.operativeSystem is null");
            }
            query.append(AND);
            if (device.getType() != null) {
                query.append("_entity.type = :type");
                params.put("type", device.getType());
            } else {
                query.append("_entity.type is null");
            }
            try {
                devices = this.findByWhere(query.toString(), params, null, null);
                if (!devices.isEmpty()) break block12;
                return null;
            }
            catch (PersistenceException e) {
                this.log.error(e.getMessage(), e);
                return null;
            }
        }
        return (Device)devices.get(0);
    }

    @Override
    public void delete(long deviceId, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        Device device = (Device)this.findById(deviceId);
        if (device != null) {
            device.setDeleted(code);
            device.setDeviceId(device.getId() + "." + device.getDeviceId());
            this.saveOrUpdate(device);
        }
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }
}

