/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.util.http.FileHttpClientResponseHandler;
import com.logicaldoc.util.http.HttpUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.stream.Stream;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Geolocation {
    private static final String CONST_GEOLOCATION = "geolocation";
    private static final Logger log = LoggerFactory.getLogger(Geolocation.class);
    private String countryCode;
    private String country;
    private String city;
    private String postal;
    private String state;
    private static Geolocation singleton;
    private DatabaseReader dbReader;

    private Geolocation() {
    }

    public static Geolocation get() {
        if (singleton == null) {
            singleton = new Geolocation();
        }
        return singleton;
    }

    public static Geolocation get(String ip) throws IOException {
        return Geolocation.get().geolocate(ip);
    }

    public boolean isEnabled() {
        return Context.get().getProperties().getBoolean("security.geolocation.enabled", false);
    }

    private Geolocation geolocate(String ip) throws IOException {
        if (!this.isEnabled()) {
            return null;
        }
        Geolocation.get().initDB();
        if (Geolocation.get().dbReader == null) {
            return null;
        }
        InetAddress ipAddress = InetAddress.getByName(ip);
        try {
            CityResponse response = Geolocation.get().dbReader.city(ipAddress);
            Geolocation geo = new Geolocation(response.getCountry().getName(), response.getCountry().getIsoCode(), response.getCity().getName(), response.getPostal().getCode(), response.getLeastSpecificSubdivision().getName());
            log.debug("IP {} is located at {}", (Object)ip, (Object)geo);
            return geo;
        }
        catch (GeoIp2Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String getDatabaseVersion() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        File database = Geolocation.getDatabaseFile();
        if (!database.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DatabaseReader reader = new DatabaseReader.Builder(database).build();){
                return df.format(reader.getMetadata().getBuildDate()) + " - " + reader.getMetadata().getDatabaseType();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.warn("Cannot read the version of database {}", (Object)database.getPath());
            return null;
        }
    }

    public void syncDB(String key) throws IOException {
        File gzFile = null;
        File tmpDir = null;
        try {
            String downloadUrl = "https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-City&license_key=YOUR_LICENSE_KEY&suffix=tar.gz";
            downloadUrl = downloadUrl.replace("YOUR_LICENSE_KEY", key);
            log.info("Downloading geolocation database {}", (Object)downloadUrl);
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (CloseableHttpClient httpclient = HttpUtil.getNotValidatingClient(60);){
                gzFile = FileUtil.createTempFile(CONST_GEOLOCATION, ".tar.gz");
                httpclient.execute((ClassicHttpRequest)new HttpGet(downloadUrl), (HttpClientResponseHandler)new FileHttpClientResponseHandler(gzFile));
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            log.info("Downloaded geolocation database {}", (Object)gzFile.getPath());
            tmpDir = FileUtil.createTempFile(CONST_GEOLOCATION, null);
            FileUtil.delete(tmpDir);
            tmpDir.mkdir();
            throwable = null;
            throwable2 = null;
            try (ZipUtil zipUtil = new ZipUtil();){
                zipUtil.unGZipUnTar(gzFile, tmpDir);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            File mmdbFile = null;
            throwable2 = null;
            Object var7_12 = null;
            try (Stream<Path> paths = Files.walk(tmpDir.toPath(), new FileVisitOption[0]);){
                mmdbFile = paths.filter(p -> p.toFile().isFile() && p.toFile().getName().endsWith(".mmdb")).toList().get(0).toFile();
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            if (!mmdbFile.exists()) {
                throw new IOException("Database file not found");
            }
            FileUtil.copyFile(mmdbFile, Geolocation.getDatabaseFile());
            FileUtil.delete(mmdbFile);
            this.dispose();
        }
        catch (Throwable throwable) {
            FileUtil.delete(gzFile);
            FileUtil.delete(tmpDir);
            throw throwable;
        }
        FileUtil.delete(gzFile);
        FileUtil.delete(tmpDir);
    }

    private void initDB() throws IOException {
        File database = Geolocation.getDatabaseFile();
        if (!database.exists() || database.length() <= 0L || this.dbReader != null) {
            return;
        }
        log.info("Try to read the geolocation database {}", (Object)database);
        this.dbReader = Context.get().getProperties().getBoolean("security.geolocation.cache", false) ? new DatabaseReader.Builder(database).withCache((NodeCache)new CHMCache()).build() : new DatabaseReader.Builder(database).build();
    }

    private Geolocation(String country, String countryCode, String city, String postal, String state) {
        this.country = country;
        this.countryCode = countryCode;
        this.city = city;
        this.postal = postal;
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCity() {
        return this.city;
    }

    public String getPostal() {
        return this.postal;
    }

    public String getState() {
        return this.state;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.city != null) {
            sb.append(this.city);
        }
        if (this.state != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.state);
        }
        if (this.country != null) {
            if (sb.length() > 0) {
                sb.append(" (");
                sb.append(this.countryCode);
                sb.append(")");
            } else {
                sb.append(this.country);
            }
        }
        return sb.toString();
    }

    private static File getDatabaseFile() {
        File folder = PluginRegistry.getPluginResource("logicaldoc-core", CONST_GEOLOCATION);
        return new File(folder, "geolocation.db");
    }

    public void dispose() {
        if (this.dbReader != null) {
            try {
                this.dbReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dbReader = null;
        }
    }
}

