/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.core.security.AccessControlEntry;
import com.logicaldoc.core.security.Permission;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import java.util.Set;

@Embeddable
public class ExtendedAccessControlEntry
extends AccessControlEntry {
    private static final long serialVersionUID = 1L;
    @Embedded
    private AccessControlEntry ace = new AccessControlEntry();
    @Column(name="ld_preview", nullable=false)
    protected int preview = 1;
    @Column(name="ld_download", nullable=false)
    protected int download = 1;
    @Column(name="ld_security", nullable=false)
    protected int security = 0;
    @Column(name="ld_delete", nullable=false)
    protected int delete = 0;
    @Column(name="ld_rename", nullable=false)
    protected int rename = 0;
    @Column(name="ld_immutable", nullable=false)
    protected int immutable = 0;
    @Column(name="ld_sign", nullable=false)
    protected int sign = 0;
    @Column(name="ld_archive", nullable=false)
    protected int archive = 0;
    @Column(name="ld_workflow", nullable=false)
    protected int workflow = 0;
    @Column(name="ld_calendar", nullable=false)
    protected int calendar = 0;
    @Column(name="ld_subscription", nullable=false)
    protected int subscription = 0;
    @Column(name="ld_password", nullable=false)
    protected int password = 0;
    @Column(name="ld_print", nullable=false)
    protected int print = 1;
    @Column(name="ld_move", nullable=false)
    protected int move = 0;
    @Column(name="ld_email", nullable=false)
    protected int email = 1;
    @Column(name="ld_automation", nullable=false)
    protected int automation = 0;
    @Column(name="ld_readingreq", nullable=false)
    protected int readingreq = 0;
    @Column(name="ld_customid", nullable=false)
    protected int customid = 0;
    @Column(name="ld_revision", nullable=false)
    protected int revision = 0;

    public ExtendedAccessControlEntry() {
    }

    public ExtendedAccessControlEntry(ExtendedAccessControlEntry source) {
        super(source);
        this.ace = new AccessControlEntry(source.getAce());
        this.archive = source.archive;
        this.automation = source.automation;
        this.calendar = source.calendar;
        this.delete = source.delete;
        this.download = source.download;
        this.email = source.email;
        this.immutable = source.immutable;
        this.move = source.move;
        this.password = source.password;
        this.preview = source.preview;
        this.print = source.print;
        this.rename = source.rename;
        this.security = source.security;
        this.sign = source.sign;
        this.subscription = source.subscription;
        this.workflow = source.workflow;
        this.readingreq = source.readingreq;
        this.customid = source.customid;
        this.revision = source.revision;
    }

    protected ExtendedAccessControlEntry(long groupId) {
        super(groupId);
        this.ace.setGroupId(groupId);
    }

    public AccessControlEntry getAce() {
        return this.ace;
    }

    public void setAce(AccessControlEntry ace) {
        this.ace = ace;
    }

    protected void grantedBasicPermissions(Set<Permission> granted) {
        if (this.read == 1) {
            granted.add(Permission.READ);
        }
        if (this.preview == 1) {
            granted.add(Permission.PREVIEW);
        }
        if (this.write == 1) {
            granted.add(Permission.WRITE);
        }
        if (this.rename == 1) {
            granted.add(Permission.RENAME);
        }
        if (this.delete == 1) {
            granted.add(Permission.DELETE);
        }
        if (this.download == 1) {
            granted.add(Permission.DOWNLOAD);
        }
        if (this.move == 1) {
            granted.add(Permission.MOVE);
        }
        if (this.print == 1) {
            granted.add(Permission.PRINT);
        }
        if (this.email == 1) {
            granted.add(Permission.EMAIL);
        }
    }

    @Override
    public void grantPermissions(Set<Permission> permissions) {
        super.grantPermissions(permissions);
        this.ace.grantPermissions(permissions);
        this.preview = this.booleanToInt(permissions.contains((Object)Permission.PREVIEW));
        this.download = this.booleanToInt(permissions.contains((Object)Permission.DOWNLOAD));
        this.security = this.booleanToInt(permissions.contains((Object)Permission.SECURITY));
        this.delete = this.booleanToInt(permissions.contains((Object)Permission.DELETE));
        this.rename = this.booleanToInt(permissions.contains((Object)Permission.RENAME));
        this.immutable = this.booleanToInt(permissions.contains((Object)Permission.IMMUTABLE));
        this.sign = this.booleanToInt(permissions.contains((Object)Permission.SIGN));
        this.archive = this.booleanToInt(permissions.contains((Object)Permission.ARCHIVE));
        this.workflow = this.booleanToInt(permissions.contains((Object)Permission.WORKFLOW));
        this.calendar = this.booleanToInt(permissions.contains((Object)Permission.CALENDAR));
        this.subscription = this.booleanToInt(permissions.contains((Object)Permission.SUBSCRIPTION));
        this.password = this.booleanToInt(permissions.contains((Object)Permission.PASSWORD));
        this.print = this.booleanToInt(permissions.contains((Object)Permission.PRINT));
        this.move = this.booleanToInt(permissions.contains((Object)Permission.MOVE));
        this.email = this.booleanToInt(permissions.contains((Object)Permission.EMAIL));
        this.automation = this.booleanToInt(permissions.contains((Object)Permission.AUTOMATION));
        this.readingreq = this.booleanToInt(permissions.contains((Object)Permission.READINGREQ));
        this.customid = this.booleanToInt(permissions.contains((Object)Permission.CUSTOMID));
        this.revision = this.booleanToInt(permissions.contains((Object)Permission.REVISION));
    }

    public int getPreview() {
        return this.preview;
    }

    public void setPreview(int preview) {
        this.preview = preview;
    }

    public int getDownload() {
        return this.download;
    }

    public void setDownload(int download) {
        this.download = download;
    }

    public int getSecurity() {
        return this.security;
    }

    public void setSecurity(int security) {
        this.security = security;
    }

    public int getDelete() {
        return this.delete;
    }

    public void setDelete(int delete) {
        this.delete = delete;
    }

    public int getRename() {
        return this.rename;
    }

    public void setRename(int rename) {
        this.rename = rename;
    }

    public int getImmutable() {
        return this.immutable;
    }

    public void setImmutable(int immutable) {
        this.immutable = immutable;
    }

    public int getSign() {
        return this.sign;
    }

    public void setSign(int sign) {
        this.sign = sign;
    }

    public int getArchive() {
        return this.archive;
    }

    public void setArchive(int archive) {
        this.archive = archive;
    }

    public int getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(int workflow) {
        this.workflow = workflow;
    }

    public int getCalendar() {
        return this.calendar;
    }

    public void setCalendar(int calendar) {
        this.calendar = calendar;
    }

    public int getSubscription() {
        return this.subscription;
    }

    public void setSubscription(int subscription) {
        this.subscription = subscription;
    }

    public int getPassword() {
        return this.password;
    }

    public void setPassword(int password) {
        this.password = password;
    }

    public int getPrint() {
        return this.print;
    }

    public void setPrint(int print) {
        this.print = print;
    }

    public int getMove() {
        return this.move;
    }

    public void setMove(int move) {
        this.move = move;
    }

    public int getEmail() {
        return this.email;
    }

    public void setEmail(int email) {
        this.email = email;
    }

    public int getAutomation() {
        return this.automation;
    }

    public void setAutomation(int automation) {
        this.automation = automation;
    }

    public int getReadingreq() {
        return this.readingreq;
    }

    public void setReadingreq(int readingreq) {
        this.readingreq = readingreq;
    }

    public int getCustomid() {
        return this.customid;
    }

    public void setCustomid(int customid) {
        this.customid = customid;
    }

    @Override
    public long getGroupId() {
        return this.ace.getGroupId();
    }

    @Override
    public int getWrite() {
        return this.ace.getWrite();
    }

    @Override
    public void setGroupId(long groupId) {
        this.ace.setGroupId(groupId);
    }

    @Override
    public void setWrite(int write) {
        this.ace.setWrite(write);
    }

    @Override
    public int getRead() {
        return this.ace.getRead();
    }

    @Override
    public void setRead(int read) {
        this.ace.setRead(read);
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public Set<Permission> grantedPermissions() {
        Set<Permission> granted = this.ace.grantedPermissions();
        if (this.preview == 1) {
            granted.add(Permission.PREVIEW);
        }
        if (this.download == 1) {
            granted.add(Permission.DOWNLOAD);
        }
        if (this.security == 1) {
            granted.add(Permission.SECURITY);
        }
        if (this.delete == 1) {
            granted.add(Permission.DELETE);
        }
        if (this.rename == 1) {
            granted.add(Permission.RENAME);
        }
        if (this.immutable == 1) {
            granted.add(Permission.IMMUTABLE);
        }
        if (this.sign == 1) {
            granted.add(Permission.SIGN);
        }
        if (this.archive == 1) {
            granted.add(Permission.ARCHIVE);
        }
        if (this.workflow == 1) {
            granted.add(Permission.WORKFLOW);
        }
        this.grantedMorePermissions(granted);
        return granted;
    }

    private void grantedMorePermissions(Set<Permission> granted) {
        if (this.calendar == 1) {
            granted.add(Permission.CALENDAR);
        }
        if (this.subscription == 1) {
            granted.add(Permission.SUBSCRIPTION);
        }
        if (this.password == 1) {
            granted.add(Permission.PASSWORD);
        }
        if (this.print == 1) {
            granted.add(Permission.PRINT);
        }
        if (this.move == 1) {
            granted.add(Permission.MOVE);
        }
        if (this.email == 1) {
            granted.add(Permission.EMAIL);
        }
        if (this.automation == 1) {
            granted.add(Permission.AUTOMATION);
        }
        if (this.readingreq == 1) {
            granted.add(Permission.READINGREQ);
        }
        if (this.customid == 1) {
            granted.add(Permission.CUSTOMID);
        }
        if (this.revision == 1) {
            granted.add(Permission.REVISION);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ace == null ? 0 : this.ace.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendedAccessControlEntry other = (ExtendedAccessControlEntry)obj;
        return !(this.ace == null ? other.ace != null : !this.ace.equals(other.ace));
    }

    @Override
    public String toString() {
        return "ExtendedAccessControlEntry [ace=" + String.valueOf(this.ace) + ", preview=" + this.preview + ", download=" + this.download + ", security=" + this.security + ", delete=" + this.delete + ", rename=" + this.rename + ", immutable=" + this.immutable + ", sign=" + this.sign + ", archive=" + this.archive + ", workflow=" + this.workflow + ", calendar=" + this.calendar + ", subscription=" + this.subscription + ", password=" + this.password + ", print=" + this.print + ", move=" + this.move + ", email=" + this.email + ", automation=" + this.automation + ", readingreq=" + this.readingreq + ", customid=" + this.customid + ", revision=" + this.revision + "]";
    }
}

