/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.core.PersistentObject;
import eu.bitwalker.useragentutils.UserAgent;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="ld_device")
@Cacheable
public class Device
extends PersistentObject
implements Serializable {
    public static final String PARAM_DEVICE = "device";
    private static final long serialVersionUID = 1L;
    @Column(name="ld_deviceid", length=255, nullable=false)
    private String deviceId;
    @Column(name="ld_userid")
    private long userId;
    @Column(name="ld_username", length=255)
    private String username;
    @Column(name="ld_browser", length=255)
    private String browser = "unknown";
    @Column(name="ld_browserversion", length=255)
    private String browserVersion;
    @Column(name="ld_operativesystem", length=255)
    private String operativeSystem;
    @Column(name="ld_type", length=255)
    private String type;
    @Column(name="ld_lastlogin", columnDefinition="DATETIME(3)")
    private Date lastLogin;
    @Column(name="ld_trusted", nullable=false)
    private int trusted = 0;
    @Column(name="ld_ip", length=255)
    private String ip;
    @Column(name="ld_label", length=255)
    private String label;

    public Device() {
    }

    public Device(HttpServletRequest request) {
        this.setDeviceId(Device.getDeviceId(request));
        UserAgent agent = UserAgent.parseUserAgentString((String)request.getHeader("User-Agent"));
        this.setBrowser(agent.getBrowser().getName());
        if (agent.getBrowserVersion() != null) {
            this.setBrowserVersion(agent.getBrowserVersion().getVersion());
        }
        if (agent.getOperatingSystem() != null) {
            this.setOperativeSystem(agent.getOperatingSystem().getName());
            if (agent.getOperatingSystem().getDeviceType() != null) {
                this.setType(agent.getOperatingSystem().getDeviceType().toString());
            }
        }
        this.setIp(request.getRemoteAddr());
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public String getOperativeSystem() {
        return this.operativeSystem;
    }

    public void setOperativeSystem(String operativeSystem) {
        this.operativeSystem = operativeSystem;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public int getTrusted() {
        return this.trusted;
    }

    public void setTrusted(int trusted) {
        this.trusted = trusted;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBrowser());
        if (StringUtils.isNotEmpty((CharSequence)this.getBrowserVersion())) {
            sb.append(" v");
            sb.append(this.getBrowserVersion());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getOperativeSystem())) {
            sb.append(" on ");
            sb.append(this.getOperativeSystem());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getType())) {
            sb.append(" (");
            sb.append(this.getType());
            sb.append(")");
        }
        return sb.toString();
    }

    private static String getDeviceId(HttpServletRequest request) {
        if (request.getParameter(PARAM_DEVICE) != null) {
            return request.getParameter(PARAM_DEVICE);
        }
        if (request.getAttribute(PARAM_DEVICE) != null) {
            return request.getAttribute(PARAM_DEVICE).toString();
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if ("ldoc-device".contentEquals(cookie.getName())) {
                    return cookie.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.deviceId == null ? 0 : this.deviceId.hashCode());
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device other = (Device)obj;
        if (this.deviceId == null ? other.deviceId != null : !this.deviceId.equals(other.deviceId)) {
            return false;
        }
        return this.userId == other.userId;
    }
}

