/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.core.security.Device;
import com.logicaldoc.core.security.Geolocation;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Transient;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Embeddable
public class Client
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    @Column(name="ld_clientid", length=255)
    private String id;
    @Transient
    private String username;
    @Column(name="ld_clientaddr", length=255)
    private String address;
    @Column(name="ld_clienthost", length=255)
    private String host;
    @Transient
    private Device device;
    @Transient
    private transient Geolocation geolocation;

    public Client() {
    }

    public Client(HttpServletRequest req) {
        this(null, req.getRemoteAddr(), req.getRemoteHost());
        this.device = new Device(req);
    }

    public Client(String id, String address, String host) {
        this.id = id;
        this.address = address;
        this.host = host;
        try {
            this.geolocation = Geolocation.get(address);
        }
        catch (IOException e) {
            log.debug("Geolocalization: {} {}", (Object)e.getMessage(), (Object)address);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Client other = (Client)obj;
        if (this.id == null && other.id != null || this.id != null && other.id == null) {
            return false;
        }
        return this.id != null && this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        if (this.id == null) {
            return String.format("%s - %s", this.host, this.address);
        }
        return String.format("%s - %s - %s", this.id, this.host, this.address);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public Geolocation getGeolocation() {
        return this.geolocation;
    }

    public void setGeolocation(Geolocation geolocation) {
        this.geolocation = geolocation;
    }
}

