/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.security;

import com.logicaldoc.core.security.Permission;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Embeddable
public class AccessControlEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_read", nullable=false)
    protected int read = 1;
    @Column(name="ld_write", nullable=false)
    protected int write = 0;
    @Column(name="ld_groupid", nullable=false)
    protected long groupId;

    public AccessControlEntry() {
    }

    public AccessControlEntry(AccessControlEntry source) {
        this.groupId = source.groupId;
        this.read = source.read;
        this.write = source.write;
    }

    public AccessControlEntry(long groupId) {
        this.groupId = groupId;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public int getWrite() {
        return this.write;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public void setWrite(int write) {
        this.write = write;
    }

    public int getRead() {
        return this.read;
    }

    public void setRead(int read) {
        this.read = read;
    }

    public Set<Permission> grantedPermissions() {
        HashSet<Permission> granted = new HashSet<Permission>();
        if (this.read == 1) {
            granted.add(Permission.READ);
        }
        if (this.write == 1) {
            granted.add(Permission.WRITE);
        }
        return granted;
    }

    public void grantPermissions(Set<Permission> permissions) {
        this.read = this.booleanToInt(permissions.contains((Object)Permission.READ));
        this.write = this.booleanToInt(permissions.contains((Object)Permission.WRITE));
    }

    protected int booleanToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccessControlEntry) {
            AccessControlEntry ace = (AccessControlEntry)obj;
            return this.getGroupId() == ace.getGroupId();
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.groupId).hashCode();
    }

    public String toString() {
        return "AccessControlEntry [read=" + this.read + ", write=" + this.write + ", groupId=" + this.groupId + "]";
    }
}

