/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine.saved;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.searchengine.SearchOptions;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.util.io.IOUtil;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="ld_search")
@Cacheable
public class SavedSearch
extends PersistentObject
implements Serializable,
Comparable<SavedSearch> {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_userid", nullable=false)
    private long userId;
    @Column(name="ld_date", columnDefinition="DATETIME(3)")
    private Date date = new Date();
    @Column(name="ld_options")
    private String options = "";
    @Column(name="ld_name")
    private String name = "";
    @Column(name="ld_type", nullable=false)
    private int type = 0;
    @Column(name="ld_description")
    private String description = "";

    public SavedSearch() {
    }

    public SavedSearch(SavedSearch source) {
        this.userId = source.userId;
        this.name = source.name;
        this.description = source.description;
        this.type = source.type;
        this.date = source.date;
        this.options = source.options;
    }

    public void saveOptions(SearchOptions opt) throws PersistenceException {
        this.setType(opt.getType());
        TenantDAO tenantDao = Context.get(TenantDAO.class);
        String tenantName = tenantDao.getTenantName(this.getTenantId());
        String charset = Context.get().getProperties().getProperty(tenantName + ".charset", "UTF-8");
        this.setOptions(IOUtil.serialize(opt, charset));
    }

    public SearchOptions readOptions() {
        SearchOptions searchOptions = (SearchOptions)IOUtil.deserialize(this.getOptions());
        searchOptions.setName(this.getName());
        searchOptions.setDescription(this.getDescription());
        return searchOptions;
    }

    @Override
    public int compareTo(SavedSearch other) {
        return this.getOptions().compareTo(other.getOptions());
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SavedSearch other = (SavedSearch)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.userId == other.userId;
    }
}

