/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine.saved;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.searchengine.saved.SavedSearch;
import com.logicaldoc.core.searchengine.saved.SearchDAO;
import jakarta.transaction.Transactional;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="searchDAO")
@Transactional
public class HibernateSearchDAO
extends HibernatePersistentObjectDAO<SavedSearch>
implements SearchDAO {
    private static final String USERID = "userId";

    private HibernateSearchDAO() {
        super(SavedSearch.class);
        this.log = LoggerFactory.getLogger(HibernateSearchDAO.class);
    }

    @Override
    public List<SavedSearch> findByUserId(long userId) throws PersistenceException {
        return this.findByWhere("_entity.userId = :userId", Map.of(USERID, userId), "_entity.name asc", null);
    }

    @Override
    public SavedSearch findByUserIdAndName(long userId, String name) throws PersistenceException {
        List searches = this.findByWhere("_entity.userId = :userId and _entity.name = :name", Map.of(USERID, userId, "name", name), null, null);
        if (searches.isEmpty()) {
            return null;
        }
        return (SavedSearch)searches.get(0);
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        SavedSearch search = (SavedSearch)this.findById(id);
        if (search != null) {
            search.setDeleted(code);
            search.setName(search.getName() + "." + search.getId());
            this.saveOrUpdate(search);
        }
    }

    @Override
    public void store(SavedSearch search) throws PersistenceException {
        this.setUniqueName(search);
        super.store(search);
    }

    private void setUniqueName(SavedSearch search) throws PersistenceException {
        String baseName = search.getName();
        HashSet names = new HashSet();
        this.queryForResultSet("select lower(ld_name) from ld_search where ld_deleted=0 and ld_userid = :userId and lower(ld_name) like :baseName and not ld_id = :id", Map.of(USERID, search.getUserId(), "baseName", baseName.toLowerCase() + "%", "id", search.getId()), null, rs -> {
            while (rs.next()) {
                String file = rs.getString(1);
                if (names.contains(file)) continue;
                names.add(file);
            }
        });
        int counter = 1;
        while (names.contains(search.getName().toLowerCase())) {
            search.setName(baseName + "(" + counter++ + ")");
        }
    }
}

