/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine.indexer;

import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.searchengine.SearchEngine;
import com.logicaldoc.core.searchengine.indexer.Indexer;
import com.logicaldoc.core.searchengine.indexer.IndexerStats;
import com.logicaldoc.core.task.AbstractDocumentProcessor;
import com.logicaldoc.core.task.DocumentProcessorCallable;
import com.logicaldoc.core.task.DocumentProcessorStats;
import com.logicaldoc.core.task.TaskException;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.TimeDiff;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="indexerTask")
public class IndexerTask
extends AbstractDocumentProcessor {
    public static final String NAME = "IndexerTask";
    @Resource(name="SearchEngine")
    protected SearchEngine searchEngine;
    private long totalIndexedDocuments = 0L;
    private long totalErrors = 0L;
    private long totalIndexingTime = 0L;
    private long totalParsingTime = 0L;
    private List<Indexer> threads = new ArrayList<Indexer>();

    public IndexerTask() {
        super(NAME);
        this.log = LoggerFactory.getLogger(IndexerTask.class);
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }

    @Override
    public synchronized void interrupt() {
        super.interrupt();
        for (Indexer thread : this.threads) {
            thread.interrupt();
        }
    }

    void onDocumentProcessed() {
        this.next();
    }

    @Override
    public void runTask() throws TaskException {
        if (this.searchEngine.isLocked()) {
            this.log.warn("Index locked, skipping indexing");
            return;
        }
        this.log.info("Start indexing of all documents");
        this.totalErrors = 0L;
        this.totalIndexedDocuments = 0L;
        this.totalIndexingTime = 0L;
        this.totalParsingTime = 0L;
        try {
            super.runTask();
        }
        finally {
            if (this.log.isInfoEnabled()) {
                this.log.info("Indexing finished");
                this.log.info("Indexing time: {}", (Object)TimeDiff.printDuration(this.totalIndexingTime));
                this.log.info("Parsing time: {}", (Object)TimeDiff.printDuration(this.totalParsingTime));
                this.log.info("Indexed documents: {}", (Object)this.totalIndexedDocuments);
                this.log.info("Errors: {}", (Object)this.totalErrors);
            }
            this.searchEngine.unlock();
        }
    }

    @Override
    protected void allCompleted(List<DocumentProcessorStats> stats) {
        for (DocumentProcessorStats stat : stats) {
            IndexerStats iStat = (IndexerStats)stat;
            this.totalIndexedDocuments += iStat.getProcessed();
            this.totalErrors += iStat.getErrors();
            this.totalIndexingTime += iStat.getIndexingTime();
            this.totalParsingTime += iStat.getParsingTime();
        }
    }

    public static String[] prepareQuery() {
        String sortingCustom;
        ContextProperties config = Context.get().getProperties();
        String sorting = config.getProperty("index.sorting");
        if (StringUtils.isNotEmpty(sorting)) {
            sorting = "oldestfirst".equals(sorting) ? "_entity.date asc" : ("mostrecentfirst".equals(sorting) ? "_entity.date desc" : ("smallestfirst".equals(sorting) ? "_entity.fileSize asc" : "_entity.fileSize desc"));
        }
        if (StringUtils.isNotEmpty(sortingCustom = config.getProperty("index.sorting.custom"))) {
            sorting = sortingCustom;
        }
        String where = "_entity.deleted = 0 and (_entity.indexingStatus = " + IndexingStatus.TO_INDEX.ordinal() + " or _entity.indexingStatus = " + IndexingStatus.TO_INDEX_METADATA.ordinal() + ") and not _entity.status = " + DocumentStatus.ARCHIVED.ordinal();
        return new String[]{where, sorting};
    }

    @Override
    public String prepareReport(Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append(I18N.message("indexationtime", locale) + ": ");
        sb.append(TimeDiff.printDuration(this.totalIndexingTime));
        sb.append("\n");
        sb.append(I18N.message("indexeddocs", locale) + ": ");
        sb.append(this.totalIndexedDocuments);
        sb.append("\n");
        sb.append(I18N.message("errors", locale) + ": ");
        sb.append(this.totalErrors);
        return sb.toString();
    }

    @Override
    protected String getDefaultUser() {
        return "_system";
    }

    @Override
    protected int getBatchSize() {
        return this.config.getInt("index.batch", 500);
    }

    @Override
    protected void prepareQueueQuery(StringBuilder where, StringBuilder sort) {
        String[] queryParts = IndexerTask.prepareQuery();
        where.append(queryParts[0]);
        sort.append(queryParts[1]);
    }

    protected DocumentProcessorCallable<IndexerStats> prepareCallable(List<Long> segment) {
        return new Indexer(segment, this, this.log);
    }
}

