/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine.indexer;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.searchengine.indexer.IndexerStats;
import com.logicaldoc.core.searchengine.indexer.IndexerTask;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.task.DocumentProcessorCallable;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.TimeDiff;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;

class Indexer
extends DocumentProcessorCallable<IndexerStats> {
    private ContextProperties config = Context.get().getProperties();
    private DocumentDAO documentDao = Context.get(DocumentDAO.class);
    private TenantDAO tenantDao = Context.get(TenantDAO.class);
    private DocumentManager documentManager = Context.get(DocumentManager.class);

    Indexer(List<Long> docIds, IndexerTask task, Logger log) {
        super(docIds, task, log);
    }

    private void increaseParsingTime(long increase) {
        ((IndexerStats)this.stats).setParsingTime(((IndexerStats)this.stats).getParsingTime() + increase);
    }

    private void increaseIndexingTime(long increase) {
        ((IndexerStats)this.stats).setIndexingTime(((IndexerStats)this.stats).getIndexingTime() + increase);
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    public IndexerStats getStats() {
        return (IndexerStats)this.stats;
    }

    @Override
    protected void processDocument(Document document, User user) throws PersistenceException, IOException {
        try {
            Tenant tenant = (Tenant)this.tenantDao.findById(document.getTenantId());
            if (!FileUtil.matches(document.getFileName(), this.config.getProperty(tenant.getName() + ".index.includes") == null ? "" : this.config.getProperty(tenant.getName() + ".index.includes"), this.config.getProperty(tenant.getName() + ".index.excludes") == null ? "" : this.config.getProperty(tenant.getName() + ".index.excludes"))) {
                this.documentDao.initialize(document);
                document.setIndexingStatus(IndexingStatus.SKIP);
                this.documentDao.store(document);
                this.log.warn("Document {} with filename '{}' marked as unindexable", (Object)document.getId(), (Object)document.getFileName());
            } else {
                Date beforeIndexing = new Date();
                DocumentHistory transaction = new DocumentHistory();
                transaction.setUser(user);
                this.increaseParsingTime(this.documentManager.index(document.getId(), null, transaction));
                long indexingDiff = TimeDiff.getTimeDifference(beforeIndexing, new Date(), TimeDiff.TimeField.MILLISECOND);
                this.increaseIndexingTime(indexingDiff);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Indexed document {} in {}ms", (Object)document, (Object)indexingDiff);
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Problem indexing document " + String.valueOf(document), e);
        }
    }

    @Override
    protected IndexerStats prepareStats() {
        return new IndexerStats();
    }
}

