/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine.folder;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.searchengine.Hit;
import com.logicaldoc.core.searchengine.Search;
import com.logicaldoc.core.searchengine.SearchException;
import com.logicaldoc.core.searchengine.folder.FolderCriterion;
import com.logicaldoc.core.searchengine.folder.FolderSearchOptions;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.sql.SqlUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class FolderSearch
extends Search {
    private static final String EQUAL_PARAMETER = " = ?)";
    private static final String NOT = "(not ";
    private static final String LIKE = " like '%";
    private static final String IS_NOT_NULL = " is not null ";
    private static final String IS_NULL = " is null ";
    private static final String LOWER = "lower(";
    private static final String AND = " and ";
    private String query;

    @Override
    public void internalSearch() throws SearchException {
        Collection<Long> accessibleFolderIds;
        List<Hit> folders;
        User user;
        UserDAO userDAO = Context.get(UserDAO.class);
        try {
            user = (User)userDAO.findById(this.options.getUserId());
            userDAO.initialize(user);
        }
        catch (PersistenceException e1) {
            throw new SearchException(e1);
        }
        Map<String, Object> params = null;
        try {
            params = this.prepareQuery();
        }
        catch (PersistenceException e1) {
            throw new SearchException(e1);
        }
        this.options.setParameters(params);
        FolderDAO dao = Context.get(FolderDAO.class);
        try {
            folders = dao.query(this.query, params, new HitMapper(), null);
        }
        catch (PersistenceException e) {
            throw new SearchException(e);
        }
        this.estimatedHitsNumber = folders.size();
        try {
            accessibleFolderIds = this.findAccessibleFolderIds(user);
        }
        catch (PersistenceException e) {
            throw new SearchException(e.getMessage(), e);
        }
        for (Hit folder : folders) {
            if (accessibleFolderIds.contains(folder.getId()) || user.isMemberOf("admin")) {
                this.hits.add(folder);
            }
            if (this.hits.size() >= this.options.getMaxHits()) break;
        }
        if (this.hits.size() < this.options.getMaxHits()) {
            this.estimatedHitsNumber = this.hits.size();
        }
    }

    private Map<String, Object> prepareQuery() throws PersistenceException {
        if (StringUtils.isNotEmpty(this.query)) {
            return this.options.getParameters();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        if (this.options.isRetrieveAliases()) {
            sb.append("(");
        }
        sb.append("select A.ld_id, A.ld_parentid, A.ld_name, A.ld_description, A.ld_creation, A.ld_lastmodified, A.ld_type, A.ld_foldref, C.ld_name, A.ld_templateid, A.ld_tgs, A.ld_color ");
        sb.append(" from ld_folder A ");
        sb.append(" left outer join ld_template C on A.ld_templateid=C.ld_id ");
        this.appendWhereClause(false, params, sb);
        if (this.options.isRetrieveAliases()) {
            sb.append(") UNION (select A.ld_id, A.ld_parentid, A.ld_name, A.ld_description, A.ld_creation, A.ld_lastmodified, A.ld_type, A.ld_foldref, C.ld_name, REF.ld_templateid, REF.ld_tgs, A.ld_color ");
            sb.append(" from ld_folder A ");
            sb.append(" join ld_folder REF on A.ld_foldref=REF.ld_id ");
            sb.append(" left outer join ld_template C on REF.ld_templateid=C.ld_id ");
            this.appendWhereClause(true, params, sb);
            sb.append(")");
        }
        log.info("executing query {} with parameters {}", (Object)sb, (Object)params);
        this.query = sb.toString();
        return params;
    }

    private void appendWhereClause(boolean searchAliases, Map<String, Object> params, StringBuilder query) throws PersistenceException {
        FolderSearchOptions fOptions = (FolderSearchOptions)this.options;
        this.prepareExtendedAttributesJoins(query);
        query.append(" where A.ld_deleted=0 and A.ld_hidden=0 ");
        query.append(AND + (searchAliases ? "" : "not") + " A.ld_type=2");
        this.appendTenantCondition(query);
        String tableAlias = this.getTableAlias(searchAliases);
        this.appendTemplateCondition(query, tableAlias);
        this.appendMainFolderCondition(query, tableAlias, fOptions);
        this.appendComposition(fOptions);
        this.appendFoldRefConfition(query, searchAliases);
        String criteriaQueryPart = this.prepareCriteriaConditions(tableAlias, fOptions, params);
        if (StringUtils.isNotEmpty(criteriaQueryPart)) {
            query.append(" and ( ");
            if ("not".equals(fOptions.getTopOperator())) {
                query.append("not");
            }
            query.append(criteriaQueryPart);
            query.append(")");
        }
        this.appendSorting(query, fOptions);
    }

    private String prepareCriteriaConditions(String tableAlias, FolderSearchOptions fOptions, Map<String, Object> params) throws PersistenceException {
        StringBuilder criteriaQueryPart = new StringBuilder();
        int joinsCounter = 0;
        for (FolderCriterion criterion : fOptions.getNotEmptyCriteria()) {
            if (criteriaQueryPart.length() > 0) {
                criteriaQueryPart.append(" " + criterion.getComposition());
            }
            criteriaQueryPart.append("(");
            Object columnName = "";
            if (criterion.isExtendedAttribute()) {
                if (!"or".equals(fOptions.getTopOperator()) || joinsCounter == 0) {
                    ++joinsCounter;
                }
                criteriaQueryPart.append("(C" + joinsCounter + ".ld_folderid=" + tableAlias + ".ld_id");
                criteriaQueryPart.append(" and (C" + joinsCounter + ".ld_name='");
                criteriaQueryPart.append(criterion.getFieldName());
                criteriaQueryPart.append("' or C" + joinsCounter + ".ld_name like '");
                criteriaQueryPart.append(criterion.getFieldName());
                criteriaQueryPart.append("-%') and ");
                columnName = "C" + joinsCounter + ".";
                switch (criterion.getType()) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        columnName = (String)columnName + "ld_intvalue";
                        break;
                    }
                    case 2: {
                        columnName = (String)columnName + "ld_doublevalue";
                        break;
                    }
                    case 3: {
                        columnName = (String)columnName + "ld_datevalue";
                        break;
                    }
                    default: {
                        columnName = (String)columnName + "ld_stringvalue";
                        break;
                    }
                }
            } else {
                columnName = this.getCriterionColumnName(tableAlias, criterion);
            }
            this.appendAttributeCriterionColumnCondition(criteriaQueryPart, tableAlias, (String)columnName, criterion, params);
            if (criterion.isExtendedAttribute()) {
                criteriaQueryPart.append(")");
            }
            criteriaQueryPart.append(")");
        }
        return criteriaQueryPart.toString();
    }

    private String getCriterionColumnName(String tableAlias, FolderCriterion criterion) {
        Object columnName = criterion.getColumnName();
        if (!((String)columnName).contains(".")) {
            columnName = tableAlias + "." + (String)columnName;
        }
        return columnName;
    }

    private String getTableAlias(boolean searchAliases) {
        String tableAlias = "A";
        if (searchAliases) {
            tableAlias = "REF";
        }
        return tableAlias;
    }

    private void appendSorting(StringBuilder query, FolderSearchOptions fOptions) {
        if (fOptions.getOrder() != null && !fOptions.getOrder().isEmpty()) {
            query.append(" order by ");
            int i = 0;
            for (String poption : fOptions.getOrder()) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append("A.ld_" + poption);
                ++i;
            }
        }
    }

    private void appendTemplateCondition(StringBuilder query, String tableAlias) {
        if (this.options.getTemplate() != null) {
            query.append(AND + tableAlias + ".ld_templateid=" + String.valueOf(this.options.getTemplate()));
        }
    }

    private void appendFoldRefConfition(StringBuilder query, boolean searchAliases) {
        if (searchAliases) {
            query.append(" and A.ld_foldref is not null and REF.ld_deleted=0 and A.ld_foldref = REF.ld_id ");
        } else {
            query.append(" and A.ld_foldref is null ");
        }
    }

    private void appendMainFolderCondition(StringBuilder query, String tableAlias, FolderSearchOptions fOptions) throws PersistenceException {
        FolderDAO dao = Context.get(FolderDAO.class);
        if (fOptions.getFolderId() != null) {
            query.append(AND);
            if (fOptions.isSearchInSubPath()) {
                String path = dao.computePath(fOptions.getFolderId());
                query.append(tableAlias + ".ld_path like '" + path + "/%'");
            } else {
                query.append(tableAlias + ".ld_parentid = " + String.valueOf(fOptions.getFolderId()));
            }
        }
    }

    private void appendAttributeCriterionColumnCondition(StringBuilder query, String tableAlias, String columnName, FolderCriterion criterion, Map<String, Object> params) throws PersistenceException {
        switch (criterion.getType()) {
            case 1: {
                this.appendIntegerCriterion(query, columnName, criterion, params);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 102: {
                this.appendFolderOrDocumentOrUserOrTemplateCriterion(query, columnName, criterion, params);
                break;
            }
            case 5: {
                this.appendBooleanCriterion(query, columnName, criterion, params);
                break;
            }
            case 2: {
                this.appendDoubleCriterion(query, columnName, criterion, params);
                break;
            }
            case 3: {
                this.appendDateCriterion(query, columnName, criterion, params);
                break;
            }
            case 100: {
                this.appendLanguageCriterion(query, columnName, criterion);
                break;
            }
            case 101: {
                this.appendFolderCriterion(query, tableAlias, columnName, criterion);
                break;
            }
            default: {
                if (this.options.isCaseSensitive()) {
                    this.appendStringCriterionCaseSensitive(query, columnName, criterion);
                    break;
                }
                this.appendStringCriterionCaseInsensitive(query, columnName, criterion);
            }
        }
    }

    private void appendStringCriterionCaseInsensitive(StringBuilder query, String columnName, FolderCriterion criterion) {
        String val = SqlUtil.doubleQuotes(criterion.getStringValue().toLowerCase());
        if ("equals".equals(criterion.getOperator())) {
            query.append(LOWER + columnName + ") = '" + val + "'");
        } else if ("notequal".equals(criterion.getOperator())) {
            query.append("(not lower(" + columnName + ") = '" + val + "')");
        } else if ("contains".equals(criterion.getOperator())) {
            query.append(LOWER + columnName + ") like '%" + val + "%'");
        } else if ("notcontains".equals(criterion.getOperator())) {
            query.append(" (" + columnName + " is null or not (lower(" + columnName + ") like '%" + val + "%')");
        } else if ("beginswith".equals(criterion.getOperator())) {
            query.append(LOWER + columnName + ") like '" + val + "%'");
        } else if ("endswith".equals(criterion.getOperator())) {
            query.append(LOWER + columnName + ") like  '%" + val + "'");
        } else if ("null".equals(criterion.getOperator())) {
            query.append(columnName + IS_NULL);
        } else if ("notnull".equals(criterion.getOperator())) {
            query.append(columnName + IS_NOT_NULL);
        }
    }

    private void appendStringCriterionCaseSensitive(StringBuilder query, String columnName, FolderCriterion criterion) {
        String val = SqlUtil.doubleQuotes(criterion.getStringValue());
        if ("equals".equals(criterion.getOperator())) {
            query.append(columnName + " = '" + val + "'");
        } else if ("notequal".equals(criterion.getOperator())) {
            query.append(" (not " + columnName + " = '" + val + "')");
        } else if ("contains".equals(criterion.getOperator())) {
            query.append(columnName + LIKE + val + "%'");
        } else if ("notcontains".equals(criterion.getOperator())) {
            query.append(" (" + columnName + " is null or not (" + columnName + LIKE + val + "%'))");
        } else if ("beginswith".equals(criterion.getOperator())) {
            query.append(columnName + " like '" + val + "%'");
        } else if ("endswith".equals(criterion.getOperator())) {
            query.append(columnName + LIKE + val + "'");
        } else if ("null".equals(criterion.getOperator())) {
            query.append(columnName + IS_NULL);
        } else if ("notnull".equals(criterion.getOperator())) {
            query.append(columnName + IS_NOT_NULL);
        }
    }

    private void appendFolderCriterion(StringBuilder query, String tableAlias, String columnName, FolderCriterion criterion) throws PersistenceException {
        if ("inorsubfolders".equals(criterion.getOperator())) {
            FolderDAO dao = Context.get(FolderDAO.class);
            String path = dao.computePath(criterion.getLongValue());
            query.append(tableAlias + ".ld_path like '" + path + "/%'");
        } else {
            query.append(columnName + " = " + String.valueOf(criterion.getLongValue()));
        }
    }

    private void appendLanguageCriterion(StringBuilder query, String columnName, FolderCriterion criterion) {
        if ("null".equals(criterion.getOperator())) {
            query.append(columnName + IS_NULL);
        } else if ("notnull".equals(criterion.getOperator())) {
            query.append(columnName + IS_NOT_NULL);
        } else {
            String val2 = criterion.getStringValue();
            if ("equals".equals(criterion.getOperator())) {
                query.append(columnName + " = '" + val2 + "'");
            } else if ("notequal".equals(criterion.getOperator())) {
                query.append(NOT + columnName + " = '" + val2 + "')");
            }
        }
    }

    private void appendDateCriterion(StringBuilder query, String columnName, FolderCriterion criterion, Map<String, Object> params) {
        if ("null".equals(criterion.getOperator())) {
            query.append(columnName + IS_NULL);
        } else if ("notnull".equals(criterion.getOperator())) {
            query.append(columnName + IS_NOT_NULL);
        } else {
            String paramName = this.addParameter(params, criterion.getSqlDateValue());
            if ("greaterthan".equals(criterion.getOperator())) {
                query.append(columnName + " > :" + paramName);
            } else if ("lessthan".equals(criterion.getOperator())) {
                query.append(columnName + " < :" + paramName);
            }
        }
    }

    private String addParameter(Map<String, Object> params, Object value) {
        String paramName = "param" + params.size();
        params.put(paramName, value);
        return paramName;
    }

    private void appendDoubleCriterion(StringBuilder query, String columnName, FolderCriterion criterion, Map<String, Object> params) {
        if ("null".equals(criterion.getOperator())) {
            query.append(columnName + IS_NULL);
        } else if ("notnull".equals(criterion.getOperator())) {
            query.append(columnName + IS_NOT_NULL);
        } else {
            String paramName = this.addParameter(params, criterion.getDoubleValue());
            if ("equals".equals(criterion.getOperator())) {
                query.append(columnName + " = :" + paramName);
            } else if ("notequal".equals(criterion.getOperator())) {
                query.append(NOT + columnName + EQUAL_PARAMETER);
            } else if ("greaterthan".equals(criterion.getOperator())) {
                query.append(columnName + " > :" + paramName);
            } else if ("lessthan".equals(criterion.getOperator())) {
                query.append(columnName + " < :" + paramName);
            }
        }
    }

    private void appendBooleanCriterion(StringBuilder query, String columnName, FolderCriterion criterion, Map<String, Object> params) {
        if ("equals".equals(criterion.getOperator())) {
            String paramName = this.addParameter(params, criterion.getLongValue());
            query.append(columnName + " = :" + paramName);
        } else if ("null".equals(criterion.getOperator())) {
            query.append(columnName + IS_NULL);
        } else if ("notnull".equals(criterion.getOperator())) {
            query.append(columnName + IS_NOT_NULL);
        }
    }

    private void appendFolderOrDocumentOrUserOrTemplateCriterion(StringBuilder query, String columnName, FolderCriterion criterion, Map<String, Object> params) {
        if ("null".equals(criterion.getOperator())) {
            query.append(columnName + IS_NULL);
        } else if ("notnull".equals(criterion.getOperator())) {
            query.append(columnName + IS_NOT_NULL);
        } else if ("equals".equals(criterion.getOperator())) {
            String paramName = this.addParameter(params, criterion.getLongValue());
            query.append(columnName + " = :" + paramName);
        } else if ("notequal".equals(criterion.getOperator())) {
            query.append(NOT + columnName + EQUAL_PARAMETER);
        }
    }

    private void appendIntegerCriterion(StringBuilder query, String columnName, FolderCriterion criterion, Map<String, Object> params) {
        if ("null".equals(criterion.getOperator())) {
            query.append(columnName + IS_NULL);
        } else if ("notnull".equals(criterion.getOperator())) {
            query.append(columnName + IS_NOT_NULL);
        } else {
            String paramName = this.addParameter(params, criterion.getLongValue());
            if ("equals".equals(criterion.getOperator())) {
                query.append(columnName + " = :" + paramName);
            } else if ("notequal".equals(criterion.getOperator())) {
                query.append(NOT + columnName + EQUAL_PARAMETER);
            } else if ("greaterthan".equals(criterion.getOperator())) {
                query.append(columnName + " > :" + paramName);
            } else if ("lessthan".equals(criterion.getOperator())) {
                query.append(columnName + " < :" + paramName);
            }
        }
    }

    private void appendComposition(FolderSearchOptions fOptions) {
        String composition = null;
        composition = "not".equals(this.options.getTopOperator()) ? "and not" : this.options.getTopOperator();
        if (composition != null && fOptions.getCriteria() != null) {
            for (FolderCriterion criterion : fOptions.getCriteria()) {
                criterion.setComposition(composition);
            }
        }
    }

    private void appendTenantCondition(StringBuilder query) {
        long tenantId = 1L;
        if (this.options.getTenantId() != null) {
            tenantId = this.options.getTenantId();
        } else if (this.searchUser != null) {
            tenantId = this.searchUser.getTenantId();
        }
        query.append(" and A.ld_tenantid=" + tenantId);
    }

    private void prepareExtendedAttributesJoins(StringBuilder query) {
        int counter = 0;
        if (((FolderSearchOptions)this.options).getCriteria() != null) {
            for (FolderCriterion criterion : ((FolderSearchOptions)this.options).getCriteria()) {
                if (!criterion.isExtendedAttribute() || criterion.isEmpty()) continue;
                query.append(", ld_folder_ext C" + ++counter);
                if ("or".equals(this.options.getTopOperator())) break;
            }
        }
    }

    private Collection<Long> findAccessibleFolderIds(User user) throws PersistenceException {
        Collection<Object> ids = new HashSet();
        if (((FolderSearchOptions)this.options).getCriteria() != null) {
            ids = this.retrieveAccessibleFolderIdsFromFolderCriterions(user);
        }
        if (ids.isEmpty() && !user.isMemberOf("admin")) {
            FolderDAO folderDAO = Context.get(FolderDAO.class);
            ids = folderDAO.findFolderIdByUserId(this.options.getUserId(), null, true);
        }
        return ids;
    }

    private Collection<Long> retrieveAccessibleFolderIdsFromFolderCriterions(User user) throws PersistenceException {
        FolderDAO folderDAO = Context.get(FolderDAO.class);
        HashSet<Long> ids = new HashSet<Long>();
        for (FolderCriterion criterion : ((FolderSearchOptions)this.options).getCriteria()) {
            if (criterion.getType() != 101 || criterion.isEmpty()) continue;
            if ("inorsubfolders".equals(criterion.getOperator())) {
                ids.addAll(folderDAO.findFolderIdByUserIdInPath(user.getId(), criterion.getLongValue()));
                continue;
            }
            if (!folderDAO.isReadAllowed(criterion.getLongValue(), user.getId())) continue;
            ids.add(criterion.getLongValue());
        }
        return ids;
    }

    public class HitMapper
    implements RowMapper<Hit> {
        public Hit mapRow(ResultSet rs, int rowNum) throws SQLException {
            Hit hit = new Hit();
            hit.setId(rs.getLong(1));
            Folder folder = new Folder();
            folder.setId(rs.getLong(2));
            folder.setName(rs.getString(3));
            folder.setType(rs.getInt(7));
            hit.setFolder(folder);
            hit.setFileName(rs.getString(3));
            if (rs.getLong(8) != 0L) {
                hit.setDocRef(rs.getLong(8));
                folder.setFoldRef(rs.getLong(8));
                hit.setType("folderalias");
            } else {
                hit.setType("folder");
            }
            hit.setCustomId(Long.toString(rs.getLong(1)));
            hit.setDate(rs.getTimestamp(6));
            hit.setCreation(rs.getTimestamp(5));
            hit.setComment(rs.getString(4));
            hit.setPublished(1);
            if (rs.getLong(10) != 0L) {
                hit.setTemplateId(rs.getLong(10));
                hit.setTemplateName(rs.getString(9));
                Template t = new Template();
                t.setId(rs.getLong(10));
                t.setName(rs.getString(9));
                hit.setTemplate(t);
            }
            hit.setTgs(rs.getString(11));
            if (hit.getTgs() != null) {
                StringTokenizer st = new StringTokenizer(hit.getTgs(), ",", false);
                while (st.hasMoreElements()) {
                    Object tag = st.nextElement();
                    if (tag == null || tag.toString().isEmpty()) continue;
                    hit.addTag(tag.toString());
                }
            }
            hit.setColor(rs.getString(12));
            return hit;
        }
    }
}

