/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine.folder;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class FolderCriterion
implements Serializable {
    private static final String FIELD_TAGS = "tags";
    private static final long serialVersionUID = 1L;
    private String field = "id";
    private String fieldName = "id";
    public static final String OPERATOR_EQUALS = "equals";
    public static final String OPERATOR_NOTEQUAL = "notequal";
    public static final String OPERATOR_CONTAINS = "contains";
    public static final String OPERATOR_NOTCONTAINS = "notcontains";
    public static final String OPERATOR_BEGINSWITH = "beginswith";
    public static final String OPERATOR_ENDSWITH = "endswith";
    public static final String OPERATOR_GREATER = "greaterthan";
    public static final String OPERATOR_LESSER = "lessthan";
    public static final String OPERATOR_NULL = "null";
    public static final String OPERATOR_NOTNULL = "notnull";
    public static final String OPERATOR_IN = "in";
    public static final String OPERATOR_INORSUBFOLDERS = "inorsubfolders";
    private String composition = "and";
    private String operator = "equals";
    public static final int TYPE_LANGUAGE = 100;
    public static final int TYPE_FOLDER = 101;
    public static final int TYPE_TEMPLATE = 102;
    private String stringValue;
    private Date dateValue;
    private Long longValue;
    private Double doubleValue;
    private int type = 1;
    private static Map<String, Integer> typeBinding = new HashMap<String, Integer>();
    private boolean showFolderSelector = false;
    private String parentPathDescr;
    private boolean extendedAttribute = false;

    static {
        typeBinding.put("creation", 3);
        typeBinding.put("lastModified", 3);
        typeBinding.put("id", 1);
        typeBinding.put("folder", 101);
        typeBinding.put("template", 102);
    }

    public void setField(String field) {
        this.field = field;
        if (field.contains(" type:")) {
            String name;
            this.fieldName = name = field.substring(0, field.lastIndexOf(" type:"));
            if (typeBinding.containsKey(name)) {
                this.field = this.fieldName;
                this.type = typeBinding.get(name);
            } else {
                this.type = Integer.parseInt(field.substring(field.lastIndexOf(":") + 1));
                this.extendedAttribute = true;
            }
        } else if (typeBinding.containsKey(field)) {
            this.type = typeBinding.get(field);
            this.fieldName = field;
        } else {
            this.type = 0;
            this.fieldName = field;
        }
    }

    public boolean isExtendedAttribute() {
        return this.extendedAttribute;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getColumnName() {
        if (this.getType() == 102) {
            return "ld_templateid";
        }
        if (this.getType() == 101) {
            return "ld_parentid";
        }
        if (this.getFieldName().equalsIgnoreCase(FIELD_TAGS)) {
            return "ld_tgs";
        }
        return "ld_" + this.getFieldName().toLowerCase();
    }

    public String getField() {
        return this.field;
    }

    public String getComposition() {
        return this.composition;
    }

    public void setComposition(String composition) {
        this.composition = composition;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public boolean isEmpty() {
        if (OPERATOR_NULL.equals(this.operator)) {
            return false;
        }
        switch (this.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 101: 
            case 102: {
                return this.getLongValue() == null;
            }
            case 2: {
                return this.getDoubleValue() == null;
            }
            case 3: {
                return this.getDateValue() == null;
            }
        }
        return StringUtils.isEmpty(this.getStringValue());
    }

    public void setValue(Serializable value) {
        if (value == null) {
            return;
        }
        block0 : switch (this.getType()) {
            case 0: {
                if (this.fieldName.equalsIgnoreCase(FIELD_TAGS)) {
                    this.setStringValue("," + (String)((Object)value) + ",");
                    break;
                }
                this.setStringValue((String)((Object)value));
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (value instanceof Integer) {
                    Integer integer = (Integer)value;
                    this.setLongValue(integer.longValue());
                    break;
                }
                this.setLongValue((Long)value);
                break;
            }
            case 2: {
                Serializable serializable = value;
                Objects.requireNonNull(serializable);
                Serializable serializable2 = serializable;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Long.class, Float.class}, (Object)serializable2, n)) {
                    case 0: {
                        Double doubleVal = (Double)serializable2;
                        this.setDoubleValue(doubleVal);
                        break block0;
                    }
                    case 1: {
                        Long longVal = (Long)serializable2;
                        this.setDoubleValue(longVal.doubleValue());
                        break block0;
                    }
                    case 2: {
                        Float floatVal = (Float)serializable2;
                        this.setDoubleValue(floatVal.doubleValue());
                        break block0;
                    }
                }
                this.setDoubleValue(null);
                break;
            }
            case 3: {
                this.setDateValue((Date)value);
                break;
            }
            case 101: {
                this.setLongValue((Long)value);
                break;
            }
            case 102: {
                this.setLongValue((Long)value);
                break;
            }
            case 100: {
                this.setStringValue((String)((Object)value));
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public Date getSqlDateValue() {
        if (this.dateValue != null) {
            return new java.sql.Date(this.dateValue.getTime());
        }
        return null;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    public boolean isShowFolderSelector() {
        return this.showFolderSelector;
    }

    public void setShowFolderSelector(boolean showFolderSelector) {
        this.showFolderSelector = showFolderSelector;
    }

    public String getParentPathDescr() {
        return this.parentPathDescr;
    }

    public void setParentPathDescr(String parentPathDescr) {
        this.parentPathDescr = parentPathDescr;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public void setExtendedAttribute(boolean extendedAttribute) {
        this.extendedAttribute = extendedAttribute;
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.NO_CLASS_NAME_STYLE){

            protected boolean accept(Field field) {
                try {
                    Object value = field.get(this.getObject());
                    return super.accept(field) && value != null && StringUtils.isNotEmpty(value.toString()) && !field.getName().equals("field");
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                    return false;
                }
            }
        }.toString();
    }
}

