/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine.analyzer;

import com.logicaldoc.core.i18n.Language;
import com.logicaldoc.core.i18n.LanguageManager;
import com.logicaldoc.util.LocaleUtil;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.tartarus.snowball.SnowballProgram;

public class SnowballFilterFactory
extends TokenFilterFactory {
    private Language language;

    public SnowballFilterFactory(Map<String, String> config) {
        super(config);
        String lang = config.get("lang");
        LanguageManager man = LanguageManager.getInstance();
        this.language = man.getLanguage(LocaleUtil.toLocale(lang));
        if (this.language == null) {
            this.language = new Language(Locale.ENGLISH);
        }
    }

    public TokenStream create(TokenStream ts) {
        SnowballProgram stemmer = this.language.getStemmer();
        if (stemmer != null) {
            return new SnowballFilter(ts, stemmer);
        }
        return ts;
    }
}

