/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine.analyzer;

import com.logicaldoc.core.i18n.Language;
import com.logicaldoc.core.i18n.LanguageManager;
import com.logicaldoc.core.searchengine.StandardSearchEngine;
import com.logicaldoc.core.searchengine.analyzer.SnowballFilterFactory;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilterFactory;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredAnalyzer
extends AnalyzerWrapper {
    private static final String INDEX_TOKENFILTER = "index.tokenfilter.";
    private static final Logger log = LoggerFactory.getLogger(FilteredAnalyzer.class);
    public static final ThreadLocal<String> lang = ThreadLocal.withInitial(() -> "en");

    public FilteredAnalyzer() {
        super(GLOBAL_REUSE_STRATEGY);
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.getLanguage().getAnalyzer();
    }

    private Language getLanguage() {
        LanguageManager man = LanguageManager.getInstance();
        Language language = man.getLanguage(LocaleUtil.toLocale(lang.get()));
        if (language == null) {
            language = new Language(Locale.ENGLISH);
        }
        return language;
    }

    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        TokenStream ts = components.getTokenStream();
        Map<String, String> filters = FilteredAnalyzer.getTokenFilters();
        List<String> order = FilteredAnalyzer.getTokenFilterNames(true);
        ContextProperties config = Context.get().getProperties();
        for (String filter : order) {
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("luceneMatchVersion", StandardSearchEngine.VERSION.toString());
            configs.put("lang", lang.get());
            Map<String, String> filterSettings = config.getProperties(INDEX_TOKENFILTER + filter + ".");
            for (Map.Entry<String, String> entry : filterSettings.entrySet()) {
                String val = entry.getValue();
                if (!StringUtils.isNotEmpty((CharSequence)val)) continue;
                configs.put(entry.getKey(), val);
            }
            String filterClass = filters.get(filter);
            if (!filterClass.equalsIgnoreCase(SnowballFilterFactory.class.getName())) {
                configs.remove("lang");
                configs.remove("position");
            }
            Class<?> aClass = null;
            try {
                aClass = Class.forName(filterClass);
            }
            catch (Exception t) {
                log.error("{} not found", (Object)filterClass);
            }
            ts = this.intantiateFilterClass(aClass, ts, configs);
        }
        return new Analyzer.TokenStreamComponents(components.getSource(), ts);
    }

    private TokenStream intantiateFilterClass(Class aClass, TokenStream ts, Map<String, String> configs) {
        if (aClass != null) {
            try {
                Constructor constructor = aClass.getConstructor(Map.class);
                TokenFilterFactory factory = (TokenFilterFactory)constructor.newInstance(configs);
                if (factory instanceof WordDelimiterGraphFilterFactory) {
                    WordDelimiterGraphFilterFactory wdFactory = (WordDelimiterGraphFilterFactory)factory;
                    FilesystemResourceLoader loader = new FilesystemResourceLoader(new File(Context.get().getProperties().getProperty("index.dir") + "/logicaldoc/conf").toPath(), ((Object)((Object)this)).getClass().getClassLoader());
                    wdFactory.inform((ResourceLoader)loader);
                }
                ts = factory.create(ts);
                log.debug("Appended token stream filter {}", (Object)aClass.getName());
            }
            catch (NoSuchMethodException nse) {
                log.warn("constructor (Map<String, String>) not found for {}", (Object)aClass.getName());
            }
            catch (Exception e) {
                log.warn("constructor (Map<String, String>) of {} raised an error: {}", aClass.getName(), e.getMessage(), e);
            }
        }
        return ts;
    }

    private static Map<String, String> getTokenFilters() {
        HashMap<String, String> activeAnalyzers = new HashMap<String, String>();
        PluginRegistry registry = PluginRegistry.getInstance();
        if (registry == null) {
            return activeAnalyzers;
        }
        Collection<Object> extensions = new ArrayList();
        try {
            extensions = registry.getExtensions("logicaldoc-core", "TokenFilter");
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
        for (Extension extension : extensions) {
            String name = extension.getParameter("name").valueAsString();
            String clazz = extension.getParameter("factory").valueAsString();
            activeAnalyzers.put(name, clazz);
        }
        return activeAnalyzers;
    }

    public static List<String> getTokenFilterNames(boolean justActives) {
        ContextProperties config = Context.get().getProperties();
        Map<String, String> filters = FilteredAnalyzer.getTokenFilters();
        ArrayList<String> names = new ArrayList<String>();
        if (!justActives) {
            names.addAll(filters.keySet());
        } else {
            for (String name : filters.keySet()) {
                if (!"enabled".equals(config.getProperty(INDEX_TOKENFILTER + name))) continue;
                names.add(name);
            }
        }
        names.sort((name1, name2) -> {
            Integer pos1 = config.getInt(INDEX_TOKENFILTER + name1 + ".position", 1);
            Integer pos2 = config.getInt(INDEX_TOKENFILTER + name2 + ".position", 1);
            return pos1.compareTo(pos2);
        });
        return names;
    }
}

