/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.searchengine.Hit;
import com.logicaldoc.core.searchengine.Search;
import com.logicaldoc.core.searchengine.SearchException;
import com.logicaldoc.util.spring.Context;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class TagSearch
extends Search {
    protected TagSearch() {
    }

    @Override
    public void internalSearch() throws SearchException {
        DocumentDAO dao = Context.get(DocumentDAO.class);
        try {
            String query = this.prepareQuery();
            this.hits.addAll(dao.query(query, new HitMapper(), this.options.getMaxHits()));
        }
        catch (PersistenceException e) {
            throw new SearchException(e);
        }
        this.moreHitsPresent = this.hits.size() >= this.options.getMaxHits();
        this.estimatedHitsNumber = this.moreHitsPresent ? (long)this.hits.size() + 1L : (long)this.hits.size();
    }

    private String prepareQuery() throws PersistenceException {
        StringBuilder query = new StringBuilder("select A.ld_id, A.ld_customid, A.ld_docref, A.ld_type, A.ld_version, A.ld_lastmodified, ");
        query.append(" A.ld_date, A.ld_publisher, A.ld_creation, A.ld_creator, A.ld_filesize, A.ld_immutable, ");
        query.append(" A.ld_indexed, A.ld_lockuserid, A.ld_filename, A.ld_status, A.ld_signed, A.ld_type, ");
        query.append(" A.ld_rating, A.ld_fileversion, A.ld_comment, A.ld_workflowstatus, A.ld_startpublishing, ");
        query.append(" A.ld_stoppublishing, A.ld_published, ");
        query.append(" B.ld_name, A.ld_folderid, A.ld_templateid, C.ld_name, A.ld_tenantid, A.ld_docreftype, ");
        query.append(" A.ld_stamped, A.ld_password, A.ld_workflowstatusdisp, A.ld_language, A.ld_pages, A.ld_color, A.ld_lastnote ");
        query.append(" from ld_document A ");
        query.append(" join ld_folder B on A.ld_folderid=B.ld_id ");
        query.append(" left outer join ld_template C on A.ld_templateid=C.ld_id ");
        this.appendWhereClause(false, query);
        query.append(" UNION select A.ld_id, REF.ld_customid, A.ld_docref, REF.ld_type, REF.ld_version, REF.ld_lastmodified, ");
        query.append(" REF.ld_date, REF.ld_publisher, REF.ld_creation, REF.ld_creator, REF.ld_filesize, REF.ld_immutable, ");
        query.append(" REF.ld_indexed, REF.ld_lockuserid, A.ld_filename, REF.ld_status, REF.ld_signed, REF.ld_type, ");
        query.append(" REF.ld_rating, REF.ld_fileversion, REF.ld_comment, REF.ld_workflowstatus, A.ld_startpublishing, ");
        query.append(" A.ld_stoppublishing, A.ld_published, ");
        query.append(" B.ld_name, A.ld_folderid, REF.ld_templateid, C.ld_name, A.ld_tenantid, A.ld_docreftype, ");
        query.append(" REF.ld_stamped, REF.ld_password, REF.ld_workflowstatusdisp, REF.ld_language, REF.ld_pages, A.ld_color, A.ld_lastnote ");
        query.append(" from ld_document A ");
        query.append(" join ld_folder B on A.ld_folderid=B.ld_id ");
        query.append(" join ld_document REF on A.ld_docref=REF.ld_id ");
        query.append(" left outer join ld_template C on REF.ld_templateid=C.ld_id ");
        this.appendWhereClause(true, query);
        log.info("executing tag search query = {}", (Object)query);
        return query.toString();
    }

    private void appendWhereClause(boolean aliases, StringBuilder query) throws PersistenceException {
        long tenantId = 1L;
        if (this.options.getTenantId() != null) {
            tenantId = this.options.getTenantId();
        } else if (this.searchUser != null) {
            tenantId = this.searchUser.getTenantId();
        }
        query.append(" where A.ld_deleted=0 and A.ld_nature=0 and A.ld_folderid=B.ld_id and A.ld_tenantid = ");
        query.append(tenantId);
        query.append(" and not A.ld_status = " + DocumentStatus.ARCHIVED.ordinal());
        String ids = null;
        if (this.getOptions().getFilterIds() != null && !this.getOptions().getFilterIds().isEmpty()) {
            ids = this.getOptions().getFilterIds().toString();
            ids = ids.replace('[', '(').replace(']', ')');
        }
        if (StringUtils.isNotEmpty(ids) && !"()".equals(ids)) {
            query.append(" and A.ld_id in ");
            query.append(ids);
        }
        if (aliases) {
            query.append(" and A.ld_docref is not null and REF.ld_deleted=0 and A.ld_docref = REF.ld_id and A.ld_docref in ");
        } else {
            query.append(" and A.ld_docref is null and A.ld_id in ");
        }
        DocumentDAO docDAO = Context.get(DocumentDAO.class);
        List<Long> precoll = docDAO.findDocIdByUserIdAndTag(this.options.getUserId(), this.options.getExpression());
        String buf = precoll.toString().replace("[", "(").replace("]", ")");
        query.append(!"()".equals(buf) ? buf : "(0)");
        if (!this.searchUser.isMemberOf("admin") && !this.searchUser.isMemberOf("publisher")) {
            query.append(" and A.ld_published = 1 ");
            query.append(" and A.ld_startpublishing <= CURRENT_TIMESTAMP ");
            query.append(" and ( A.ld_stoppublishing is null or A.ld_stoppublishing > CURRENT_TIMESTAMP )");
        }
        if (!this.searchUser.isMemberOf("admin")) {
            query.append(" and not exists (select ld_docid from ld_document_acl where ld_read=0 and ld_docid = A.ld_id ");
            query.append(" and ld_groupid in (");
            query.append(this.searchUser.getGroups().stream().map(g -> Long.toString(g.getId())).collect(Collectors.joining(",")));
            query.append("))");
        }
    }

    public class HitMapper
    implements RowMapper<Hit> {
        public Hit mapRow(ResultSet rs, int rowNum) throws SQLException {
            Hit hit = new Hit();
            hit.setId(rs.getLong(1));
            hit.setCustomId(rs.getString(2));
            hit.setDocRef(rs.getLong(3));
            hit.setType(rs.getString(4));
            hit.setVersion(rs.getString(5));
            hit.setLastModified(rs.getTimestamp(6));
            hit.setDate(rs.getTimestamp(7));
            hit.setPublisher(rs.getString(8));
            hit.setCreation(rs.getTimestamp(9));
            hit.setCreator(rs.getString(10));
            hit.setFileSize(rs.getLong(11));
            hit.setImmutable(rs.getInt(12));
            hit.setIndexingStatus(rs.getInt(13));
            hit.setLockUserId(rs.getLong(14));
            hit.setFileName(rs.getString(15));
            hit.setStatus(rs.getInt(16));
            hit.setSigned(rs.getInt(17));
            hit.setType(rs.getString(18));
            hit.setRating(rs.getInt(19));
            hit.setFileVersion(rs.getString(20));
            hit.setComment(rs.getString(21));
            hit.setWorkflowStatus(rs.getString(22));
            hit.setStartPublishing(rs.getTimestamp(23));
            hit.setStopPublishing(rs.getTimestamp(24));
            hit.setPublished(rs.getInt(25));
            Folder folder = new Folder();
            folder.setName(rs.getString(26));
            folder.setId(rs.getLong(27));
            hit.setFolder(folder);
            if (rs.getLong(28) != 0L) {
                Template t = new Template();
                t.setId(rs.getLong(28));
                t.setName(rs.getString(29));
                hit.setTemplate(t);
                hit.setTemplateId(t.getId());
            }
            hit.setTenantId(rs.getLong(30));
            hit.setDocRefType(rs.getString(31));
            hit.setStamped(rs.getInt(32));
            hit.setPassword(rs.getString(33));
            hit.setWorkflowStatusDisplay(rs.getString(34));
            hit.setLanguage(rs.getString(35));
            hit.setPages(rs.getInt(36));
            hit.setColor(rs.getString(37));
            hit.setLastNote(rs.getString(38));
            return hit;
        }
    }
}

