/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentNote;
import com.logicaldoc.core.document.DocumentNoteDAO;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.parser.ParserFactory;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.searchengine.Hit;
import com.logicaldoc.core.searchengine.HitField;
import com.logicaldoc.core.searchengine.Hits;
import com.logicaldoc.core.searchengine.IndexException;
import com.logicaldoc.core.searchengine.SearchEngine;
import com.logicaldoc.core.searchengine.analyzer.FilteredAnalyzer;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSearchEngine
implements SearchEngine {
    private static final String LOGICALDOC = "logicaldoc";
    private static final String INDEX_DIR = "index.dir";
    public static final Version VERSION = Version.LUCENE_8_11_2;
    private static final Logger log = LoggerFactory.getLogger(StandardSearchEngine.class);
    @Resource(name="ContextProperties")
    private ContextProperties config;
    @Resource(name="documentDAO")
    protected DocumentDAO documentDao;
    @Resource(name="documentNoteDAO")
    protected DocumentNoteDAO noteDao;
    protected EmbeddedSolrServer server;

    protected StandardSearchEngine() {
    }

    public void setConfig(ContextProperties config) {
        this.config = config;
    }

    public void setDocumentDao(DocumentDAO documentDao) {
        this.documentDao = documentDao;
    }

    @Override
    public synchronized void addHit(Document document, String content) throws IndexException {
        try {
            Document doc = this.getDocument(document);
            SolrInputDocument hit = new SolrInputDocument(new String[0]);
            hit.addField(HitField.ID.getName(), (Object)Long.toString(doc.getId()));
            hit.addField(HitField.TENANT_ID.getName(), (Object)Long.toString(doc.getTenantId()));
            hit.addField(HitField.LANGUAGE.getName(), (Object)doc.getLanguage());
            hit.addField(HitField.FILENAME.getName(), (Object)doc.getFileName());
            hit.addField(HitField.TITLE.getName(), (Object)doc.getTitle());
            hit.addField(HitField.SIZE.getName(), (Object)doc.getFileSize());
            hit.addField(HitField.DATE.getName(), (Object)doc.getDate());
            hit.addField(HitField.CREATION.getName(), (Object)doc.getCreation());
            hit.addField(HitField.CUSTOM_ID.getName(), (Object)doc.getCustomId());
            hit.addField(HitField.COMMENT.getName(), (Object)doc.getComment());
            hit.addField(HitField.TAGS.getName(), (Object)doc.getTagsString());
            hit.addField(HitField.DOC_REF.getName(), (Object)doc.getDocRef());
            this.setContent(content, hit);
            this.setFolder(doc, hit);
            if (doc.getTemplateId() != null) {
                this.addExtendedAttributes(doc, hit);
            }
            StringBuilder sb = new StringBuilder();
            List<DocumentNote> notes = this.noteDao.findByDocId(doc.getId(), doc.getFileVersion());
            for (DocumentNote note : notes) {
                if (sb.length() > 0) {
                    sb.append("\n\n");
                }
                sb.append(note.getMessage());
            }
            if (sb.length() > 0) {
                hit.addField(HitField.NOTES.getName(), (Object)sb.toString());
            }
            try {
                FilteredAnalyzer.lang.set(doc.getLanguage());
                this.server.add(hit);
                this.server.commit();
            }
            finally {
                FilteredAnalyzer.lang.remove();
            }
        }
        catch (PersistenceException | IOException | SolrServerException e) {
            throw new IndexException(e.getMessage(), e);
        }
    }

    private void addExtendedAttributes(Document doc, SolrInputDocument hit) {
        hit.addField(HitField.TEMPLATE_ID.getName(), (Object)doc.getTemplateId());
        for (String attribute : doc.getAttributeNames()) {
            Attribute ext = doc.getAttribute(attribute);
            if (StringUtils.isNotEmpty(ext.getParent()) || ext.getType() != 0 && ext.getType() != 4 || !StringUtils.isNotEmpty(ext.getStringValue()) && !StringUtils.isNotEmpty(ext.getStringValues())) continue;
            hit.addField("ext_" + attribute, (Object)(StringUtils.isNotEmpty(ext.getStringValues()) ? ext.getStringValues() : ext.getStringValue()));
        }
    }

    private void setFolder(Document doc, SolrInputDocument hit) {
        if (doc.getFolder() != null) {
            hit.addField(HitField.FOLDER_ID.getName(), (Object)doc.getFolder().getId());
            hit.addField(HitField.FOLDER_NAME.getName(), (Object)doc.getFolder().getName());
        }
    }

    private void setContent(String content, SolrInputDocument hit) {
        int maxText = this.getMaxText();
        if (content != null) {
            String utf8Content = StringUtil.removeNonUtf8Chars(content);
            if (maxText > 0 && utf8Content.length() > maxText) {
                hit.addField(HitField.CONTENT.getName(), (Object)StringUtils.substring(utf8Content, 0, maxText));
            } else {
                hit.addField(HitField.CONTENT.getName(), (Object)utf8Content);
            }
        }
    }

    private int getMaxText() {
        int maxText = -1;
        if (StringUtils.isNotEmpty(this.config.getProperty("index.maxtext"))) {
            try {
                maxText = this.config.getInt("index.maxtext");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return maxText;
    }

    private Document getDocument(Document document) throws PersistenceException {
        Document doc = document;
        if (document.getDocRef() != null) {
            Document referencedDoc = (Document)this.documentDao.findById(document.getDocRef());
            this.documentDao.initialize(referencedDoc);
            doc = new Document(referencedDoc);
            doc.setId(document.getId());
            doc.setTenantId(document.getTenantId());
            doc.setDocRef(document.getDocRef());
            doc.setDocRefType(document.getDocRefType());
            doc.setFolder(document.getFolder());
        }
        return doc;
    }

    @Override
    public synchronized void addHit(Document document, InputStream content) throws IndexException {
        try {
            Locale locale;
            Document doc = document;
            if (doc.getDocRef() != null) {
                doc = (Document)this.documentDao.findById(doc.getDocRef());
                this.documentDao.initialize(doc);
            }
            if ((locale = doc.getLocale()) == null) {
                locale = Locale.ENGLISH;
            }
            String contentString = null;
            if (doc.getIndexed() != IndexingStatus.TO_INDEX_METADATA) {
                ParserFactory.parse(content, doc.getFileName(), null, locale, doc.getTenantId(), doc, null);
            }
            this.addHit(doc, contentString);
        }
        catch (PersistenceException | ParsingException | IndexException e) {
            throw new IndexException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void optimize() {
        log.warn("Started optimization of the index");
        try {
            this.server.optimize(true, true);
        }
        catch (Exception e) {
            log.error("Error during optimization");
            log.error(e.getMessage(), e);
        }
        log.warn("Finished optimization of the index");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String check() {
        Object statMsg;
        block23: {
            log.warn("Checking index");
            statMsg = "";
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    CheckIndex ci = new CheckIndex(this.getIndexDataDirectory());
                    try {
                        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                            PrintStream ps = new PrintStream(baos);
                            CheckIndex.Status status = this.retrieveStatus(ci, ps);
                            if (status != null) {
                                if (status.clean) {
                                    statMsg = "OK\n";
                                } else if (status.toolOutOfDate) {
                                    statMsg = "ERROR: Can't check - tool out-of-date\n";
                                } else {
                                    statMsg = "BAD: ";
                                    if (status.missingSegments) {
                                        statMsg = (String)statMsg + "missingSegments ";
                                    }
                                    if (status.numBadSegments > 0) {
                                        statMsg = (String)statMsg + "numBadSegments=" + status.numBadSegments + " ";
                                    }
                                    if (status.totLoseDocCount > 0) {
                                        statMsg = (String)statMsg + "lostDocCount=" + status.totLoseDocCount + " ";
                                    }
                                }
                                String content = this.getContent(baos);
                                statMsg = (String)statMsg + "\n" + content;
                            }
                        }
                        if (ci == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (ci == null) throw throwable;
                        ci.close();
                        throw throwable;
                    }
                    ci.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception t) {
                log.error(t.getMessage());
            }
        }
        log.warn("Finished checking index");
        return statMsg;
    }

    private CheckIndex.Status retrieveStatus(CheckIndex ci, PrintStream ps) {
        CheckIndex.Status status = null;
        ci.setInfoStream(ps);
        try {
            status = ci.checkIndex();
        }
        catch (Exception e) {
            ps.println("ERROR: caught exception, giving up.\n\n");
            log.error(e.getMessage());
        }
        return status;
    }

    private String getContent(ByteArrayOutputStream baos) {
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public synchronized void deleteHit(long id) {
        try {
            this.server.deleteById(Long.toString(id));
            this.server.commit();
        }
        catch (Exception e) {
            log.debug("Unable to delete hit {}", (Object)id, (Object)e);
        }
    }

    @Override
    public synchronized void deleteHits(Collection<Long> ids) {
        try {
            this.server.deleteById(ids.stream().map(i -> Long.toString(i)).toList());
            this.server.commit();
        }
        catch (Exception e) {
            log.debug("Unable to delete {} hits", (Object)ids.size(), (Object)e);
        }
    }

    @Override
    public Hit getHit(long id) {
        SolrDocumentList docs;
        block3: {
            SolrQuery query = new SolrQuery();
            query.setQuery("id:" + id);
            query.setFields(new String[]{"*"});
            try {
                QueryResponse rsp = this.server.query((SolrParams)query);
                docs = rsp.getResults();
                if (!CollectionUtils.isEmpty((Collection)docs)) break block3;
                return null;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                return null;
            }
        }
        SolrDocument doc = (SolrDocument)docs.get(0);
        Hit hit = Hits.toHit(doc);
        hit.setContent((String)doc.getFieldValue(HitField.CONTENT.getName()));
        return hit;
    }

    @Override
    public Hits query(String expression, int page, int size) {
        SolrQuery query = new SolrQuery(expression).setRows(Integer.valueOf(size)).setStart(Integer.valueOf((page - 1) * size)).setSort(SolrQuery.SortClause.asc((String)"id"));
        Hits hits = null;
        try {
            QueryResponse rsp = this.server.query((SolrParams)query);
            hits = new Hits(rsp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return hits;
    }

    @Override
    public Hits search(String expression, Set<String> filters, String expressionLanguage, Integer rows) {
        try {
            FilteredAnalyzer.lang.set(expressionLanguage);
            Hits hits = null;
            SolrQuery query = this.prepareSearchQuery(expression, filters, expressionLanguage, rows);
            try {
                log.info("Execute search: {}   with filters: {}", (Object)expression, (Object)filters);
                QueryResponse rsp = this.server.query((SolrParams)query);
                log.debug("fulltext query results: {}", (Object)rsp.getResults().getNumFound());
                hits = new Hits(rsp);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            Hits hits2 = hits;
            return hits2;
        }
        finally {
            FilteredAnalyzer.lang.remove();
        }
    }

    protected SolrQuery prepareSearchQuery(String expression, Set<String> filters, String expressionLanguage, Integer rows) {
        BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
        SolrQuery query = new SolrQuery().setQuery(expression);
        if (rows != null) {
            query = query.setRows(rows);
        }
        if (CollectionUtils.isNotEmpty(filters)) {
            for (String filter : filters) {
                query = query.addFilterQuery(new String[]{filter});
            }
        }
        query = query.setSort(SolrQuery.SortClause.desc((String)"score"));
        query.set("exprLang", new String[]{expressionLanguage});
        return query;
    }

    @Override
    public synchronized void unlock() {
        try {
            Directory directory = this.getIndexDataDirectory();
            if (this.isLocked()) {
                directory.obtainLock("write.lock").close();
            }
        }
        catch (Exception e) {
            log.warn("unlock {}", (Object)e.getMessage());
            FileUtil.delete(new File(this.getIndexDataFolder(), "write.lock"));
        }
    }

    @Override
    public boolean isLocked() {
        boolean locked = false;
        try {
            Directory directory = this.getIndexDataDirectory();
            locked = !this.obtainLock(directory);
        }
        catch (Exception e) {
            log.warn("isLocked {}", (Object)e.getMessage(), (Object)e);
        }
        return locked;
    }

    private boolean obtainLock(Directory directory) throws IOException {
        boolean result = false;
        try {
            directory.obtainLock("write.lock").close();
            result = true;
        }
        catch (LockObtainFailedException failed) {
            result = false;
        }
        return result;
    }

    @Override
    public long getCount() {
        SolrQuery query = new SolrQuery();
        query.setQuery("*:*");
        try {
            QueryResponse rsp = this.server.query((SolrParams)query);
            SolrDocumentList docs = rsp.getResults();
            return docs.getNumFound();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return 0L;
        }
    }

    @Override
    public long purge() {
        log.info("Purging the index");
        ArrayList<Long> deletedDocs = new ArrayList();
        try {
            deletedDocs = this.documentDao.findDeletedDocIds();
            this.deleteHits(deletedDocs);
            log.info("{} entries marked as deleted because refer to deleted documents", (Object)deletedDocs.size());
        }
        catch (PersistenceException e) {
            log.warn(e.getMessage(), e);
        }
        SolrQuery query = new SolrQuery("*:*").setRows(Integer.valueOf(1000)).setSort(SolrQuery.SortClause.asc((String)"id"));
        String cursorMark = "*";
        boolean done = false;
        long deletedCount = 0L;
        try {
            while (!done) {
                query.set("cursorMark", new String[]{cursorMark});
                QueryResponse rsp = this.server.query((SolrParams)query);
                String nextCursorMark = rsp.getNextCursorMark();
                ArrayList<Long> hitsToDelete = new ArrayList<Long>();
                SolrDocumentList docs = rsp.getResults();
                for (SolrDocument doc : docs) {
                    long count = this.documentDao.queryForLong("select count(ld_id) from ld_document where ld_deleted=0 and ld_id=" + String.valueOf(doc.get((Object)HitField.ID.getName())));
                    if (count >= 1L) continue;
                    hitsToDelete.add(Long.parseLong(doc.get((Object)HitField.ID.getName()).toString()));
                }
                this.deleteHits(deletedDocs);
                deletedCount += (long)deletedDocs.size();
                if (cursorMark.equals(nextCursorMark)) {
                    done = true;
                }
                cursorMark = nextCursorMark;
            }
        }
        catch (PersistenceException | IOException | NumberFormatException | SolrServerException e) {
            log.error(e.getMessage(), e);
        }
        log.info("{} entries were removed from the index because refer to unexisting documents", (Object)deletedCount);
        return deletedCount;
    }

    @Override
    public void dropIndex() {
        try {
            this.server.deleteByQuery("*:*");
            this.server.optimize();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    Directory getIndexDataDirectory() throws IOException {
        return new NIOFSDirectory(this.getIndexDataFolder().toPath());
    }

    File getIndexDataFolder() {
        File indexdir = new File(this.config.getProperty(INDEX_DIR));
        indexdir = new File(indexdir, LOGICALDOC);
        indexdir = new File(indexdir, "data");
        return new File(indexdir, "index");
    }

    @Override
    @PreDestroy
    public synchronized void close() {
        log.warn("Closing the indexer");
        try {
            this.server.commit();
            this.unlock();
            this.server.getCoreContainer().shutdown();
            this.server.close();
            FileUtil.delete(new File(this.getIndexDataFolder(), "write.lock"));
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
    }

    @Override
    @PostConstruct
    public void init() {
        log.info("Initializing the full-text search engine");
        try {
            File alphatypesTxt;
            File protwordsTxt;
            File synonymsTxt;
            File schemaXml;
            File solrconfigXml;
            File conf;
            File coreProp;
            System.setProperty("solr.disable.shardsWhitelist", "true");
            System.setProperty("solr.http1", "true");
            File indexHome = new File(this.config.getProperty(INDEX_DIR));
            File solrXml = new File(indexHome, "solr.xml");
            if (!indexHome.exists()) {
                indexHome.mkdirs();
                indexHome.mkdir();
            }
            if (!solrXml.exists()) {
                FileUtil.copyResource("index/solr.xml", solrXml);
            }
            File ldoc = new File(this.config.getProperty(INDEX_DIR));
            if (!(ldoc = new File(ldoc, LOGICALDOC)).exists()) {
                ldoc.mkdirs();
                ldoc.mkdir();
            }
            if (!(coreProp = new File(ldoc, "core.properties")).exists()) {
                FileUtil.copyResource("index/logicaldoc/core.properties", coreProp);
            }
            if (!(conf = new File(ldoc, "conf")).exists()) {
                conf.mkdirs();
                conf.mkdir();
            }
            if (!(solrconfigXml = new File(conf, "solrconfig.xml")).exists()) {
                FileUtil.copyResource("index/logicaldoc/conf/solrconfig.xml", solrconfigXml);
            }
            if (!(schemaXml = new File(conf, "schema.xml")).exists()) {
                FileUtil.copyResource("index/logicaldoc/conf/schema.xml", schemaXml);
            }
            if (!(synonymsTxt = new File(conf, "synonyms.txt")).exists()) {
                FileUtil.copyResource("index/logicaldoc/conf/synonyms.txt", synonymsTxt);
            }
            if (!(protwordsTxt = new File(conf, "protwords.txt")).exists()) {
                FileUtil.copyResource("index/logicaldoc/conf/protwords.txt", protwordsTxt);
            }
            if (!(alphatypesTxt = new File(conf, "alphatypes.txt")).exists()) {
                FileUtil.copyResource("index/logicaldoc/conf/alphatypes.txt", alphatypesTxt);
            }
            FileUtil.delete(new File(indexHome, "logicaldoc/data/index/write.lock"));
            CoreContainer container = new CoreContainer(indexHome.toPath(), null);
            this.server = new EmbeddedSolrServer(container, LOGICALDOC);
            container.load();
            this.unlock();
            log.info("The full-text search engine has been initialized");
        }
        catch (Exception e) {
            log.error("Unable to initialize the Full-text search engine", e);
        }
    }

    @Override
    public Object getServer() {
        return this.server;
    }

    public void setNoteDao(DocumentNoteDAO noteDao) {
        this.noteDao = noteDao;
    }
}

