/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine;

import com.logicaldoc.core.security.user.UserHistory;
import jakarta.persistence.Transient;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class SearchOptions
implements Serializable,
Comparable<SearchOptions> {
    private static final long serialVersionUID = 2L;
    public static final int TYPE_FULLTEXT = 0;
    public static final int TYPE_TAG = 1;
    public static final int TYPE_PARAMETRIC = 2;
    public static final int TYPE_FOLDERS = 3;
    private int page = 1;
    private int maxHits = 40;
    private int type = 0;
    private String expression = "";
    private String name = "";
    private String description = "";
    private transient Map<String, Object> parameters = null;
    private long userId = -1L;
    private String topOperator;
    private boolean caseSensitive = true;
    private boolean retrieveAliases = true;
    private Set<Long> filterIds = new HashSet<Long>();
    private Long folderId = null;
    private boolean searchInSubPath = false;
    private Long template = null;
    private Long tenantId = null;
    @Transient
    private UserHistory transaction;

    public Long getTemplate() {
        return this.template;
    }

    public void setTemplate(Long template) {
        this.template = template;
    }

    protected SearchOptions(int type) {
        this.type = type;
    }

    protected SearchOptions() {
    }

    public void setExpression(String expr) {
        this.expression = expr;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static SearchOptions read(File file) throws IOException, ClassNotFoundException {
        SearchOptions searchOptions = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));){
                searchOptions = (SearchOptions)in.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception t) {
            Throwable throwable = null;
            Object var4_10 = null;
            try (XMLDecoder decoder = new XMLDecoder(new FileInputStream(file));){
                searchOptions = (SearchOptions)decoder.readObject();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        return searchOptions;
    }

    public void write(File file) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));){
                encoder.writeObject(this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }

    public boolean isFulltext() {
        return this.getType() == 0;
    }

    public String getExpression() {
        return this.expression;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getTopOperator() {
        return this.topOperator;
    }

    public void setTopOperator(String topOperator) {
        this.topOperator = topOperator;
    }

    public Set<Long> getFilterIds() {
        return this.filterIds;
    }

    public void setFilterIds(Set<Long> filterIds) {
        this.filterIds = filterIds;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Long getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Long folderId) {
        this.folderId = folderId;
    }

    public boolean isSearchInSubPath() {
        return this.searchInSubPath;
    }

    public void setSearchInSubPath(boolean searchInSubPath) {
        this.searchInSubPath = searchInSubPath;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isRetrieveAliases() {
        return this.retrieveAliases;
    }

    public void setRetrieveAliases(boolean retrieveAliases) {
        this.retrieveAliases = retrieveAliases;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public UserHistory getTransaction() {
        return this.transaction;
    }

    public void setTransaction(UserHistory transaction) {
        this.transaction = transaction;
    }

    @Override
    public int compareTo(SearchOptions o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SearchOptions)) {
            return false;
        }
        SearchOptions other = (SearchOptions)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName().replace("Options", "") + new ReflectionToStringBuilder(this, ToStringStyle.NO_CLASS_NAME_STYLE){

            protected boolean accept(Field field) {
                try {
                    Object value = field.get(this.getObject());
                    return !(!super.accept(field) || field.getName().equals("name") || field.getName().equals("description") || field.getName().equals("transaction") || value == null || !StringUtils.isNotEmpty((CharSequence)value.toString()) || field.getType().isArray() && Array.getLength(value) <= 0 || Collection.class.isAssignableFrom(field.getType()) && !Boolean.FALSE.equals(value.getClass().getDeclaredMethod("isEmpty", new Class[0]).invoke(value, new Object[0])));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    return false;
                }
            }
        }.toString();
    }
}

