/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.searchengine.Hit;
import com.logicaldoc.core.searchengine.SearchException;
import com.logicaldoc.core.searchengine.SearchOptions;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserEvent;
import com.logicaldoc.core.security.user.UserHistory;
import com.logicaldoc.core.security.user.UserHistoryDAO;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public abstract class Search {
    protected static final Logger log = LoggerFactory.getLogger(Search.class);
    protected boolean moreHitsPresent = false;
    protected SearchOptions options;
    protected List<Hit> hits = new ArrayList<Hit>();
    protected long estimatedHitsNumber = 0L;
    protected long execTime = 0L;
    protected User searchUser;

    public static Search get(SearchOptions opt) {
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Object> extensions = new ArrayList();
        try {
            extensions = registry.getExtensions("logicaldoc-core", "Search");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        Search search = null;
        for (Extension extension : extensions) {
            int type = Integer.parseInt(extension.getParameter("type").valueAsString());
            if (type != opt.getType()) continue;
            String className = extension.getParameter("class").valueAsString();
            try {
                search = (Search)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                search.setOptions(opt);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            break;
        }
        return search;
    }

    public static SearchOptions newOptions(int type) {
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Object> extensions = new ArrayList();
        try {
            extensions = registry.getExtensions("logicaldoc-core", "Search");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        SearchOptions options = null;
        for (Extension extension : extensions) {
            int t = Integer.parseInt(extension.getParameter("type").valueAsString());
            if (t != type) continue;
            String className = extension.getParameter("options").valueAsString();
            try {
                options = (SearchOptions)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                options.setType(type);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            break;
        }
        if (options == null) {
            log.error("Unable to find a search definition of type {}", (Object)type);
        }
        return options;
    }

    protected Search() {
    }

    public final List<Hit> search() throws SearchException {
        String extattrs;
        log.info("Launch search");
        log.info("Expression: {}", (Object)this.options.getExpression());
        this.initSearchUser();
        if (this.searchUser == null) {
            log.warn("Unexisting user");
            return this.hits;
        }
        Date start = new Date();
        this.hits.clear();
        this.moreHitsPresent = false;
        this.internalSearch();
        ContextProperties config = Context.get().getProperties();
        TenantDAO tdao = Context.get(TenantDAO.class);
        try {
            extattrs = config.getProperty(tdao.getTenantName(this.searchUser.getTenantId()) + ".search.extattr");
        }
        catch (PersistenceException e) {
            throw new SearchException(e);
        }
        if (StringUtils.isNotEmpty(extattrs) && !this.hits.isEmpty()) {
            List<String> attrs = Arrays.asList(extattrs.trim().split(","));
            StringBuilder idsString = new StringBuilder("(");
            idsString.append(this.hits.stream().map(h -> Long.toString(h.getId())).collect(Collectors.joining(",")));
            idsString.append(")");
            log.debug("Start searching for extended attributes: {}", (Object)attrs);
            final HashMap<String, Attribute> extAtt = new HashMap<String, Attribute>();
            DocumentDAO ddao = Context.get(DocumentDAO.class);
            StringBuilder query = new StringBuilder();
            if (this.hits.get(0).getType().startsWith("folder")) {
                query.append("select ld_folderid, ld_name, ld_type, ld_stringvalue, ld_intvalue, ld_doublevalue, ld_datevalue, ld_stringvalues ");
                query.append(" from ld_folder_ext where ld_folderid in ");
            } else {
                query.append("select ld_docid, ld_name, ld_type, ld_stringvalue, ld_intvalue, ld_doublevalue, ld_datevalue, ld_stringvalues ");
                query.append(" from ld_document_ext where ld_docid in ");
            }
            query.append((CharSequence)idsString);
            query.append(" and ld_name in ");
            query.append(attrs.toString().replace("[", "('").replace("]", "')").replace(",", "','").replace(" ", ""));
            try {
                ddao.query(query.toString(), new RowMapper<Long>(){

                    public Long mapRow(ResultSet rs, int row) throws SQLException {
                        Long docId = rs.getLong(1);
                        String name = rs.getString(2);
                        Attribute ext = new Attribute();
                        ext.setName(name);
                        ext.setStringValue(rs.getString(4));
                        ext.setIntValue(rs.getLong(5));
                        ext.setDoubleValue(rs.getDouble(6));
                        ext.setDateValue(rs.getDate(7));
                        ext.setStringValues(rs.getString(8));
                        ext.setType(rs.getInt(3));
                        extAtt.put(String.valueOf(docId) + "-" + name, ext);
                        return null;
                    }
                }, null);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
            this.copyExtendedAttributesToHits(attrs, extAtt);
            log.debug("End searching for extended attributes");
        }
        Date finish = new Date();
        this.execTime = finish.getTime() - start.getTime();
        log.info("Search completed in {} ms and found {} hits (estimated {})", this.execTime, this.hits.size(), this.estimatedHitsNumber);
        UserHistoryDAO historyDao = Context.get(UserHistoryDAO.class);
        UserHistory transaction = this.options.getTransaction();
        if (transaction == null) {
            transaction = new UserHistory();
        }
        transaction.setUser(this.searchUser);
        transaction.setComment(StringUtils.left(this.options.toString(), 500));
        transaction.setEvent(UserEvent.SEARCH);
        try {
            historyDao.store(transaction);
        }
        catch (PersistenceException e) {
            log.info("Error trying to save search history", e);
        }
        return this.hits;
    }

    protected Collection<Long> getAccessibleFolderIds() throws SearchException {
        boolean searchInSingleFolder;
        FolderDAO fdao = Context.get(FolderDAO.class);
        Collection<Long> accessibleFolderIds = new TreeSet<Long>();
        boolean bl = searchInSingleFolder = this.options.getFolderId() != null && !this.options.isSearchInSubPath();
        if (!searchInSingleFolder) {
            try {
                log.debug("Accessible folders search");
                accessibleFolderIds = this.options.getFolderId() != null ? fdao.findFolderIdByUserIdInPath(this.options.getUserId(), this.options.getFolderId()) : fdao.findFolderIdByUserId(this.options.getUserId(), null, true);
                log.debug("End of accessible folders search");
            }
            catch (PersistenceException e) {
                throw new SearchException(e);
            }
        }
        return accessibleFolderIds;
    }

    protected Set<Long> getDeniedDocIds(List<Hit> hits, Collection<Long> accessibleFolderIds) throws SearchException {
        HashSet<Long> denied = new HashSet<Long>();
        if (this.searchUser.isAdmin() || hits.isEmpty()) {
            return denied;
        }
        DocumentDAO dao = Context.get(DocumentDAO.class);
        for (Hit hit : hits) {
            if (accessibleFolderIds == null || accessibleFolderIds.contains(hit.getFolder().getId())) continue;
            denied.add(hit.getId());
        }
        try {
            StringBuilder query = new StringBuilder("select ld_docid from ld_document_acl where ld_read=0 and ld_docid in (");
            query.append(hits.stream().map(h -> Long.toString(h.getId())).collect(Collectors.joining(",")));
            query.append(") and ld_groupid in (");
            query.append(this.searchUser.getGroups().stream().map(g -> Long.toString(g.getId())).collect(Collectors.joining(",")));
            query.append(") ");
            if (!denied.isEmpty()) {
                query.append(" and not ld_docid in (");
                query.append(denied.stream().map(Object::toString).collect(Collectors.joining(",")));
                query.append(")");
            }
            denied.addAll(dao.queryForList(query.toString(), Long.class));
        }
        catch (PersistenceException e) {
            throw new SearchException(e.getMessage(), e);
        }
        return denied;
    }

    private void copyExtendedAttributesToHits(List<String> atributeNames, Map<String, Attribute> extAttribute) {
        for (Hit h : this.hits) {
            for (String name : atributeNames) {
                Attribute att = extAttribute.get(h.getId() + "-" + name);
                if (h.getDocRef() != null && h.getDocRef() != 0L) {
                    att = extAttribute.get(String.valueOf(h.getDocRef()) + "-" + name);
                }
                if (att == null) continue;
                h.getAttributes().put(name, att);
            }
        }
    }

    private void initSearchUser() throws SearchException {
        UserDAO uDao = Context.get(UserDAO.class);
        try {
            this.searchUser = (User)uDao.findById(this.options.getUserId());
            uDao.initialize(this.searchUser);
        }
        catch (PersistenceException e1) {
            throw new SearchException(e1);
        }
        if (this.searchUser != null && log.isInfoEnabled()) {
            log.info("Search User: {}", (Object)this.searchUser.getUsername());
        }
    }

    protected abstract void internalSearch() throws SearchException;

    public List<Hit> getHits() {
        return this.hits;
    }

    public boolean isMoreHitsPresent() {
        return this.moreHitsPresent;
    }

    public void setMoreHitsPresent(boolean moreHitsPresent) {
        this.moreHitsPresent = moreHitsPresent;
    }

    public long getEstimatedHitsNumber() {
        return this.estimatedHitsNumber;
    }

    public long getExecTime() {
        return this.execTime;
    }

    public SearchOptions getOptions() {
        return this.options;
    }

    public void setOptions(SearchOptions options) {
        this.options = options;
    }
}

