/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.searchengine.SearchEngine;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.task.TaskException;
import jakarta.annotation.Resource;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="indexOptimizer")
public class IndexOptimizer
extends Task {
    public static final String NAME = "IndexOptimizer";
    @Resource(name="SearchEngine")
    protected SearchEngine indexer;
    @Resource(name="documentDAO")
    protected DocumentDAO documentDao;

    public IndexOptimizer() {
        super(NAME);
        this.log = LoggerFactory.getLogger(IndexOptimizer.class);
    }

    public SearchEngine getIndexer() {
        return this.indexer;
    }

    @Override
    protected void runTask() throws TaskException {
        if (this.indexer.isLocked()) {
            this.log.warn("Index locked, skipping optimization");
            return;
        }
        this.log.info("Start index optimization");
        try {
            try {
                this.deleteOrphaned();
                this.indexer.optimize();
            }
            catch (PersistenceException e) {
                throw new TaskException(e.getMessage(), e);
            }
        }
        finally {
            this.indexer.unlock();
        }
        this.log.info("End of index optimization");
    }

    private void deleteOrphaned() throws PersistenceException {
        List<Long> ids = this.documentDao.findDeletedDocIds();
        this.indexer.deleteHits(ids);
    }

    @Override
    public boolean isIndeterminate() {
        return true;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }
}

