/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.searchengine;

import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.searchengine.Hit;
import com.logicaldoc.core.searchengine.HitField;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;

public class Hits
implements Iterator<Hit>,
Serializable {
    private static final String SCORE = "score";
    private static final long serialVersionUID = 1L;
    private transient Iterator<SolrDocument> internal;
    private QueryResponse rsp;

    public Hits() {
    }

    public Hits(QueryResponse rsp) {
        this.rsp = rsp;
        this.internal = rsp.getResults().iterator();
    }

    public long getEstimatedCount() {
        return this.rsp.getResults().getNumFound();
    }

    public long getElapsedTime() {
        return this.rsp.getElapsedTime();
    }

    public long getCount() {
        return this.rsp.getResults().size();
    }

    @Override
    public boolean hasNext() {
        return this.internal.hasNext();
    }

    @Override
    public Hit next() {
        Float score;
        List snippets;
        SolrDocument doc = this.internal.next();
        Hit hit = Hits.toHit(doc);
        StringBuilder summary = new StringBuilder();
        Object id = doc.getFieldValue("id");
        if (this.rsp.getHighlighting() != null && this.rsp.getHighlighting().get(id) != null && (snippets = (List)((Map)this.rsp.getHighlighting().get(id)).get("content")) != null) {
            for (String string : snippets) {
                if (summary.length() != 0) {
                    summary.append(" ... ");
                }
                summary.append(string);
            }
        }
        if ((score = (Float)doc.getFieldValue(SCORE)) != null) {
            hit.setScore(Hits.createScore(this.rsp.getResults().getMaxScore().floatValue(), score.floatValue()));
        }
        hit.setSummary(summary.toString());
        return hit;
    }

    @Override
    public void remove() {
    }

    public static Hit toHit(SolrDocument sdoc) {
        Hit hit = new Hit();
        hit.setId(Long.parseLong((String)sdoc.get((Object)HitField.ID.getName())));
        if (sdoc.get((Object)HitField.TENANT_ID.getName()) != null) {
            hit.setTenantId((Long)sdoc.getFieldValue(HitField.TENANT_ID.getName()));
        } else {
            hit.setTenantId(1L);
        }
        if (sdoc.getFieldValue(SCORE) != null) {
            Float score = (Float)sdoc.getFieldValue(SCORE);
            hit.setScore((int)(score.floatValue() * 100.0f));
        }
        Folder folder = new Folder();
        hit.setFolder(folder);
        if (sdoc.get((Object)HitField.FOLDER_ID.getName()) != null) {
            folder.setId((Long)sdoc.get((Object)HitField.FOLDER_ID.getName()));
        }
        if (sdoc.get((Object)HitField.FOLDER_NAME.getName()) != null) {
            folder.setName(sdoc.getFieldValue(HitField.FOLDER_NAME.getName()).toString());
        }
        if (sdoc.getFieldValue(HitField.LANGUAGE.getName()) != null) {
            hit.setLanguage(sdoc.getFieldValue(HitField.LANGUAGE.getName()).toString());
        }
        return hit;
    }

    protected static int createScore(float max, float score) {
        float temp;
        int tgreen;
        float normalized = 1.0f;
        if (score != max) {
            normalized = score / max;
        }
        if ((tgreen = Math.round(temp = normalized * 100.0f)) < 1) {
            tgreen = 1;
        }
        return tgreen;
    }
}

