/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.core.parser.Parser;
import com.logicaldoc.core.parser.ParserFactory;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(ZipParser.class);

    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) throws IOException, ParsingException {
        if (parameters.getFileName().toLowerCase().endsWith(".zip")) {
            this.internalParseZip(input, parameters, content);
        } else {
            this.internalParseGZip(input, parameters, content);
        }
    }

    private void internalParseGZip(InputStream input, ParseParameters parameters, StringBuilder content) throws IOException, ParsingException {
        File ungzippedFile = null;
        try {
            ungzippedFile = this.gunzip(input, parameters.getFileName());
            Parser parser = ParserFactory.getParser(ungzippedFile.getName());
            if (parser != null) {
                String cnt = parser.parse(ungzippedFile, ungzippedFile.getName(), parameters.getEncoding(), parameters.getLocale(), parameters.getTenant(), parameters.getDocument(), parameters.getFileVersion());
                content.append(cnt);
            }
        }
        finally {
            if (ungzippedFile != null) {
                FileUtil.delete(ungzippedFile);
            }
        }
    }

    private File gunzip(File input, String fileName) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream is = new FileInputStream(input);){
            return this.gunzip(is, fileName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private File gunzip(InputStream input, String fileName) throws IOException {
        String unpackedFileName = fileName.toLowerCase().endsWith(".tgz") ? FileUtil.getBaseName(fileName) + ".tar.gz" : fileName;
        unpackedFileName = unpackedFileName.substring(0, unpackedFileName.lastIndexOf(46));
        File ungzippedFile = FileUtil.createTempFile("parsegzip", "." + FileUtil.getExtension(unpackedFileName).toLowerCase());
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipUtil zipUtil = new ZipUtil();){
            zipUtil.unGZip(input, ungzippedFile);
            return ungzippedFile;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void internalParseZip(InputStream input, ParseParameters parameters, StringBuilder content) throws IOException, ParsingException {
        block19: {
            File zipFile = FileUtil.createTempFile("parsezip", "zip");
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (ZipUtil zipUtil = new ZipUtil();){
                    FileUtil.writeFile(input, zipFile.getAbsolutePath());
                    List<String> entries = zipUtil.listEntries(zipFile);
                    if (entries.size() > 1) {
                        for (String line : entries) {
                            content.append(line);
                            content.append("\n");
                        }
                        break block19;
                    }
                    String entry = entries.get(0);
                    String entryExtension = FileUtil.getExtension(entry);
                    File uncompressedEntryFile = FileUtil.createTempFile("parse", "." + entryExtension);
                    try {
                        Parser entryParser = ParserFactory.getParser(entryExtension);
                        if (entryParser == null) {
                            throw new IOException(String.format("Unable to find a parser for %s", entryExtension));
                        }
                        zipUtil.unzip(zipFile, entry, uncompressedEntryFile);
                        Document clone = new Document(parameters.getDocument());
                        clone.setFileName(uncompressedEntryFile.getName());
                        String text = entryParser.parse(uncompressedEntryFile, uncompressedEntryFile.getName(), parameters.getEncoding(), parameters.getLocale(), parameters.getTenant(), parameters.getDocument(), parameters.getFileVersion());
                        content.append(text);
                    }
                    finally {
                        if (uncompressedEntryFile != null) {
                            FileUtil.delete(uncompressedEntryFile);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                FileUtil.delete(zipFile);
            }
        }
    }

    @Override
    public int countPages(InputStream input, String filename) {
        if (filename.toLowerCase().endsWith(".zip")) {
            File zipFile = null;
            try {
                zipFile = FileUtil.createTempFile("parsezip", "zip");
                FileUtil.writeFile(input, zipFile.getAbsolutePath());
                int n = this.countPages(zipFile, filename);
                return n;
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
            }
            finally {
                if (zipFile != null) {
                    FileUtil.delete(zipFile);
                }
            }
        }
        File ungzippedFile = null;
        try {
            ungzippedFile = this.gunzip(input, filename);
            Parser parser = ParserFactory.getParser(ungzippedFile.getName());
            if (parser != null) {
                int n = parser.countPages(ungzippedFile, ungzippedFile.getName());
                return n;
            }
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
        finally {
            if (ungzippedFile != null) {
                FileUtil.delete(ungzippedFile);
            }
        }
        return 1;
    }

    @Override
    public int countPages(File input, String filename) {
        block10: {
            if (filename.toLowerCase().endsWith(".zip")) {
                try {
                    return this.countPagesInZipFile(input);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                    break block10;
                }
            }
            File ungzippedFile = null;
            try {
                ungzippedFile = this.gunzip(input, filename);
                Parser parser = ParserFactory.getParser(ungzippedFile.getName());
                if (parser != null) {
                    int n = parser.countPages(ungzippedFile, ungzippedFile.getName());
                    return n;
                }
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
            }
            finally {
                if (ungzippedFile != null) {
                    FileUtil.delete(ungzippedFile);
                }
            }
        }
        return 1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int countPagesInZipFile(File zipFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipUtil zipUtil = new ZipUtil();){
            int n;
            block16: {
                List<String> entries = zipUtil.listEntries(zipFile);
                if (entries.size() > 1) {
                    return entries.size();
                }
                String entry = entries.get(0);
                String entryExtension = FileUtil.getExtension(entry);
                File uncompressedEntryFile = FileUtil.createTempFile("parse", "." + entryExtension);
                try {
                    Parser entryParser = ParserFactory.getParser(entryExtension);
                    if (entryParser == null) {
                        throw new IOException(String.format("Unable to find a parser for %s", entryExtension));
                    }
                    zipUtil.unzip(zipFile, entry, uncompressedEntryFile);
                    n = entryParser.countPages(uncompressedEntryFile, uncompressedEntryFile.getName());
                    if (uncompressedEntryFile == null) break block16;
                }
                catch (Throwable throwable2) {
                    if (uncompressedEntryFile != null) {
                        FileUtil.delete(uncompressedEntryFile);
                    }
                    throw throwable2;
                }
                FileUtil.delete(uncompressedEntryFile);
            }
            return n;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

