/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ExtractorHandler;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.util.StringUtil;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(XMLParser.class);

    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        try {
            CharArrayWriter writer = new CharArrayWriter();
            ExtractorHandler handler = new ExtractorHandler(writer);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            InputSource source = new InputSource(new FilterInputStream(input){

                @Override
                public void close() {
                }
            });
            if (parameters.getEncoding() != null) {
                this.setEncoding(parameters.getEncoding(), source);
            }
            reader.parse(source);
            content.append(StringUtil.writeToString(new CharArrayReader(writer.toCharArray())));
        }
        catch (Exception e) {
            log.warn("Failed to extract XML text content", e);
        }
    }

    private void setEncoding(String encoding, InputSource source) {
        try {
            Charset.forName(encoding);
            source.setEncoding(encoding);
        }
        catch (Exception e) {
            log.warn("Unsupported encoding '{}', using default ({}) instead.", (Object)encoding, (Object)System.getProperty("file.encoding"));
        }
    }
}

