/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(XLSParser.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                POIFSFileSystem fs = new POIFSFileSystem(input);
                try {
                    try (ExcelExtractor extractor = new ExcelExtractor(fs);){
                        String tmp = extractor.getText();
                        if (tmp != null) {
                            tmp = tmp.replaceAll("[\\p{Cntrl}&&[^\\n]]", " ");
                        }
                        content.append(StringUtil.writeToString(new StringReader(tmp)));
                    }
                    if (fs == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fs == null) throw throwable;
                    fs.close();
                    throw throwable;
                }
                fs.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn("Failed to extract Excel text content", e);
        }
    }

    @Override
    public int countPages(InputStream input, String filename) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (HSSFWorkbook excelDoc = new HSSFWorkbook(input);){
                return excelDoc.getNumberOfSheets();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            return 1;
        }
    }
}

