/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.core.parser.Parser;
import com.logicaldoc.core.parser.ParserFactory;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.TarUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(TarParser.class);

    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) throws IOException, ParsingException {
        block10: {
            File tarFile = FileUtil.createTempFile("parsetar", ".tar");
            try {
                FileUtil.writeFile(input, tarFile.getAbsolutePath());
                List<String> entries = new TarUtil().listEntries(tarFile);
                if (entries.size() > 1) {
                    for (String line : entries) {
                        content.append(line);
                        content.append("\n");
                    }
                    break block10;
                }
                String entry = entries.get(0);
                String entryExtension = FileUtil.getExtension(entry);
                File uncompressedEntryFile = FileUtil.createTempFile("parse", "." + entryExtension);
                try {
                    Parser entryParser = ParserFactory.getParser(entryExtension);
                    if (entryParser == null) {
                        throw new IOException(String.format("Unable to find a parser for %s", entryExtension));
                    }
                    new TarUtil().extractEntry(tarFile, uncompressedEntryFile);
                    Document clone = new Document(parameters.getDocument());
                    clone.setFileName(uncompressedEntryFile.getName());
                    String text = entryParser.parse(uncompressedEntryFile, uncompressedEntryFile.getName(), parameters.getEncoding(), parameters.getLocale(), parameters.getTenant(), parameters.getDocument(), parameters.getFileVersion());
                    content.append(text);
                }
                finally {
                    if (uncompressedEntryFile != null) {
                        FileUtil.delete(uncompressedEntryFile);
                    }
                }
            }
            finally {
                FileUtil.delete(tarFile);
            }
        }
    }

    @Override
    public int countPages(InputStream input, String filename) {
        File tarFile = null;
        try {
            tarFile = FileUtil.createTempFile("parsetar", ".tar");
            FileUtil.writeFile(input, tarFile.getAbsolutePath());
            int n = this.countPages(tarFile, filename);
            return n;
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
        finally {
            if (tarFile != null) {
                FileUtil.delete(tarFile);
            }
        }
        return 1;
    }

    @Override
    public int countPages(File input, String filename) {
        int n;
        block8: {
            List<String> entries = new TarUtil().listEntries(input);
            if (entries.size() > 1) {
                return entries.size();
            }
            String entry = entries.get(0);
            String entryExtension = FileUtil.getExtension(entry);
            File uncompressedEntryFile = FileUtil.createTempFile("parse", "." + entryExtension);
            try {
                Parser entryParser = ParserFactory.getParser(entryExtension);
                if (entryParser == null) {
                    throw new IOException(String.format("Unable to find a parser for %s", entryExtension));
                }
                new TarUtil().extractEntry(input, uncompressedEntryFile);
                n = entryParser.countPages(uncompressedEntryFile, uncompressedEntryFile.getName());
                if (uncompressedEntryFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (uncompressedEntryFile != null) {
                        FileUtil.delete(uncompressedEntryFile);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                    return 1;
                }
            }
            FileUtil.delete(uncompressedEntryFile);
        }
        return n;
    }
}

