/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.io.IOUtil;
import com.logicaldoc.util.spring.Context;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TXTParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(TXTParser.class);

    /*
     * Loose catch block
     */
    @Override
    public String parse(File file, String filename, String encoding, Locale locale, String tenant, Document document, String fileVersion) {
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try {
                String string;
                BufferedInputStream bis;
                FileInputStream fis;
                block18: {
                    block17: {
                        fis = new FileInputStream(file);
                        bis = new BufferedInputStream(fis);
                        string = this.parse(bis, new ParseParameters(document, filename, fileVersion, this.determineEncoding(bis, encoding), locale, tenant));
                        if (bis == null) break block17;
                        bis.close();
                    }
                    if (fis == null) break block18;
                    fis.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            log.warn("Failed to extract TXT text content", ex);
            return "";
        }
    }

    private String determineEncoding(BufferedInputStream bis, String probableEncoding) {
        if (StringUtils.isEmpty(probableEncoding)) {
            try {
                CharsetDetector cd = new CharsetDetector();
                cd.setText((InputStream)bis);
                CharsetMatch cm = cd.detect();
                if (cm != null && Charset.isSupported(cm.getName())) {
                    probableEncoding = cm.getName();
                }
            }
            catch (Exception th) {
                log.warn("Error during TXT fileNameCharset detection", th);
            }
        }
        return probableEncoding;
    }

    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        try {
            if (input != null) {
                content.append(StringUtil.writeToString(this.getLimitedStream(input, parameters.getTenant()), parameters.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Unsupported encoding '{}', using default ({}) instead.", (Object)parameters.getEncoding(), (Object)System.getProperty("file.encoding"));
        }
        catch (IOException e) {
            log.warn(e.getMessage(), e);
        }
    }

    private InputStream getLimitedStream(InputStream input, String tenant) {
        long maxBytes = (long)Context.get().getProperties().getInt(tenant + ".parser.txt.maxsize", 1024) * 1024L;
        return IOUtil.getLimitedStream(input, maxBytes);
    }
}

