/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTFParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(RTFParser.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream bis0 = new BufferedInputStream(input);){
                StringBuilder strBuf;
                File tempFile;
                block35: {
                    bis0.mark(Integer.MAX_VALUE);
                    String text = this.extractText(bis0);
                    content.append(StringUtil.writeToString(new StringReader(text)));
                    bis0.reset();
                    tempFile = FileUtil.createTempFile("rtf", ".rtf");
                    Throwable throwable2 = null;
                    Throwable throwable3 = null;
                    try (FileOutputStream out = new FileOutputStream(tempFile);){
                        int len;
                        byte[] buf = new byte[512];
                        while ((len = bis0.read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                    strBuf = null;
                    throwable3 = null;
                    Object var11_17 = null;
                    try {
                        FileInputStream fis = new FileInputStream(tempFile);
                        try {
                            try (BufferedReader d = new BufferedReader(new InputStreamReader(fis));){
                                String thisLine = "";
                                strBuf = new StringBuilder();
                                strBuf.append((CharSequence)content);
                                Pattern pattern = Pattern.compile("fldinst MERGEFIELD ");
                                StringTokenizer st = null;
                                while ((thisLine = d.readLine()) != null) {
                                    String[] stringArray = pattern.split(thisLine);
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    block21: while (n2 < n) {
                                        String string = stringArray[n2];
                                        string = string.replace("\\fldrslt", "");
                                        string = string.replace("\\{", "");
                                        st = new StringTokenizer(string, "}");
                                        while (true) {
                                            if (!st.hasMoreTokens()) {
                                                strBuf.append("\n");
                                                ++n2;
                                                continue block21;
                                            }
                                            String token = st.nextToken();
                                            if (!StringUtils.isNotEmpty(token) || token.startsWith("\\")) continue;
                                            strBuf.append(token);
                                        }
                                    }
                                }
                            }
                            if (fis == null) break block35;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            if (fis == null) throw throwable3;
                            fis.close();
                            throw throwable3;
                        }
                        fis.close();
                    }
                    catch (Throwable throwable6) {
                        if (throwable3 == null) {
                            throwable3 = throwable6;
                            throw throwable3;
                        }
                        if (throwable3 == throwable6) throw throwable3;
                        throwable3.addSuppressed(throwable6);
                        throw throwable3;
                    }
                }
                input.close();
                content.append(strBuf.toString());
                tempFile.deleteOnExit();
                return;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (Exception t) {
            log.warn("Failed to extract RTF text content", t);
        }
    }

    protected String extractText(InputStream input) throws IOException, BadLocationException {
        RTFEditorKit rek = new RTFEditorKit();
        DefaultStyledDocument doc = new DefaultStyledDocument();
        rek.read(input, (Document)doc, 0);
        return doc.getText(0, doc.getLength());
    }

    @Override
    public int countPages(InputStream input, String filename) {
        String text;
        block4: {
            text = StringUtil.writeToString(input, "UTF-8");
            if (text != null) break block4;
            return 1;
        }
        try {
            Pattern pattern = Pattern.compile("\\\\nofpages\\d+");
            Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                String nofpages = matcher.group(0);
                String npages = nofpages.substring(9);
                return Integer.parseInt(npages);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return 1;
    }

    @Override
    public int countPages(File input, String filename) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream stream = new FileInputStream(input);){
                return this.countPages(stream, filename);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return 1;
        }
    }
}

