/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.parser.AbiWordParser;
import com.logicaldoc.core.parser.CatchAllParser;
import com.logicaldoc.core.parser.DOCParser;
import com.logicaldoc.core.parser.EpubParser;
import com.logicaldoc.core.parser.HTMLParser;
import com.logicaldoc.core.parser.KOfficeParser;
import com.logicaldoc.core.parser.MarkdownParser;
import com.logicaldoc.core.parser.OpenOfficeParser;
import com.logicaldoc.core.parser.PDFParser;
import com.logicaldoc.core.parser.PPTParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.core.parser.Parser;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.parser.RTFParser;
import com.logicaldoc.core.parser.RarParser;
import com.logicaldoc.core.parser.SevenZipParser;
import com.logicaldoc.core.parser.TXTParser;
import com.logicaldoc.core.parser.TarParser;
import com.logicaldoc.core.parser.XLSParser;
import com.logicaldoc.core.parser.XMLParser;
import com.logicaldoc.core.parser.ZABWParser;
import com.logicaldoc.core.parser.ZipParser;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserFactory {
    private static final String PARSER_ALIAS = "parser.alias.";
    private static final Logger log = LoggerFactory.getLogger(ParserFactory.class);
    private static Map<String, Parser> parsers = new HashMap<String, Parser>();
    private static Map<String, String> aliases = new HashMap<String, String>();

    private ParserFactory() {
    }

    public static void init() {
        parsers.clear();
        DOCParser doc = new DOCParser();
        parsers.put("doc", doc);
        parsers.put("dot", doc);
        HTMLParser html = new HTMLParser();
        parsers.put("htm", html);
        parsers.put("html", html);
        parsers.put("pdf", new PDFParser());
        parsers.put("rtf", new RTFParser());
        OpenOfficeParser openOffice = new OpenOfficeParser();
        parsers.put("sxw", openOffice);
        parsers.put("sxc", openOffice);
        parsers.put("sxi", openOffice);
        parsers.put("odt", openOffice);
        parsers.put("ods", openOffice);
        parsers.put("odp", openOffice);
        parsers.put("ott", openOffice);
        parsers.put("ots", openOffice);
        parsers.put("otp", openOffice);
        KOfficeParser koffice = new KOfficeParser();
        parsers.put("kwd", koffice);
        parsers.put("ksp", koffice);
        parsers.put("kpr", koffice);
        parsers.put("abw", new AbiWordParser());
        parsers.put("zabw", new ZABWParser());
        TXTParser txt = new TXTParser();
        parsers.put("java", txt);
        parsers.put("json", txt);
        parsers.put("c", txt);
        parsers.put("cpp", txt);
        parsers.put("log", txt);
        parsers.put("txt", txt);
        parsers.put("csv", txt);
        parsers.put("dbf", txt);
        XMLParser xml = new XMLParser();
        parsers.put("xml", xml);
        XLSParser xls = new XLSParser();
        parsers.put("xls", xls);
        parsers.put("xlt", xls);
        PPTParser ppt = new PPTParser();
        parsers.put("ppt", ppt);
        parsers.put("pps", ppt);
        parsers.put("pot", ppt);
        ZipParser zip = new ZipParser();
        parsers.put("zip", zip);
        parsers.put("gz", zip);
        parsers.put("tgz", zip);
        parsers.put("rar", new RarParser());
        parsers.put("tar", new TarParser());
        parsers.put("7z", new SevenZipParser());
        parsers.put("epub", new EpubParser());
        MarkdownParser markdown = new MarkdownParser();
        parsers.put("md", markdown);
        parsers.put("mkd", markdown);
        parsers.put("mdwn", markdown);
        parsers.put("mdown", markdown);
        parsers.put("mdtxt", markdown);
        parsers.put("mdtext", markdown);
        parsers.put("markdown", markdown);
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "Parser");
        for (Extension extension : exts) {
            String ext = extension.getParameter("extension").valueAsString().toLowerCase();
            String className = extension.getParameter("class").valueAsString();
            try {
                Object parser = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(parser instanceof Parser)) {
                    throw new ClassNotFoundException(String.format("The specified parser %s doesn't implement Parser interface", className));
                }
                parsers.put(ext, (Parser)parser);
                log.info("Added new parser {} for extension {}", (Object)className, (Object)ext);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error(e.getMessage());
            }
        }
        ParserFactory.initAliases();
    }

    public static String parse(InputStream input, String filename, String encoding, Locale locale, long tenantId, Document document, String fileVersion) throws ParsingException {
        String tenantName;
        Parser parser = ParserFactory.getParser(filename);
        TenantDAO dao = Context.get(TenantDAO.class);
        try {
            tenantName = dao.getTenantName(tenantId);
        }
        catch (PersistenceException e) {
            throw new ParsingException(e);
        }
        return parser.parse(input, new ParseParameters(document, filename, fileVersion, encoding, locale, tenantName != null ? tenantName : "default"));
    }

    public static Parser getParser(String filename) {
        Parser parser;
        String ext;
        if (parsers.isEmpty()) {
            ParserFactory.init();
        }
        String string = ext = filename.contains(".") ? FileUtil.getExtension(filename.trim()) : filename.trim();
        if (!StringUtils.isEmpty(ext)) {
            ext = ext.toLowerCase();
        }
        if ((parser = parsers.get(ext)) == null) {
            log.info("No registered parser for extension {}. Search for an alias.", (Object)ext);
            String alias = aliases.get(ext);
            if (StringUtils.isNotEmpty(alias)) {
                log.info("Found alias {}", (Object)alias);
                parser = parsers.get(alias);
            }
        }
        if (parser == null) {
            log.warn("Unable to find a specific parser for extension {}", (Object)ext);
            parser = new CatchAllParser();
        }
        return parser;
    }

    public static Set<String> getExtensions() {
        if (parsers.isEmpty()) {
            ParserFactory.init();
        }
        return parsers.keySet();
    }

    public static Map<String, Parser> getParsers() {
        if (parsers.isEmpty()) {
            ParserFactory.init();
        }
        return parsers;
    }

    public static void setAliases(String ext, String[] aliases) {
        ContextProperties config = Context.get().getProperties();
        String pAlias = PARSER_ALIAS + ext.toLowerCase();
        if (aliases == null || aliases.length == 0) {
            config.setProperty(pAlias, "");
        } else {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                sb.append(",");
                sb.append(alias.trim());
                ++n2;
            }
            config.setProperty(pAlias, sb.substring(1));
        }
        try {
            config.write();
        }
        catch (IOException e) {
            log.warn("Unable to save context properties.", e);
        }
        ParserFactory.initAliases();
    }

    private static void initAliases() {
        aliases.clear();
        if (Context.get() == null) {
            return;
        }
        ContextProperties config = Context.get().getProperties();
        for (Object key : config.keySet()) {
            if (!key.toString().startsWith(PARSER_ALIAS)) continue;
            String ext = key.toString().substring(PARSER_ALIAS.length());
            StringTokenizer st = new StringTokenizer(config.getProperty(key.toString()), ",", false);
            while (st.hasMoreElements()) {
                String alias = (String)st.nextElement();
                aliases.put(alias.toLowerCase().trim(), ext);
            }
        }
    }
}

