/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.SlideShow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PPTParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(PPTParser.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                HSLFSlideShow slideshow = new HSLFSlideShow(input);
                try {
                    try (SlideShowExtractor slideShowExtractor = new SlideShowExtractor((SlideShow)slideshow);){
                        slideShowExtractor.setCommentsByDefault(true);
                        slideShowExtractor.setMasterByDefault(true);
                        slideShowExtractor.setNotesByDefault(true);
                        String tmp = slideShowExtractor.getText();
                        if (tmp != null) {
                            tmp = tmp.replaceAll("[\\p{Cntrl}&&[^\\n]]", " ");
                        }
                        content.append(StringUtil.writeToString(new StringReader(tmp)));
                    }
                    if (slideshow == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (slideshow == null) throw throwable;
                    slideshow.close();
                    throw throwable;
                }
                slideshow.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn("Failed to extract PowerPoint text content", e);
        }
    }

    @Override
    public int countPages(InputStream input, String filename) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (HSLFSlideShowImpl pptDoc = new HSLFSlideShowImpl(input);){
                return pptDoc.getSummaryInformation().getPageCount();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            return 1;
        }
    }
}

