/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.core.parser.ParsingException;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFParser
extends AbstractParser {
    private static final String CAN_NOT_GET_PDF_DOCUMENT_FOR_PARSING = "Can not get pdf document for parsing";
    private static final Logger log = LoggerFactory.getLogger(PDFParser.class);

    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) throws ParsingException {
        PDDocument pdfDocument = null;
        try {
            try {
                pdfDocument = PDDocument.load((InputStream)input);
                if (pdfDocument == null) {
                    throw new IOException(CAN_NOT_GET_PDF_DOCUMENT_FOR_PARSING);
                }
                if (pdfDocument.isEncrypted()) {
                    pdfDocument.close();
                    pdfDocument = PDDocument.load((InputStream)input, (String)"");
                }
                if (pdfDocument == null) {
                    throw new IOException(CAN_NOT_GET_PDF_DOCUMENT_FOR_PARSING);
                }
                this.parseDocument(pdfDocument, content);
                this.parseForm(pdfDocument, content);
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), ex);
                try {
                    if (pdfDocument != null) {
                        pdfDocument.close();
                    }
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
            }
        }
        finally {
            try {
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    protected void parseDocument(PDDocument pdfDocument, StringBuilder content) throws IOException {
        PDDocumentInformation information = pdfDocument.getDocumentInformation();
        if (information == null) {
            throw new IOException("Can not get information from pdf document");
        }
        PDFTextStripper stripper = new PDFTextStripper();
        int pages = pdfDocument.getNumberOfPages();
        int i = 1;
        while (i <= pages) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (CharArrayWriter writer = new CharArrayWriter();){
                    stripper.setStartPage(i);
                    stripper.setEndPage(i);
                    stripper.setPageEnd("\n");
                    stripper.setParagraphEnd("\n");
                    stripper.setAddMoreFormatting(false);
                    stripper.writeText(pdfDocument, (Writer)writer);
                    ((Writer)writer).flush();
                    content.append(((Object)writer).toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception tw) {
                log.error("Exception reading pdf document: {}", (Object)tw.getMessage());
            }
            ++i;
        }
    }

    private void parseForm(PDDocument pdfDocument, StringBuilder content) {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        if (docCatalog == null) {
            return;
        }
        PDAcroForm acroForm = docCatalog.getAcroForm();
        if (acroForm == null) {
            return;
        }
        List fields = acroForm.getFields();
        if (fields != null && !fields.isEmpty()) {
            content.append("\n");
            log.debug("{} top-level fields were found on the form", (Object)fields.size());
            for (PDField field : fields) {
                content.append(field.getPartialName());
                content.append(" = ");
                content.append(field.getValueAsString());
                content.append(" \n ");
            }
        }
    }

    @Override
    public int countPages(File file, String filename) {
        try {
            return this.internalCountPages(PDDocument.load((File)file));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn(e.getMessage(), e);
            }
            return 1;
        }
    }

    @Override
    public int countPages(InputStream input, String filename) {
        try {
            return this.internalCountPages(PDDocument.load((InputStream)input));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn(e.getMessage(), e);
            }
            return 1;
        }
    }

    private int internalCountPages(PDDocument pdfDocument) {
        try {
            if (pdfDocument == null) {
                throw new IOException(CAN_NOT_GET_PDF_DOCUMENT_FOR_PARSING);
            }
            int n = pdfDocument.getNumberOfPages();
            return n;
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                log.warn(ex.getMessage(), ex);
            }
            return 1;
        }
        finally {
            block14: {
                try {
                    if (pdfDocument != null) {
                        pdfDocument.close();
                    }
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block14;
                    log.warn(e.getMessage(), e);
                }
            }
        }
    }
}

