/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.IOUtil;
import com.logicaldoc.util.io.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OpenOfficeParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(OpenOfficeParser.class);

    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        block23: {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setValidating(false);
                SAXParser saxParser = factory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                File contentXml = FileUtil.createTempFile("openoffice-content", ".xml");
                try {
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (ZipUtil zipUtil = new ZipUtil();){
                        if (zipUtil.unzip(input, "content.xml", contentXml) <= 0L) break block23;
                        Throwable throwable2 = null;
                        Object var12_16 = null;
                        try (FileInputStream contentStream = new FileInputStream(contentXml);){
                            OpenOfficeContentHandler contentHandler = new OpenOfficeContentHandler();
                            xmlReader.setContentHandler(contentHandler);
                            xmlReader.parse(new InputSource(contentStream));
                            content.append(StringUtil.writeToString(new StringReader(contentHandler.getContent())));
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                finally {
                    FileUtil.delete(contentXml);
                }
            }
            catch (Exception e) {
                log.warn("Failed to extract OpenOffice text content", e);
            }
        }
    }

    @Override
    public int countPages(InputStream input, String filename) {
        File tmp = null;
        try {
            tmp = FileUtil.createTempFile("countpages", null);
            IOUtil.write(input, tmp);
            return this.countPages(tmp, filename);
        }
        catch (Exception e) {
            log.warn("Failed to extract OpenOffice metadata", e);
            return 1;
        }
    }

    @Override
    public int countPages(File input, String filename) {
        DefaultHandler metadataHandler;
        InputStream is;
        ZipUtil zipUtil;
        Object var7_13;
        XMLReader xmlReader;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException | SAXException e) {
            log.warn("Failed to extract OpenOffice metadata", e);
            return 1;
        }
        int pages = 1;
        try {
            Throwable throwable = null;
            var7_13 = null;
            try {
                zipUtil = new ZipUtil();
                try {
                    is = zipUtil.getEntryStream(input, "meta.xml");
                    try {
                        metadataHandler = new OpenOfficeMetadataHandler();
                        xmlReader.setContentHandler(metadataHandler);
                        xmlReader.parse(new InputSource(is));
                        if (((OpenOfficeMetadataHandler)metadataHandler).getPages() > pages) {
                            pages = ((OpenOfficeMetadataHandler)metadataHandler).getPages();
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    if (zipUtil != null) {
                        zipUtil.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (zipUtil != null) {
                        zipUtil.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception t) {
            log.warn("Failed to extract OpenOffice meta.xml entry", t);
        }
        try {
            Throwable t = null;
            var7_13 = null;
            try {
                zipUtil = new ZipUtil();
                try {
                    is = zipUtil.getEntryStream(input, "content.xml");
                    try {
                        metadataHandler = new OpenOfficePresentationMetadataHandler();
                        xmlReader.setContentHandler(metadataHandler);
                        xmlReader.parse(new InputSource(is));
                        if (((OpenOfficePresentationMetadataHandler)metadataHandler).getPages() > pages) {
                            pages = ((OpenOfficePresentationMetadataHandler)metadataHandler).getPages();
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    if (zipUtil != null) {
                        zipUtil.close();
                    }
                }
                catch (Throwable throwable) {
                    if (t == null) {
                        t = throwable;
                    } else if (t != throwable) {
                        t.addSuppressed(throwable);
                    }
                    if (zipUtil != null) {
                        zipUtil.close();
                    }
                    throw t;
                }
            }
            catch (Throwable throwable) {
                if (t == null) {
                    t = throwable;
                } else if (t != throwable) {
                    t.addSuppressed(throwable);
                }
                throw t;
            }
        }
        catch (Exception t) {
            log.warn("Failed to extract OpenOffice content.xml entry", t);
        }
        return pages;
    }

    private class OpenOfficeContentHandler
    extends DefaultHandler {
        private StringBuilder content = new StringBuilder();
        private boolean appendChar = false;
        private boolean appendNewline;

        public String getContent() {
            return this.content.toString();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (rawName.startsWith("text:")) {
                this.appendChar = true;
            }
            if (rawName.startsWith("text:p") || rawName.startsWith("text:index-title") || rawName.startsWith("text:title") || rawName.startsWith("text:list-item")) {
                this.appendNewline = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.appendNewline) {
                this.content.append("\n");
                this.appendNewline = false;
            }
            if (this.appendChar) {
                this.content.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.appendChar = false;
            this.appendNewline = false;
        }
    }

    private class OpenOfficeMetadataHandler
    extends DefaultHandler {
        int pages = -1;

        private OpenOfficeMetadataHandler() {
        }

        public int getPages() {
            return this.pages;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (rawName.toLowerCase().contains("document-statistic")) {
                int i = 0;
                while (i < atts.getLength()) {
                    if (atts.getQName(i).toLowerCase().contains("page-count")) {
                        this.pages = Integer.parseInt(atts.getValue(i));
                        return;
                    }
                    ++i;
                }
                i = 0;
                while (i < atts.getLength()) {
                    if (atts.getQName(i).toLowerCase().contains("table-count")) {
                        this.pages = Integer.parseInt(atts.getValue(i));
                        return;
                    }
                    ++i;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }
    }

    private class OpenOfficePresentationMetadataHandler
    extends DefaultHandler {
        int pages = -1;

        private OpenOfficePresentationMetadataHandler() {
        }

        public int getPages() {
            return this.pages;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (rawName.toLowerCase().endsWith(":page")) {
                this.pages = this.pages == -1 ? 1 : ++this.pages;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }
    }
}

